/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.api.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.StatState;
import net.infstudio.goki.api.stat.StatStorage;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapabilityStat {
    @CapabilityInject(value=StatStorage.class)
    public static Capability<StatStorage> STAT;

    public static void register() {
        CapabilityManager.INSTANCE.register(StatStorage.class, (Capability.IStorage)new Capability.IStorage<StatStorage>(){

            public NBTBase writeNBT(Capability<StatStorage> capability, StatStorage instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                instance.stateMap.forEach((stat, state) -> {
                    NBTTagCompound stateTag = new NBTTagCompound();
                    stateTag.func_74768_a("level", state.level);
                    stateTag.func_74768_a("revertedLevel", state.revertedLevel);
                    compound.func_74782_a(stat.getKey(), (NBTBase)stateTag);
                });
                return compound;
            }

            public void readNBT(Capability<StatStorage> capability, StatStorage instance, EnumFacing side, NBTBase nbt) {
                if (nbt instanceof NBTTagCompound) {
                    NBTTagCompound compound = (NBTTagCompound)nbt;
                    for (String stat : compound.func_150296_c()) {
                        if (!StatBase.statKeyMap.containsKey(stat)) continue;
                        NBTTagCompound stateTag = compound.func_74775_l(stat);
                        StatBase statBase = StatBase.statKeyMap.get(stat);
                        instance.stateMap.put(statBase, new StatState(statBase, stateTag.func_74762_e("level"), stateTag.func_74762_e("revertedLevel")));
                    }
                }
            }
        }, StatStorage::new);
    }

    public static class Provider
    implements ICapabilityProvider {
        public StatStorage statStorage = new StatStorage();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == STAT;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == STAT ? this.statStorage : null);
        }
    }
}

