/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import javax.annotation.Nonnull;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.client.gui.GuiStats;
import net.infstudio.goki.common.utils.DataHelper;
import net.infstudio.goki.common.utils.Reference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class GuiStatButton
extends GuiButton {
    public StatBase stat;
    public EntityPlayer player;
    public static final int INACTIVE_X = 0;
    public static final int ACTIVATED_X = 24;
    public static final int DISABLED_X = 48;
    public static final int MAXIMUM_X = 72;

    public GuiStatButton(int id, int x, int y, int width, int height, StatBase stat, EntityPlayer player) {
        super(id, x, y, width, height, "");
        this.stat = stat;
        this.player = player;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            int iconY = 24 * (this.stat.imageID % 10);
            int level = DataHelper.getPlayerStatLevel(this.player, this.stat);
            int cost = this.stat.getCost(level);
            int playerXP = DataHelper.getXPTotal(this.player);
            FontRenderer fontrenderer = mc.field_71466_p;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = this.isUnderMouse(mouseX, mouseY);
            int hoverState = this.func_146114_a(this.field_146123_n);
            int iconX = 0;
            if (hoverState == 2) {
                iconX = 24;
            }
            if (playerXP < cost) {
                iconX = 0;
            }
            if (level >= this.stat.getLimit()) {
                iconX = 72;
            }
            if (GuiScreen.func_146271_m()) {
                iconX = DataHelper.canPlayerRevertStat(this.player, this.stat) ? 24 : 48;
            }
            if (!this.stat.enabled) {
                iconX = 48;
            }
            String message = level + "";
            if (!this.stat.enabled) {
                iconX = 48;
                message = "X";
            }
            int messageColor = 0xFFFFFF;
            if (level >= this.stat.getLimit()) {
                message = "*" + level + "*";
                messageColor = 0xFFCC00;
            }
            iconX += this.stat.imageID % 20 / 10 * 24 * 4;
            if (this.stat.imageID >= 20) {
                mc.func_110434_K().func_110577_a(Reference.RPG_ICON_2_TEXTURE_LOCATION);
            } else {
                mc.func_110434_K().func_110577_a(Reference.RPG_ICON_TEXTURE_LOCATION);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
            GL11.glScalef((float)GuiStats.SCALE, (float)GuiStats.SCALE, (float)0.0f);
            this.func_73729_b(0, 0, iconX, iconY, this.field_146120_f, this.field_146121_g);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
            this.func_73732_a(fontrenderer, message, (int)((float)(this.field_146120_f / 2) * GuiStats.SCALE), (int)((float)this.field_146121_g * GuiStats.SCALE) + 2, messageColor);
            GL11.glPopMatrix();
        }
    }

    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && (float)mouseX < (float)this.field_146128_h + (float)this.field_146120_f * GuiStats.SCALE && (float)mouseY < (float)this.field_146129_i + (float)this.field_146121_g * GuiStats.SCALE;
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int mouseX, int mouseY) {
        return this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && (float)mouseX < (float)this.field_146128_h + (float)this.field_146120_f * GuiStats.SCALE && (float)mouseY < (float)this.field_146129_i + (float)this.field_146121_g * GuiStats.SCALE;
    }

    public String getHoverMessage(int which) {
        if (which == 0) {
            return this.stat.getLocalizedName() + " L" + DataHelper.getPlayerStatLevel(this.player, this.stat);
        }
        return this.stat.getLocalizedDescription(this.player);
    }
}

