/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;

public class GuiStatTooltip
extends Gui {
    private StatBase stat;
    private EntityPlayer player;
    private Minecraft mc = Minecraft.func_71410_x();
    private int padding = 4;

    public GuiStatTooltip(StatBase stat, EntityPlayer player) {
        this.stat = stat;
        this.player = player;
    }

    public void draw(int drawX, int drawY, int mouseButton) {
        int rightEdge;
        int right;
        int revertLevel;
        LinkedHashMap<String, Integer> messageColorMap = new LinkedHashMap<String, Integer>();
        AtomicInteger widthAtomic = new AtomicInteger();
        AtomicInteger heightAtomic = new AtomicInteger();
        int level = DataHelper.getPlayerStatLevel(this.player, this.stat);
        messageColorMap.put(this.stat.getLocalizedName() + " L" + level, -13312);
        messageColorMap.put(this.stat.getLocalizedDescription(this.player), -1);
        if (level >= this.stat.getLimit()) {
            messageColorMap.put(I18n.func_135052_a((String)"ui.max.name", (Object[])new Object[0]), -16724737);
        } else {
            messageColorMap.put(I18n.func_135052_a((String)"ui.cost.name", (Object[])new Object[0]) + this.stat.getCost(level) + "xp", -16724737);
        }
        if (GuiScreen.func_146271_m()) {
            messageColorMap.put(I18n.func_135052_a((String)"ui.return.name", (Object[])new Object[0]) + (float)this.stat.getCost(level) * GokiConfig.globalModifiers.globalRevertFactor + "xp", -16724737);
        }
        if ((revertLevel = DataHelper.getPlayerRevertStatLevel(this.player, this.stat)) > 0) {
            if (GokiConfig.globalModifiers.globalMaxRevertLevel != -1) {
                messageColorMap.put(I18n.func_135052_a((String)"ui.reverted.name", (Object[])new Object[]{revertLevel, String.valueOf(GokiConfig.globalModifiers.globalMaxRevertLevel)}), -16724737);
            } else {
                messageColorMap.put(I18n.func_135052_a((String)"ui.reverted.name", (Object[])new Object[]{revertLevel, I18n.func_135052_a((String)"ui.infinite.name", (Object[])new Object[0])}), -16724737);
            }
        }
        if (GuiScreen.func_146271_m()) {
            if (DataHelper.canPlayerRevertStat(this.player, this.stat)) {
                messageColorMap.put(I18n.func_135052_a((String)"ui.revert.name", (Object[])new Object[0]), -16488449);
            } else {
                messageColorMap.put(I18n.func_135052_a((String)"ui.norevert.name", (Object[])new Object[0]), -321024);
            }
        } else {
            messageColorMap.put(I18n.func_135052_a((String)"ui.hover.name", (Object[])new Object[0]), -16488449);
        }
        messageColorMap.forEach((text, color) -> {
            widthAtomic.set(Math.max(widthAtomic.get(), this.mc.field_71466_p.func_78256_a(text)));
            heightAtomic.addAndGet(this.mc.field_71466_p.field_78288_b);
        });
        int width = widthAtomic.get() + this.padding * 2;
        int height = heightAtomic.get() + this.padding * 2;
        int h = height / messageColorMap.size();
        int x = drawX - width / 2;
        int leftEdge = 0;
        int left = x;
        if (left < leftEdge) {
            x -= leftEdge - left + 1;
        }
        if ((right = x + width) > (rightEdge = this.mc.field_71462_r.field_146294_l)) {
            x += rightEdge - right - 1;
        }
        GuiStatTooltip.func_73734_a((int)x, (int)drawY, (int)(x + width), (int)(drawY - height), (int)-872415232);
        for (int i = messageColorMap.size(); i >= 1; --i) {
            Map.Entry entry = messageColorMap.entrySet().toArray(new Map.Entry[0])[messageColorMap.size() - i];
            this.func_73731_b(this.mc.field_71466_p, (String)entry.getKey(), x + this.padding / 2, drawY - h * i + this.padding / 2, (Integer)entry.getValue());
        }
        this.drawBorder(x, drawY, width, height, -1);
    }

    private void drawBorder(int x, int y, int width, int height, int borderColor) {
        this.func_73730_a(x - 1, x + width, y, borderColor);
        this.func_73730_a(x - 1, x + width, y - height, borderColor);
        this.func_73728_b(x - 1, y, y - height, borderColor);
        this.func_73728_b(x + width, y, y - height, borderColor);
    }
}

