/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.config;

import java.lang.reflect.Type;
import net.infstudio.goki.common.config.ConfigManager;

public interface Configurable<T> {
    public T createConfig();

    default public void saveConfig() {
        this.save();
        ConfigManager.INSTANCE.getConfigMap().put(this.getKey(), this.getConfig());
        ConfigManager.INSTANCE.saveConfig(this.getKey());
    }

    default public Type getType() {
        return this.createConfig().getClass();
    }

    default public void reloadConfig() {
        ConfigManager.INSTANCE.registerConfig(this.getKey(), this.getType());
        if (!ConfigManager.INSTANCE.hasConfig(this.getKey())) {
            ConfigManager.INSTANCE.createConfig(this.getKey(), this.createConfig());
        }
        ConfigManager.INSTANCE.reloadConfig(this.getKey());
        this.reload();
    }

    public void save();

    public void reload();

    public String getKey();

    default public T getConfig() {
        return ConfigManager.INSTANCE.getOrCreateConfig(this.getKey(), this.createConfig());
    }
}

