/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.S2CSyncAll;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TickHandler {
    public static final UUID knockbackResistanceID = UUID.randomUUID();
    public static final UUID stealthSpeedID = UUID.randomUUID();
    public static final UUID swimSpeedID = UUID.randomUUID();
    public static AtomicInteger tickTimer = new AtomicInteger();

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            this.handleTaskPlayerAPI(player);
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier mod = new AttributeModifier(stealthSpeedID, "SneakSpeed", (double)(Stats.STEALTH.getBonus(player) / 100.0f), 1);
            if (player.func_70093_af()) {
                if (atinst.func_111127_a(stealthSpeedID) == null) {
                    atinst.func_111121_a(mod);
                }
            } else if (atinst.func_111127_a(stealthSpeedID) != null) {
                atinst.func_111124_b(mod);
            }
            atinst = player.func_110148_a(SharedMonsterAttributes.field_111266_c);
            mod = new AttributeModifier(knockbackResistanceID, "KnockbackResistance", (double)Stats.STEADY_GUARD.getBonus(player), 0);
            if (player.func_184585_cz()) {
                if (atinst.func_111127_a(knockbackResistanceID) == null) {
                    atinst.func_111121_a(mod);
                }
            } else if (atinst.func_111127_a(knockbackResistanceID) != null) {
                atinst.func_111124_b(mod);
            }
            this.handleFurnace(player);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (tickTimer.get() == GokiConfig.syncTicks) {
                tickTimer.lazySet(0);
                for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                    GokiPacketHandler.CHANNEL.sendTo((IMessage)new S2CSyncAll((EntityPlayer)player), player);
                }
            } else {
                tickTimer.getAndIncrement();
            }
        }
    }

    public static boolean isJumping(EntityLivingBase livingBase) {
        Field field = null;
        try {
            field = EntityLivingBase.class.getDeclaredField("field_70703_bu");
        }
        catch (NoSuchFieldException e) {
            try {
                field = EntityLivingBase.class.getDeclaredField("isJumping");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
        if (field != null) {
            field.setAccessible(true);
            try {
                return field.getBoolean(livingBase);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void handleTaskPlayerAPI(EntityPlayer player) {
        float multiplier;
        if ((player.func_70613_aW() || player.func_184186_bw()) && player.func_70090_H() && !player.field_71075_bZ.field_75100_b) {
            multiplier = Math.max(0.0f, Stats.SWIMMING.getBonus(player));
            if (TickHandler.isJumping((EntityLivingBase)player)) {
                player.field_70747_aH += multiplier;
            } else if (multiplier > 0.0f) {
                double d0 = player.field_70163_u;
                float f1 = 0.8f;
                float f2 = 0.02f;
                if (multiplier > 0.0f) {
                    f1 += (0.54600006f - f1) * multiplier;
                    f2 += (player.func_70689_ay() - f2) * multiplier;
                }
                player.func_191958_b(player.field_70702_br, player.field_70701_bs, player.field_191988_bg, f2);
                player.func_70091_d(MoverType.SELF, player.field_70159_w, player.field_70181_x, player.field_70179_y);
                player.field_70159_w *= (double)f1;
                player.field_70181_x *= (double)0.8f;
                player.field_70179_y *= (double)f1;
                if (!player.func_189652_ae()) {
                    player.field_70181_x -= 0.02;
                }
                if (player.field_70123_F && player.func_70038_c(player.field_70159_w, player.field_70181_x + (double)0.6f - player.field_70163_u + d0, player.field_70179_y)) {
                    player.field_70181_x = 0.3f;
                }
                player.func_70091_d(MoverType.SELF, (double)(player.field_70702_br * multiplier), (double)(player.field_70701_bs * multiplier), (double)0.02f);
            }
        }
        if (player.func_70617_f_() && !player.func_70093_af()) {
            multiplier = Stats.CLIMBING.getBonus(player);
            player.func_70091_d(MoverType.SELF, player.field_70159_w, player.field_70181_x * (double)multiplier, player.field_70179_y);
        }
    }

    private void handleFurnace(EntityPlayer player) {
        if (DataHelper.getPlayerStatLevel(player, Stats.FURNACE_FINESSE) > 0) {
            ArrayList<TileEntityFurnace> furnacesAroundPlayer = new ArrayList<TileEntityFurnace>();
            for (TileEntity listEntity : player.field_70170_p.field_147482_g) {
                if (listEntity == null) continue;
                TileEntity tileEntity = listEntity;
                BlockPos pos = tileEntity.func_174877_v();
                if (!(tileEntity instanceof TileEntityFurnace) || !((double)MathHelper.func_76133_a((double)player.func_174818_b(pos)) < 4.0)) continue;
                furnacesAroundPlayer.add((TileEntityFurnace)tileEntity);
            }
            for (TileEntityFurnace furnace : furnacesAroundPlayer) {
                if (!furnace.func_145950_i()) continue;
                int i = 0;
                while ((float)i < Stats.FURNACE_FINESSE.getBonus(player)) {
                    furnace.func_73660_a();
                    ++i;
                }
            }
        }
    }
}

