/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat;

import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class StatReaper
extends StatBase {
    public StatReaper(int id, String key, int limit) {
        super(id, key, limit);
    }

    @Override
    public float getBonus(int level) {
        return StatReaper.getFinalBonus((float)Math.pow(level, 1.0768) * 0.0025f);
    }

    @Override
    public float[] getDescriptionFormatArguments(EntityPlayer player) {
        return new float[]{DataHelper.trimDecimals(this.getBonus(this.getPlayerStatLevel(player)) * 100.0f, 1), GokiConfig.support.reaperLimit};
    }

    @Override
    public String getLocalizedDescription(EntityPlayer player) {
        return I18n.func_135052_a((String)(this.key + ".des"), (Object[])new Object[]{Float.valueOf(this.getDescriptionFormatArguments(player)[0]), Float.valueOf(this.getDescriptionFormatArguments(player)[1])});
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[0] != null && !(obj[0] instanceof EntityPlayer) && obj[0] instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)obj[0];
            return target.func_110138_aP() <= GokiConfig.support.reaperLimit;
        }
        return false;
    }
}

