/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.stats.TreasureFinderConfig;
import net.infstudio.goki.common.stat.tool.TreasureFinderEntry;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class StatTreasureFinder
extends StatBase<TreasureFinderConfig> {
    public static List<TreasureFinderEntry> entries = new ArrayList<TreasureFinderEntry>();
    public static TreasureFinderEntry[] defaultEntries = new TreasureFinderEntry[]{new TreasureFinderEntry((Block)Blocks.field_150354_m, 0, Items.field_151074_bl, 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151078_bh, 0, 1, 40), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151103_aS, 0, 1, 20), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151070_bp, 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151016_H, 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151123_aH, 0, 1, 10), new TreasureFinderEntry((Block)Blocks.field_150354_m, 0, Items.field_151069_bo, 0, 1, 10), new TreasureFinderEntry((Block)Blocks.field_150354_m, 0, Items.field_151113_aN, 0, 1, 5), new TreasureFinderEntry((Block)Blocks.field_150354_m, 0, Items.field_151111_aL, 0, 1, 5), new TreasureFinderEntry((Block)Blocks.field_150354_m, 0, Items.field_151119_aD, 0, 1, 20), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151054_z, 0, 1, 6), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151174_bG, 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151172_bF, 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151034_e, 0, 1, 10), new TreasureFinderEntry((Block)Blocks.field_150362_t, 0, Items.field_151034_e, 0, 1, 10), new TreasureFinderEntry((Block)Blocks.field_150361_u, 0, Items.field_151034_e, 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150337_Q), 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150338_P), 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150328_O), 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150327_N), 0, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151055_y, 0, 1, 100), new TreasureFinderEntry((Block)Blocks.field_150329_H, 0, Items.field_151080_bb, 0, 1, 30), new TreasureFinderEntry((Block)Blocks.field_150329_H, 0, Items.field_151081_bc, 0, 1, 30), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151082_bd, 0, 2, 50), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151147_al, 0, 2, 50), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151076_bf, 0, 2, 50), new TreasureFinderEntry((Block)Blocks.field_150354_m, 0, Items.field_151042_j, 0, 2, 10), new TreasureFinderEntry((Block)Blocks.field_150354_m, 0, Items.field_151043_k, 0, 2, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151116_aA, 0, 2, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151008_G, 0, 2, 10), new TreasureFinderEntry(Blocks.field_150346_d, 0, Item.func_150898_a((Block)Blocks.field_150325_L), 0, 2, 10), new TreasureFinderEntry((Block)Blocks.field_150354_m, 0, Items.field_151137_ax, 0, 2, 50), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151133_ar, 0, 3, 20), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151086_cn, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151096_cd, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151094_cf, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151093_ce, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151091_cg, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151092_ch, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151089_ci, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151090_cj, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151087_ck, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151088_cl, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151084_co, 0, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, 0, Items.field_151085_cm, 0, 3, 2)};

    public StatTreasureFinder(int id, String key, int limit) {
        super(id, key, limit);
        Collections.addAll(entries, defaultEntries);
    }

    @Override
    public String getLocalizedDescription(EntityPlayer player) {
        if (this.getPlayerStatLevel(player) == 0) {
            return I18n.func_135052_a((String)(this.key + ".des0"), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)(this.key + ".des1"), (Object[])new Object[0]);
    }

    @Override
    public void save() {
        super.save();
        ((TreasureFinderConfig)this.getConfig()).entries.clear();
        ((TreasureFinderConfig)this.getConfig()).entries.addAll(entries);
    }

    @Override
    public TreasureFinderConfig createConfig() {
        TreasureFinderConfig config = new TreasureFinderConfig();
        Collections.addAll(config.entries, defaultEntries);
        return config;
    }

    @Override
    public void reload() {
        super.reload();
        entries.clear();
        entries.addAll(((TreasureFinderConfig)this.getConfig()).entries);
    }

    public List<ItemStack> getApplicableItemStackList(Block block, int blockMD, int level) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (TreasureFinderEntry tfe : entries) {
            if (tfe.minimumLevel > level || (tfe.getBlock() != null || block != Blocks.field_150346_d && block != Blocks.field_150349_c) && (tfe.getBlock() != block || tfe.blockMetadata != blockMD)) continue;
            items.add(new ItemStack(tfe.getItem(), 1, tfe.itemMetadata));
        }
        return items;
    }

    public IntList getApplicableChanceList(Block block, int blockMD, int level) {
        IntArrayList chance = new IntArrayList();
        for (TreasureFinderEntry tfe : entries) {
            if (tfe.minimumLevel > level || (tfe.getBlock() != null || block != Blocks.field_150346_d && block != Blocks.field_150349_c) && (tfe.getBlock() != block || tfe.blockMetadata != blockMD)) continue;
            chance.add(tfe.chance);
        }
        return chance;
    }

    @Override
    public int getCost(int level) {
        int cost = 170;
        if (level == 1) {
            cost = 370;
        } else if (level == 2) {
            cost = 820;
        }
        return cost;
    }

    @Override
    public int getLimit() {
        return 3;
    }

    @Override
    public float getBonus(int level) {
        return 0.0f;
    }
}

