/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.stats.ToolSpecificConfig;
import net.infstudio.goki.common.stat.tool.ItemIdMetadataTuple;
import net.infstudio.goki.common.stat.tool.ItemIdMetadataTupleComparator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class ToolSpecificStat
extends StatBase<ToolSpecificConfig> {
    public List<ItemIdMetadataTuple> supports = new ArrayList<ItemIdMetadataTuple>();

    public ToolSpecificStat(int id, String key, int limit) {
        super(id, key, limit);
    }

    public abstract String getConfigurationKey();

    public abstract String[] getDefaultSupportedItems();

    @Override
    public ToolSpecificConfig createConfig() {
        ToolSpecificConfig config = new ToolSpecificConfig();
        Arrays.stream(this.getDefaultSupportedItems()).map(ItemIdMetadataTuple::new).forEach(config.supports::add);
        return config;
    }

    @Override
    public void save() {
        super.save();
        ((ToolSpecificConfig)this.getConfig()).supports.clear();
        ((ToolSpecificConfig)this.getConfig()).supports.addAll(this.supports);
    }

    @Override
    public void reload() {
        super.reload();
        this.supports.clear();
        this.supports.addAll(((ToolSpecificConfig)this.getConfig()).supports);
    }

    public void addSupportForItem(ItemStack item) {
        ItemIdMetadataTuple iimt;
        this.reloadConfig();
        if (item == null) {
            return;
        }
        boolean hasSubtypes = item.func_77981_g();
        int id = Item.func_150891_b((Item)item.func_77973_b());
        int meta = 0;
        if (hasSubtypes) {
            meta = item.func_77952_i();
        }
        if (!this.supports.contains(iimt = new ItemIdMetadataTuple(item.func_77973_b().getRegistryName().toString(), meta))) {
            this.supports.add(iimt);
        }
        this.saveConfig();
    }

    public void removeSupportForItem(ItemStack item) {
        if (item != null) {
            ItemIdMetadataTupleComparator iimtc = new ItemIdMetadataTupleComparator();
            this.reloadConfig();
            ItemIdMetadataTuple iimt = new ItemIdMetadataTuple(item.func_77973_b().getRegistryName().toString(), 0);
            if (item.func_77981_g()) {
                iimt.metadata = item.func_77952_i();
            }
            for (int i = 0; i < this.supports.size(); ++i) {
                ItemIdMetadataTuple ii = this.supports.get(i);
                if (iimtc.compare(iimt, ii) != 1) continue;
                this.supports.remove(ii);
                --i;
            }
            this.saveConfig();
        }
    }

    public boolean isItemSupported(ItemStack item) {
        for (ItemIdMetadataTuple iimt : this.supports) {
            if (!Objects.equals(item.func_77973_b().getRegistryName().toString(), iimt.id)) continue;
            if (item.func_77981_g() && item.func_77952_i() == iimt.metadata) {
                return true;
            }
            if (item.func_77981_g()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[0] != null && obj[0] instanceof ItemStack) {
            ItemStack item = (ItemStack)obj[0];
            return this.isItemSupported(item);
        }
        return false;
    }

    @Override
    public float getAppliedBonus(EntityPlayer player, Object object) {
        if (this.isEffectiveOn(object)) {
            return this.getBonus(player);
        }
        return 0.0f;
    }
}

