/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.utils;

import java.util.function.IntFunction;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;

public class DataHelper {
    public static NBTTagCompound getPlayerPersistentNBT(EntityPlayer player) {
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        if (!nbt.func_74764_b("gokistats_Stats")) {
            nbt.func_74782_a("gokistats_Stats", (NBTBase)new NBTTagCompound());
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)nbt);
        }
        return nbt;
    }

    public static boolean canPlayerRevertStat(EntityPlayer player, StatBase stat) {
        return GokiConfig.globalModifiers.globalMaxRevertLevel == -1 || GokiConfig.globalModifiers.globalMaxRevertLevel >= 0 && DataHelper.getPlayerRevertStatLevel(player, stat) < GokiConfig.globalModifiers.globalMaxRevertLevel && DataHelper.getPlayerStatLevel(player, stat) > 0;
    }

    public static int getPlayerRevertStatLevel(EntityPlayer player, StatBase stat) {
        NBTTagCompound nbt = DataHelper.getPlayerPersistentNBT(player);
        if (nbt.func_74764_b("gokistats_Stats")) {
            return ((NBTTagCompound)nbt.func_74781_a("gokistats_Stats")).func_74762_e(stat.getKey() + ".revert");
        }
        return 0;
    }

    public static int setPlayerRevertStatLevel(EntityPlayer player, StatBase stat, int level) {
        NBTTagCompound nbt = DataHelper.getPlayerPersistentNBT(player);
        if (nbt.func_74764_b("gokistats_Stats")) {
            ((NBTTagCompound)nbt.func_74781_a("gokistats_Stats")).func_74768_a(stat.getKey() + ".revert", (int)((byte)level));
        }
        return 0;
    }

    public static int getPlayerStatLevel(EntityPlayer player, StatBase stat) {
        NBTTagCompound nbt = DataHelper.getPlayerPersistentNBT(player);
        if (nbt.func_74764_b("gokistats_Stats")) {
            return ((NBTTagCompound)nbt.func_74781_a("gokistats_Stats")).func_74762_e(stat.getKey());
        }
        return 0;
    }

    public static void setPlayerStatLevel(EntityPlayer player, StatBase stat, int level) {
        NBTTagCompound nbt = DataHelper.getPlayerPersistentNBT(player);
        if (nbt.func_74764_b("gokistats_Stats")) {
            ((NBTTagCompound)nbt.func_74781_a("gokistats_Stats")).func_74768_a(stat.getKey(), (int)((byte)level));
        }
    }

    public static void multiplyPlayerStatLevel(EntityPlayer player, StatBase stat, IntFunction<Integer> multiplier) {
        DataHelper.setPlayerStatLevel(player, stat, multiplier.apply(DataHelper.getPlayerStatLevel(player, stat)));
    }

    public static float trimDecimals(float in, int decimals) {
        float f = (float)((double)in * Math.pow(10.0, decimals));
        int i = (int)f;
        return (float)i / (float)Math.pow(10.0, decimals);
    }

    public static void setPlayersExpTo(EntityPlayer player, int total) {
        player.field_71106_cc = 0.0f;
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.func_71023_q(total);
    }

    public static int getXPTotal(int xpLevel, float current) {
        return (int)((float)DataHelper.getXPValueFromLevel(xpLevel) + (float)DataHelper.getXPValueToNextLevel(xpLevel) * current);
    }

    public static int getXPTotal(EntityPlayer player) {
        return (int)((float)DataHelper.getXPValueFromLevel(player.field_71068_ca) + (float)DataHelper.getXPValueToNextLevel(player.field_71068_ca) * player.field_71106_cc);
    }

    public static int getXPValueFromLevel(int xpLevel) {
        int val = xpLevel > 31 ? (int)(4.5 * Math.pow(xpLevel, 2.0) - 162.5 * (double)xpLevel + 2220.0) : (xpLevel > 16 ? (int)(2.5 * Math.pow(xpLevel, 2.0) - 40.5 * (double)xpLevel + 360.0) : (int)(Math.pow(xpLevel, 2.0) + 6.0 * (double)xpLevel));
        return val;
    }

    public static int getXPValueToNextLevel(int xpLevel) {
        int val = xpLevel > 30 ? 9 * xpLevel - 158 : (xpLevel > 15 ? 5 * xpLevel - 38 : 2 * xpLevel + 7);
        return val;
    }

    public static float getDamageDealt(EntityPlayer player, Entity target, DamageSource source) {
        float damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float bonusDamage = 0.0f;
        boolean targetIsLiving = target instanceof EntityLivingBase;
        ItemStack stack = player.func_184614_ca();
        if (targetIsLiving) {
            bonusDamage = EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)((EntityLivingBase)target).func_70668_bt());
        }
        if (damage > 0.0f || bonusDamage > 0.0f) {
            boolean critical;
            boolean bl = critical = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.func_180142_b((String)"blindness")) && player.func_184187_bx() == null && targetIsLiving;
            if (critical && damage > 0.0f) {
                damage *= 1.5f;
            }
            damage += bonusDamage;
        }
        return damage;
    }

    public static float getFallResistance(EntityLivingBase entity) {
        float resistance = 3.0f;
        PotionEffect potioneffect = entity.func_70660_b(MobEffects.field_76430_j);
        float bonus = potioneffect != null ? (float)(potioneffect.func_76458_c() + 1) : 0.0f;
        return resistance + bonus;
    }
}

