/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.mods.grapple_hooks;

import de.intektor.mods.grapple_hooks.EntityGrappleHook;
import de.intektor.mods.grapple_hooks.GrappleHooks;
import de.intektor.mods.grapple_hooks.HookTier;
import de.intektor.mods.grapple_hooks.caps.CapUtilKt;
import de.intektor.mods.grapple_hooks.caps.GrappleHookEntityCap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="grapple_hooks", bus=Mod.EventBusSubscriber.Bus.FORGE)
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lde/intektor/mods/grapple_hooks/CommonEventHandler;", "", "()V", "playerLogin", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "playerTick", "Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;", "grapple_hooks"})
public final class CommonEventHandler {
    public static final CommonEventHandler INSTANCE;

    @JvmStatic
    @SubscribeEvent
    public static final void playerTick(@NotNull TickEvent.PlayerTickEvent event) {
        EntityGrappleHook hook;
        PlayerEntity shooter;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PlayerEntity playerEntity = shooter = event.player;
        Intrinsics.checkNotNullExpressionValue((Object)playerEntity, (String)"shooter");
        GrappleHookEntityCap grappleHookEntityCap = (GrappleHookEntityCap)CapUtilKt.get$default((ICapabilityProvider)playerEntity, GrappleHookEntityCap.Companion.getCap(), null, 2, null);
        EntityGrappleHook entityGrappleHook = hook = grappleHookEntityCap != null ? grappleHookEntityCap.getEntity() : null;
        if (hook != null && hook.func_70089_S()) {
            if (event.phase == TickEvent.Phase.START) {
                HookTier hookTier = hook.getTier();
                double dragStrength = (0.8 + (hookTier != null ? hookTier.getDragSpeedModifier(hook.getPullSpeedLevel()) : 0.0)) * (GrappleHooks.Companion.getConfig().getUseRealisticGrappling() ? 0.4 : 1.0);
                Vector3d dragVector = new Vector3d(hook.func_226277_ct_() - shooter.func_226277_ct_(), hook.func_226278_cu_() - (shooter.func_226278_cu_() + (double)shooter.func_70047_e()), hook.func_226281_cx_() - shooter.func_226281_cx_()).func_72432_b().func_186678_a(dragStrength);
                double dX = shooter.func_226277_ct_() - hook.func_226277_ct_();
                double dY = (double)shooter.func_70047_e() + shooter.func_226278_cu_() - hook.func_226278_cu_();
                double dZ = shooter.func_226281_cx_() - hook.func_226281_cx_();
                double distance = dX * dX + dY * dY + dZ * dZ;
                if (hook.isDragging()) {
                    boolean prevStoppedPlayer = hook.getStoppedPlayer();
                    if (hook.isHookStopped()) {
                        if (!hook.getStoppedPlayer()) {
                            hook.setStoppedPlayer(true);
                        } else if (shooter instanceof LivingEntity) {
                            Vector3d shooterEyePos;
                            boolean bl = false;
                            double distanceNormal = Math.sqrt(distance);
                            boolean bl2 = false;
                            double d = Math.abs(dY) / distanceNormal;
                            boolean bl3 = false;
                            double angle = Math.asin(d);
                            dragVector = Vector3d.field_186680_a;
                            double ropeLengthOffset = distanceNormal - (double)hook.getStoppedHookLength();
                            Vector3d vector3d = shooterEyePos = shooter.func_213303_ch().func_72441_c(0.0, (double)shooter.func_70047_e(), 0.0);
                            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"shooterEyePos");
                            Vector3d forceAmount = hook.getGoalOffset$grapple_hooks(vector3d);
                            if (ropeLengthOffset > 0.0) {
                                if (forceAmount.func_72433_c() >= 0.01) {
                                    shooter.func_213315_a(MoverType.SELF, forceAmount);
                                    shooter.field_70143_R = 0.0f;
                                }
                                double d2 = shooter.func_213322_ci().field_72448_b;
                                boolean bl4 = false;
                                double forceDown = Math.abs(d2);
                                double d3 = -dZ;
                                boolean bl5 = false;
                                double angleTowards = Math.atan2(d3, dX);
                                boolean bl6 = false;
                                bl6 = false;
                                bl6 = false;
                                bl6 = false;
                                dragVector = dragVector.func_178787_e(new Vector3d(-Math.cos(angleTowards) * Math.cos(angle) * forceDown, forceAmount.field_72448_b, Math.sin(angleTowards) * Math.cos(angle) * forceDown));
                            } else {
                                dragVector = dragVector.func_216372_d(0.0, 0.0, 0.0);
                            }
                        }
                    } else if (distance < (double)5) {
                        double prop = distance / (double)5;
                        dragVector = dragVector.func_186678_a(prop);
                    }
                    if (!prevStoppedPlayer && !GrappleHooks.Companion.getConfig().getUseRealisticGrappling()) {
                        shooter.func_213317_d(dragVector);
                    } else {
                        shooter.func_213317_d(shooter.func_213322_ci().func_186678_a(1.0204081632653061).func_178787_e(dragVector));
                    }
                }
            } else if (event.phase == TickEvent.Phase.END && hook.isHookStopped() && !hook.isReturning() && GrappleHooks.Companion.getConfig().getUseRealisticGrappling() && GrappleHooks.Companion.getConfig().getApplySwingDamage()) {
                if (shooter.field_70123_F && !shooter.field_70170_p.field_72995_K) {
                    double horizontalMotionAmount = LivingEntity.func_213296_b((Vector3d)hook.getPrevShooterMotion());
                    double d = shooter.func_213322_ci().field_72448_b;
                    boolean bl = false;
                    double d4 = Math.sqrt(horizontalMotionAmount);
                    boolean bl7 = false;
                    double verticalAngle = Math.atan2(d, d4);
                    boolean bl8 = false;
                    double approxDamage = horizontalMotionAmount * Math.sin(verticalAngle) * 10.0;
                    if (approxDamage >= 1.0) {
                        shooter.func_70097_a(DamageSource.field_188406_j, (float)approxDamage);
                    }
                }
                Vector3d vector3d = shooter.func_213322_ci();
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"shooter.motion");
                hook.setPrevShooterMotion(vector3d);
            }
        }
    }

    @JvmStatic
    @SubscribeEvent
    public static final void playerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            PlayerEntity playerEntity = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)playerEntity, (String)"event.player");
            GrappleHookEntityCap cap = GrappleHookEntityCap.Companion.forPlayer(playerEntity);
            CompoundNBT hookData = cap.getGrappleEntityData();
            if (hookData != null) {
                cap.setGrappleEntityData(null);
                Entity entity = EntityType.func_220335_a((CompoundNBT)hookData, (World)event.getPlayer().field_70170_p, (Function)new Function<Entity, Entity>(event){
                    final /* synthetic */ PlayerEvent.PlayerLoggedInEvent $event;

                    public final Entity apply(Entity newEntity) {
                        Entity entity = newEntity;
                        boolean bl = false;
                        boolean bl2 = false;
                        Entity it = entity;
                        boolean bl3 = false;
                        this.$event.getPlayer().field_70170_p.func_217376_c(it);
                        return entity;
                    }
                    {
                        this.$event = playerLoggedInEvent;
                    }
                });
                if (!(entity instanceof EntityGrappleHook)) {
                    entity = null;
                }
                cap.setEntity((EntityGrappleHook)entity);
            }
        }
    }

    private CommonEventHandler() {
    }

    static {
        CommonEventHandler commonEventHandler;
        INSTANCE = commonEventHandler = new CommonEventHandler();
    }
}

