/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.mods.grapple_hooks;

import de.intektor.mods.grapple_hooks.EntityGrappleHook;
import de.intektor.mods.grapple_hooks.GrappleHooks;
import de.intektor.mods.grapple_hooks.HookTier;
import de.intektor.mods.grapple_hooks.VecmathKt;
import de.intektor.mods.grapple_hooks.caps.GrappleHookEntityCap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lde/intektor/mods/grapple_hooks/HookItem;", "Lnet/minecraft/item/Item;", "properties", "Lnet/minecraft/item/Item$Properties;", "tier", "Lde/intektor/mods/grapple_hooks/HookTier;", "(Lnet/minecraft/item/Item$Properties;Lde/intektor/mods/grapple_hooks/HookTier;)V", "getTier", "()Lde/intektor/mods/grapple_hooks/HookTier;", "getIsRepairable", "", "toRepair", "Lnet/minecraft/item/ItemStack;", "repair", "getItemEnchantability", "", "stack", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "grapple_hooks"})
public final class HookItem
extends Item {
    @NotNull
    private final HookTier tier;

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull Hand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K && player instanceof ServerPlayerEntity) {
            boolean spawnNewHook;
            boolean bl;
            GrappleHookEntityCap cap = GrappleHookEntityCap.Companion.forPlayer(player);
            EntityGrappleHook currentHook = cap.getEntity();
            if (currentHook != null) {
                if (currentHook.isDragging()) {
                    if (currentHook.isHookStopped()) {
                        currentHook.func_70106_y();
                        cap.setEntity(null);
                        bl = true;
                    } else {
                        currentHook.stopHook();
                        bl = false;
                    }
                } else if (currentHook.isReturning()) {
                    currentHook.func_70106_y();
                    cap.setEntity(null);
                    bl = true;
                } else {
                    currentHook.setReturning(true);
                    bl = false;
                }
            } else {
                bl = spawnNewHook = true;
            }
            if (spawnNewHook) {
                int pullSpeedLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)GrappleHooks.Companion.getPullSpeedEnchantment().get()), (ItemStack)heldItem);
                int additionalRangeLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)GrappleHooks.Companion.getRopeDistanceEnchantment().get()), (ItemStack)heldItem);
                EntityGrappleHook newHook = new EntityGrappleHook(world, this.tier, pullSpeedLevel, additionalRangeLevel);
                double pitch = Math.toRadians(player.field_70125_A);
                double yaw = Math.toRadians(player.field_70177_z);
                boolean bl2 = false;
                bl2 = false;
                double motionX = -Math.sin(yaw) * Math.cos(pitch);
                boolean bl3 = false;
                double motionY = -Math.sin(pitch);
                boolean bl4 = false;
                bl4 = false;
                double motionZ = Math.cos(yaw) * Math.cos(pitch);
                Vector3d vector3d = VecmathKt.times(new Vector3d(motionX, motionY, motionZ), 10.0);
                Vector3d vector3d2 = ((ServerPlayerEntity)player).func_213322_ci();
                Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"player.motion");
                newHook.func_213317_d(VecmathKt.plus(vector3d, vector3d2));
                newHook.func_70107_b(((ServerPlayerEntity)player).func_226277_ct_(), ((ServerPlayerEntity)player).func_226278_cu_() + (double)((ServerPlayerEntity)player).func_70047_e(), ((ServerPlayerEntity)player).func_226281_cx_());
                newHook.func_212361_a((Entity)player);
                if (world.func_217376_c((Entity)newHook)) {
                    cap.setEntity(newHook);
                    heldItem.func_222118_a(1, (LivingEntity)player, (Consumer)new Consumer<ServerPlayerEntity>(player, hand){
                        final /* synthetic */ PlayerEntity $player;
                        final /* synthetic */ Hand $hand;

                        public final void accept(ServerPlayerEntity it) {
                            this.$player.func_213334_d(this.$hand);
                        }
                        {
                            this.$player = playerEntity;
                            this.$hand = hand;
                        }
                    });
                    ActionResult actionResult = ActionResult.func_226249_b_((Object)heldItem);
                    Intrinsics.checkNotNullExpressionValue((Object)actionResult, (String)"ActionResult.resultConsume(heldItem)");
                    return actionResult;
                }
            }
        }
        ActionResult actionResult = ActionResult.func_226248_a_((Object)heldItem);
        Intrinsics.checkNotNullExpressionValue((Object)actionResult, (String)"ActionResult.resultSuccess(heldItem)");
        return actionResult;
    }

    public boolean func_82789_a(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        Intrinsics.checkNotNullParameter((Object)toRepair, (String)"toRepair");
        Intrinsics.checkNotNullParameter((Object)repair, (String)"repair");
        Ingredient ingredient = this.tier.getRepairMaterial();
        if (ingredient == null) {
            return false;
        }
        return ingredient.test(repair);
    }

    public int getItemEnchantability(@Nullable ItemStack stack) {
        return this.tier.getEnchantability();
    }

    @NotNull
    public final HookTier getTier() {
        return this.tier;
    }

    public HookItem(@NotNull Item.Properties properties, @NotNull HookTier tier) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"tier");
        super(properties);
        this.tier = tier;
    }
}

