/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.haema;

import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import com.williambl.haema.HaemaKt;
import com.williambl.haema.damagesource.BloodLossDamageSource;
import com.williambl.haema.effect.VampiricStrengthEffect;
import com.williambl.haema.effect.VampiricWeaknessEffect;
import com.williambl.haema.entity.VampireHunterSpawner;
import com.williambl.haema.util.EntityAttributeInstanceExtensionsKt;
import com.williambl.haema.util.HaemaGameRulesKt;
import io.netty.buffer.Unpooled;
import java.util.Random;
import java.util.UUID;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_4139;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0004J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0017H\u0017J\u001c\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0017J \u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0016\u0010!\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0011J\u0012\u0010'\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0006\u0010*\u001a\u00020\u0004J\b\u0010+\u001a\u00020\u0015H\u0017J\u0016\u0010,\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0017J\u000e\u0010-\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0004J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0015H\u0017J\u0010\u00100\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0011H\u0002J\u0012\u00101\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0012\u00102\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0011H\u0016R$\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/williambl/haema/VampireBloodManager;", "Lnet/minecraft/entity/player/HungerManager;", "()V", "absoluteBloodLevel", "", "absoluteBloodLevel$annotations", "getAbsoluteBloodLevel", "()D", "setAbsoluteBloodLevel", "(D)V", "lastFed", "", "getLastFed", "()J", "setLastFed", "(J)V", "owner", "Lnet/minecraft/entity/player/PlayerEntity;", "add", "", "food", "", "f", "", "addBlood", "blood", "addExhaustion", "exhaustion", "eat", "item", "Lnet/minecraft/item/Item;", "stack", "Lnet/minecraft/item/ItemStack;", "feed", "amount", "entity", "Lnet/minecraft/entity/LivingEntity;", "player", "Lnet/minecraft/util/ActionResult;", "fromTag", "tag", "Lnet/minecraft/nbt/CompoundTag;", "getBloodLevel", "getFoodLevel", "heal", "removeBlood", "setFoodLevel", "foodLevel", "sync", "toTag", "update", "Companion", "haema"})
public final class VampireBloodManager
extends class_1702 {
    private class_1657 owner;
    private double absoluteBloodLevel = 9.0;
    private long lastFed = -24000L;
    private static final UUID VAMPIRE_REACH_UUID;
    private static final UUID VAMPIRE_ATTACK_RANGE_UUID;
    private static final class_1322 VAMPIRE_REACH;
    private static final class_1322 VAMPIRE_ATTACK_RANGE;
    public static final Companion Companion;

    @Deprecated(message="use getBloodLevel()")
    public static /* synthetic */ void absoluteBloodLevel$annotations() {
    }

    public final double getAbsoluteBloodLevel() {
        return this.absoluteBloodLevel;
    }

    public final void setAbsoluteBloodLevel(double d) {
        this.absoluteBloodLevel = d;
    }

    public final long getLastFed() {
        return this.lastFed;
    }

    public final void setLastFed(long l) {
        this.lastFed = l;
    }

    public void method_7588(@Nullable class_1657 player) {
        block20: {
            class_1324 attackRangeAttr;
            class_1324 reachAttr;
            block21: {
                block18: {
                    block19: {
                        class_1657 class_16572 = player;
                        if (class_16572 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.owner = class_16572;
                        player.method_5803(this.getBloodLevel() >= (double)10 && player.method_5624() || this.getBloodLevel() >= (double)12);
                        if (this.getBloodLevel() <= (double)3) {
                            player.method_6092(new class_1293(VampiricWeaknessEffect.Companion.getInstance(), 5, 3 - MathKt.roundToInt((double)this.getBloodLevel())));
                        }
                        reachAttr = player.method_5996(ReachEntityAttributes.REACH);
                        attackRangeAttr = player.method_5996(ReachEntityAttributes.ATTACK_RANGE);
                        if (!(this.getBloodLevel() >= (double)6)) break block18;
                        class_1324 class_13242 = reachAttr;
                        if (class_13242 != null && !class_13242.method_6196(VAMPIRE_REACH)) break block19;
                        class_1324 class_13243 = attackRangeAttr;
                        if (class_13243 == null) break block18;
                        if (class_13243.method_6196(VAMPIRE_ATTACK_RANGE)) break block18;
                    }
                    class_1324 class_13244 = reachAttr;
                    if (class_13244 != null) {
                        class_13244.method_26835(VAMPIRE_REACH);
                    }
                    class_1324 class_13245 = attackRangeAttr;
                    if (class_13245 != null) {
                        class_13245.method_26835(VAMPIRE_ATTACK_RANGE);
                    }
                    break block20;
                }
                class_1324 class_13246 = reachAttr;
                if (class_13246 == null) break block21;
                if (class_13246.method_6196(VAMPIRE_REACH)) break block21;
                class_1324 class_13247 = attackRangeAttr;
                if (class_13247 != null && !class_13247.method_6196(VAMPIRE_ATTACK_RANGE)) break block20;
            }
            class_1324 class_13248 = reachAttr;
            if (class_13248 != null) {
                class_13248.method_6202(VAMPIRE_REACH);
            }
            class_1324 class_13249 = attackRangeAttr;
            if (class_13249 != null) {
                class_13249.method_6202(VAMPIRE_ATTACK_RANGE);
            }
        }
        if (this.getBloodLevel() >= (double)10) {
            player.method_6092(new class_1293(VampiricStrengthEffect.Companion.getInstance(), 10, 0));
        }
        if (this.getBloodLevel() >= (double)14) {
            player.method_6092(new class_1293(VampiricStrengthEffect.Companion.getInstance(), 10, 1));
        }
        if (this.getBloodLevel() >= (double)19) {
            player.method_6092(new class_1293(VampiricStrengthEffect.Companion.getInstance(), 10, 2));
        }
        if (this.getBloodLevel() >= (double)20) {
            player.method_6092(new class_1293(class_1294.field_5905, 10, 0));
        }
        if (this.getBloodLevel() >= (double)8 || this.getBloodLevel() > 0.0 && player.method_6032() <= 0.0f && player.method_5805()) {
            class_1937 class_19372 = player.field_6002;
            Intrinsics.checkExpressionValueIsNotNull((Object)class_19372, (String)"player.world");
            if (((class_1928.class_4310)class_19372.method_8450().method_20746(class_1928.field_19395)).method_20753() && player.method_7317()) {
                this.heal(player, 1.0f);
            } else if (player.method_6032() <= 0.0f) {
                player.method_6033(1.0f);
                this.removeBlood(1.0);
            }
        }
        this.sync(player);
    }

    @Deprecated(message="use blood")
    public void method_7585(int food, float f) {
    }

    @Deprecated(message="use blood")
    public void method_7583(float exhaustion) {
    }

    @Deprecated(message="use blood")
    public void method_7579(@Nullable class_1792 item, @Nullable class_1799 stack) {
    }

    @Deprecated(message="use blood")
    public void method_7580(int foodLevel) {
    }

    @Deprecated(message="use blood", replaceWith=@ReplaceWith(imports={"kotlin.math.roundToInt"}, expression="getBloodLevel().roundToInt()"))
    public int method_7586() {
        return MathKt.roundToInt((double)this.getBloodLevel());
    }

    public void method_7584(@Nullable class_2487 tag) {
        super.method_7584(tag);
        class_2487 class_24872 = tag;
        this.absoluteBloodLevel = class_24872 != null ? class_24872.method_10574("BloodLevel") : 0.0;
        class_2487 class_24873 = tag;
        this.lastFed = class_24873 != null ? class_24873.method_10537("LastFed") : -6000L;
    }

    public void method_7582(@Nullable class_2487 tag) {
        block1: {
            super.method_7582(tag);
            class_2487 class_24872 = tag;
            if (class_24872 != null) {
                class_24872.method_10549("BloodLevel", this.absoluteBloodLevel);
            }
            class_2487 class_24873 = tag;
            if (class_24873 == null) break block1;
            class_24873.method_10544("LastFed", this.lastFed);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final double getBloodLevel() {
        class_1657 class_16572 = this.owner;
        if (class_16572 != null) {
            if (class_16572.method_7337()) {
                return 19.0;
            }
        }
        double d = this.absoluteBloodLevel * Math.PI / 40.0;
        double d2 = 20.0;
        boolean bl = false;
        double d3 = Math.sin(d);
        double d4 = d2 * d3;
        return d4;
    }

    public final void removeBlood(double blood) {
        double d;
        double d2 = this.absoluteBloodLevel - blood;
        double d3 = 0.0;
        VampireBloodManager vampireBloodManager = this;
        boolean bl = false;
        vampireBloodManager.absoluteBloodLevel = d = Math.max(d2, d3);
    }

    public final void addBlood(double blood) {
        double d;
        double d2 = this.absoluteBloodLevel + blood;
        double d3 = 20.0;
        VampireBloodManager vampireBloodManager = this;
        boolean bl = false;
        vampireBloodManager.absoluteBloodLevel = d = Math.min(d2, d3);
    }

    @NotNull
    public final class_1269 feed(@NotNull class_1309 entity, @NotNull class_1657 player) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (this.getBloodLevel() > 8.5) {
            class_1937 class_19372 = player.field_6002;
            Intrinsics.checkExpressionValueIsNotNull((Object)class_19372, (String)"player.world");
            long l = class_19372.method_8510();
            class_1937 class_19373 = player.field_6002;
            Intrinsics.checkExpressionValueIsNotNull((Object)class_19373, (String)"player.world");
            if (this.lastFed >= l - (long)Companion.getFeedCooldown(class_19373)) {
                return entity.method_6113() ? class_1269.field_5814 : class_1269.field_5811;
            }
        }
        if (HaemaKt.getGoodBloodTag().method_15141((Object)entity.method_5864())) {
            this.feed(0.8, entity, player);
            return class_1269.field_5812;
        }
        if (HaemaKt.getMediumBloodTag().method_15141((Object)entity.method_5864())) {
            this.feed(0.4, entity, player);
            return class_1269.field_5812;
        }
        if (HaemaKt.getPoorBloodTag().method_15141((Object)entity.method_5864())) {
            this.feed(0.1, entity, player);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    /*
     * WARNING - void declaration
     */
    private final void feed(double amount, class_1309 entity, class_1657 player) {
        class_1702 class_17022 = player.method_7344();
        if (class_17022 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.williambl.haema.VampireBloodManager");
        }
        ((VampireBloodManager)class_17022).addBlood(amount);
        class_1937 class_19372 = player.field_6002;
        Intrinsics.checkExpressionValueIsNotNull((Object)class_19372, (String)"player.world");
        this.lastFed = class_19372.method_8510();
        entity.method_5643(BloodLossDamageSource.Companion.getInstance(), 1.0f);
        class_243 towards = player.method_19538().method_1020(entity.method_19538()).method_1029().method_1021(0.1);
        int n = 0;
        int n2 = 20;
        while (n <= n2) {
            void i;
            class_243 vel = towards.method_1021((double)i);
            player.field_6002.method_8406((class_2394)class_2390.field_11188, entity.method_23317() + player.method_6051().nextDouble() - 0.5, entity.method_23318() + player.method_6051().nextDouble(), entity.method_23321() + player.method_6051().nextDouble() - 0.5, vel.field_1352, vel.field_1351, vel.field_1350);
            ++i;
        }
        if (entity instanceof class_1646 && !((class_1646)entity).method_6113()) {
            ((class_1646)entity).method_21651().method_19072(player.method_5667(), class_4139.field_18424, 20);
            if (player.field_6002 instanceof class_3218) {
                VampireHunterSpawner vampireHunterSpawner = HaemaKt.getVampireHunterSpawner();
                class_1937 class_19373 = player.field_6002;
                if (class_19373 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.server.world.ServerWorld");
                }
                class_3218 class_32182 = (class_3218)class_19373;
                Random random = player.method_6051();
                Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"player.random");
                class_2338 class_23382 = player.method_24515();
                Intrinsics.checkExpressionValueIsNotNull((Object)class_23382, (String)"player.blockPos");
                vampireHunterSpawner.trySpawnNear(class_32182, random, class_23382);
            }
        }
    }

    private final void sync(class_1657 player) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeDouble(this.absoluteBloodLevel);
        buf.writeLong(this.lastFed);
        ServerSidePacketRegistry.INSTANCE.sendToPlayer(player, HaemaKt.getBloodLevelPackeId(), buf);
    }

    public final void heal(@NotNull class_1657 player, float amount) {
        double d;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        player.method_6025(amount);
        double d2 = player.method_6032();
        class_1324 class_13242 = player.method_5996(class_5134.field_23716);
        if (class_13242 != null) {
            UUID uUID = UUID.fromString("858a6a28-5092-49ea-a94e-eb74db018a92");
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(\"858a6a2\u2026-49ea-a94e-eb74db018a92\")");
            d = EntityAttributeInstanceExtensionsKt.computeValueWithout(class_13242, uUID);
        } else {
            d = 20.0;
        }
        if (d2 < d) {
            double d3 = this.getBloodLevel() / 20.0;
            int n = 2;
            double d4 = 1.1;
            VampireBloodManager vampireBloodManager = this;
            boolean bl = false;
            double d5 = Math.pow(d3, n);
            vampireBloodManager.removeBlood((d4 - d5) * (double)amount);
        }
    }

    static {
        Companion = new Companion(null);
        VAMPIRE_REACH_UUID = UUID.fromString("0eb4fc5f-71d5-4440-b517-bcc18e1df6f4");
        VAMPIRE_ATTACK_RANGE_UUID = UUID.fromString("3267a46b-2b48-429f-a3a8-439aa87a876d");
        VAMPIRE_REACH = new class_1322(VAMPIRE_REACH_UUID, "Vampire reach extension", 2.0, class_1322.class_1323.field_6328);
        VAMPIRE_ATTACK_RANGE = new class_1322(VAMPIRE_ATTACK_RANGE_UUID, "Vampire attack range extension", 2.0, class_1322.class_1323.field_6328);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/williambl/haema/VampireBloodManager$Companion;", "", "()V", "VAMPIRE_ATTACK_RANGE", "Lnet/minecraft/entity/attribute/EntityAttributeModifier;", "VAMPIRE_ATTACK_RANGE_UUID", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "VAMPIRE_REACH", "VAMPIRE_REACH_UUID", "getFeedCooldown", "", "world", "Lnet/minecraft/world/World;", "haema"})
    public static final class Companion {
        public final int getFeedCooldown(@NotNull class_1937 world) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            return ((class_1928.class_4312)world.method_8450().method_20746(HaemaGameRulesKt.getFeedCooldown())).method_20763();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

