/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.haema.mixin;

import com.williambl.haema.Vampirable;
import com.williambl.haema.VampireBloodManager;
import com.williambl.haema.damagesource.DamageSourceExtensionsKt;
import com.williambl.haema.effect.SunlightSicknessEffect;
import com.williambl.haema.util.HaemaGameRulesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements Vampirable {
    @Shadow
    protected class_1702 field_7493;
    @Shadow
    @Final
    public class_1656 field_7503;
    protected VampireBloodManager bloodManager = null;

    @Override
    public boolean isVampire() {
        return (Boolean)this.field_6011.method_12789(Vampirable.Companion.getIS_VAMPIRE());
    }

    @Override
    public void setVampire(boolean vampire) {
        this.field_6011.method_12778(Vampirable.Companion.getIS_VAMPIRE(), (Object)vampire);
        if (vampire) {
            this.checkBloodManager();
        } else {
            this.field_7493 = new class_1702();
            this.bloodManager = null;
        }
    }

    @Override
    public boolean isPermanentVampire() {
        return (Boolean)this.field_6011.method_12789(Vampirable.Companion.getIS_PERMANENT_VAMPIRE());
    }

    @Override
    public void setPermanentVampire(boolean isPermanentVampire) {
        this.field_6011.method_12778(Vampirable.Companion.getIS_PERMANENT_VAMPIRE(), (Object)isPermanentVampire);
    }

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    void initVampireTracker(CallbackInfo ci) {
        this.field_6011.method_12784(Vampirable.Companion.getIS_VAMPIRE(), (Object)false);
        this.field_6011.method_12784(Vampirable.Companion.getIS_KILLED(), (Object)false);
        this.field_6011.method_12784(Vampirable.Companion.getIS_PERMANENT_VAMPIRE(), (Object)false);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tick()V")})
    void vampireTick(CallbackInfo ci) {
        if (this.isVampire()) {
            this.checkBloodManager();
            if (((class_1928.class_4310)this.field_6002.method_8450().method_20746(HaemaGameRulesKt.getVampiresBurn())).method_20753() && this.isInDaylight() && !this.field_7503.field_7477) {
                this.method_6092(new class_1293(SunlightSicknessEffect.Companion.getInstance(), 5, 0));
            }
        }
    }

    @Redirect(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    boolean damage(class_1309 livingEntity, class_1282 source, float amount) {
        if (this.isVampire()) {
            boolean isDamageSourceEffective = DamageSourceExtensionsKt.isEffectiveAgainstVampires(source);
            if (isDamageSourceEffective) {
                amount = (float)((double)amount * 1.25);
            }
            float bloodAbsorptionAmount = 0.5f * amount;
            bloodAbsorptionAmount = this.bloodManager.getAbsoluteBloodLevel() > (double)bloodAbsorptionAmount ? bloodAbsorptionAmount : (float)this.bloodManager.getAbsoluteBloodLevel();
            double originalMax = this.method_26826(class_5134.field_23716);
            if ((double)(this.method_6032() - (amount - bloodAbsorptionAmount)) > originalMax) {
                this.bloodManager.removeBlood(Math.min((double)bloodAbsorptionAmount, (double)this.method_6032() - originalMax));
            }
            boolean result = super.method_5643(source, amount - bloodAbsorptionAmount);
            this.field_6011.method_12778(Vampirable.Companion.getIS_KILLED(), (Object)(this.method_6032() <= 0.0f && isDamageSourceEffective ? 1 : 0));
            return result;
        }
        return super.method_5643(source, amount);
    }

    @Inject(method={"readCustomDataFromTag"}, at={@At(value="TAIL")})
    void readVampireData(class_2487 tag, CallbackInfo ci) {
        this.setVampire(tag.method_10577("IsVampire"));
        if (this.isVampire()) {
            this.bloodManager.method_7584(tag);
        }
    }

    @Inject(method={"writeCustomDataToTag"}, at={@At(value="TAIL")})
    void writeVampireData(class_2487 tag, CallbackInfo ci) {
        tag.method_10556("IsVampire", this.isVampire());
    }

    public boolean method_29504() {
        if (this.isVampire() && this.bloodManager != null) {
            return super.method_29504() && this.bloodManager.getBloodLevel() <= 0.0 && (Boolean)this.field_6011.method_12789(Vampirable.Companion.getIS_KILLED()) != false;
        }
        return super.method_29504();
    }

    public boolean method_5805() {
        return this.isVampire() ? !this.method_29504() : super.method_5805();
    }

    @Unique
    protected boolean isInDaylight() {
        return !this.field_6002.field_9236 && this.field_6002.method_8530() && !this.field_6002.method_8419() && this.field_6002.method_8311(this.method_24515());
    }

    @Override
    public void checkBloodManager() {
        if (this.bloodManager == null) {
            this.field_7493 = new VampireBloodManager();
            this.bloodManager = (VampireBloodManager)this.field_7493;
        }
    }
}

