/*
 * Decompiled with CFR 0.152.
 */
package com.fireboss.heartlevels;

import com.fireboss.heartlevels.Config;
import com.fireboss.heartlevels.commands.HeartLevelCommands;
import com.fireboss.heartlevels.enchantments.ArmorHealthEnchantment;
import com.fireboss.heartlevels.gui.HeartLevelsGui;
import com.fireboss.heartlevels.gui.HeartLevelsGuiHandler;
import com.fireboss.heartlevels.handlers.FMLEventHandler;
import com.fireboss.heartlevels.handlers.ForgeEventHandler;
import com.fireboss.heartlevels.handlers.PlayerHandler;
import com.fireboss.heartlevels.init.InitChestLoot;
import com.fireboss.heartlevels.init.InitItems;
import com.fireboss.heartlevels.proxy.ICommonProxy;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="heartlevels", name="Heart Levels", version="1.0.4", acceptedMinecraftVersions="[1.8.9]")
public class HeartLevels {
    public static final Logger logger = LogManager.getLogger((String)"heartlevels");
    @Mod.Instance(value="heartlevels")
    public static HeartLevels instance;
    @SidedProxy(clientSide="com.fireboss.heartlevels.proxy.ClientProxy", serverSide="com.fireboss.heartlevels.proxy.ServerProxy")
    public static ICommonProxy proxy;
    public static int[] LevelRampInt;
    public static Enchantment armorEnchantment;
    public static AttributeModifier healthMod;
    private static Object playerTracker;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.config = new Configuration(event.getSuggestedConfigurationFile());
        Config.config.load();
        Config.SetupConfig();
        InitItems.Create();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FMLEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)instance);
        if (Config.heartItems.getBoolean()) {
            InitChestLoot.AddChestLoot();
        }
        if (!Config.rpgMode.getBoolean()) {
            LevelRampInt = new int[1];
            HeartLevels.LevelRampInt[0] = -1;
        } else {
            LevelRampInt = Config.levelRamp.getIntList();
        }
        if (Config.enchantsEnabled.getBoolean()) {
            armorEnchantment = new ArmorHealthEnchantment(Config.armorEnchantID.getInt(), 4);
        }
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new HeartLevelsGuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        playerTracker = new PlayerHandler();
        MinecraftForge.EVENT_BUS.register(playerTracker);
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new HeartLevelCommands());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (HeartLevelsGui.keyBinding.func_151468_f()) {
            FMLClientHandler.instance().getClient().field_71439_g.openGui((Object)instance, HeartLevelsGui.id, (World)FMLClientHandler.instance().getClient().field_71441_e, 0, 0, 0);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("heartlevels")) {
            Config.SetupConfig();
        }
    }
}

