/*
 * Decompiled with CFR 0.152.
 */
package com.fireboss.heartlevels.gui;

import com.fireboss.heartlevels.Config;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class HeartLevelsHUD
extends Gui {
    private Minecraft mc;
    protected final Random rand = new Random();

    public HeartLevelsHUD(Minecraft mc) {
        this.mc = Minecraft.func_71410_x();
    }

    private void bind(ResourceLocation res) {
        this.mc.func_110434_K().func_110577_a(res);
    }

    @SubscribeEvent
    public void modifyAirHUD(RenderGameOverlayEvent.Pre event) {
        if (event == null || event.type == null) {
            return;
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.AIR) && Config.customGui.getBoolean() && !Config.minimalGui.getBoolean()) {
            event.setCanceled(true);
            this.mc.field_71424_I.func_76320_a("air");
            ScaledResolution res = new ScaledResolution(this.mc);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            int left = width / 2 + 91;
            int top = height - 49;
            if (this.mc.field_71439_g.func_70055_a(Material.field_151586_h)) {
                int level = ForgeHooks.getTotalArmorValue((EntityPlayer)this.mc.field_71439_g);
                if (level > 0) {
                    top -= 9;
                }
                int air = this.mc.field_71439_g.func_70086_ai();
                int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
                int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
                for (int i = 0; i < full + partial; ++i) {
                    this.func_73729_b(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
                }
            }
            this.mc.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public void modifyArmorHUD(RenderGameOverlayEvent.Pre event) {
        if (event == null || event.type == null) {
            return;
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.ARMOR)) {
            if (Config.minimalGui.getBoolean()) {
                GuiIngameForge.left_height += 10;
            }
            if (Config.customGui.getBoolean() && !Config.minimalGui.getBoolean()) {
                event.setCanceled(true);
                this.mc.field_71424_I.func_76320_a("armor");
                ScaledResolution res = new ScaledResolution(this.mc);
                int width = res.func_78326_a();
                int height = res.func_78328_b();
                int left = width / 2 - 91 + 100;
                int top = height - 49;
                int level = ForgeHooks.getTotalArmorValue((EntityPlayer)this.mc.field_71439_g);
                for (int i = 1; level > 0 && i < 20; i += 2) {
                    if (i < level) {
                        this.func_73729_b(left, top, 34, 9, 9, 9);
                    } else if (i == level) {
                        this.func_73729_b(left, top, 25, 9, 9, 9);
                    } else if (i > level) {
                        this.func_73729_b(left, top, 16, 9, 9, 9);
                    }
                    left += 8;
                }
                this.mc.field_71424_I.func_76319_b();
            }
        }
    }

    @SubscribeEvent
    public void modifyHealthHUD(RenderGameOverlayEvent.Pre event) {
        if (event == null || event.type == null) {
            return;
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.HEALTH) && Config.minimalGui.getBoolean()) {
            boolean highlight;
            event.setCanceled(true);
            this.mc.field_71424_I.func_76320_a("health");
            boolean bl = highlight = this.mc.field_71439_g.field_70172_ad / 3 % 2 == 1;
            if (this.mc.field_71439_g.field_70172_ad < 10) {
                highlight = false;
            }
            ScaledResolution res = new ScaledResolution(this.mc);
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            int health = MathHelper.func_76123_f((float)this.mc.field_71439_g.func_110143_aJ());
            int left = width / 2 - 91;
            int top = height - 39;
            int colorX = left - 7;
            int colorY = top + 1;
            int regen = -1;
            if (this.mc.field_71439_g.func_70644_a(Potion.field_76428_l)) {
                regen = this.mc.field_71456_v.func_73834_c() % 25;
            }
            int row = (health - 1) / 20;
            boolean isMinimalGui = Config.minimalGui.getBoolean();
            for (int i = row * 10; i < row * 10 + 10; ++i) {
                if ((float)((i + 1) * 2) > this.mc.field_71439_g.func_110138_aP()) continue;
                int idx = i * 2 + 1;
                int iconX = 16;
                if (this.mc.field_71439_g.func_70644_a(Potion.field_76436_u)) {
                    iconX += 36;
                } else if (this.mc.field_71439_g.func_70644_a(Potion.field_82731_v)) {
                    iconX += 72;
                }
                int x = left + i * 8 - 80 * row;
                int y = top;
                if (health <= 4) {
                    y = top + this.rand.nextInt(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                int iconY = 0;
                if (this.mc.field_71441_e.func_72912_H().func_76093_s()) {
                    iconY = 5;
                }
                this.func_73729_b(x, y, 16 + (highlight ? 9 : 0), 9 * iconY, 9, 9);
                if (highlight) {
                    // empty if block
                }
                if (idx < health) {
                    this.func_73729_b(x, y, iconX + 36, 9 * iconY, 9, 9);
                } else if (idx == health) {
                    this.func_73729_b(x, y, iconX + 45, 9 * iconY, 9, 9);
                }
                if (!isMinimalGui) continue;
                int displayedRow = row + 1;
                String text = "" + displayedRow;
                int adjustedColorX = colorX;
                if (displayedRow >= 10) {
                    adjustedColorX -= 6;
                }
                if (displayedRow >= 100) {
                    adjustedColorX -= 6;
                }
                if (displayedRow >= 1000) {
                    adjustedColorX -= 6;
                }
                if (displayedRow >= 10000) {
                    text = "9999+";
                    adjustedColorX -= 6;
                }
                this.mc.field_71466_p.func_78276_b(text, adjustedColorX, colorY, 0);
                this.mc.field_71466_p.func_78276_b(text, adjustedColorX, 0xF00000, 0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.bind(Gui.field_110324_m);
            }
            this.mc.field_71424_I.func_76319_b();
        }
    }
}

