/*
 * Decompiled with CFR 0.152.
 */
package com.fireboss.heartlevels.handlers;

import com.fireboss.heartlevels.Config;
import com.fireboss.heartlevels.HeartLevels;
import com.fireboss.heartlevels.PlayerStats;
import com.fireboss.heartlevels.handlers.PlayerHandler;
import com.fireboss.heartlevels.handlers.PlayerHandlerHelper;
import com.mojang.authlib.GameProfile;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class FMLEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLivingUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer cfr_ignored_0 = event.player;
        PlayerStats stats = PlayerStats.getPlayerStats(EntityPlayer.func_146094_a((GameProfile)event.player.func_146103_bH()).toString());
        Side side = event.side;
        if (side == Side.CLIENT && stats.needClientSideHealthUpdate) {
            PlayerHandlerHelper.savePlayerData(event.player, false);
            PlayerHandlerHelper.updatePlayerData(event.player);
            event.player.func_70606_j(event.player.func_110143_aJ());
            stats.needClientSideHealthUpdate = false;
            if (stats.justLoggedIn && stats.loggedOutHealth != 0.0f) {
                event.player.func_70606_j(stats.loggedOutHealth);
                stats.justLoggedIn = false;
            }
        }
        if (Config.rpgMode.getBoolean()) {
            this.calculateHeartChange(event.player, stats);
        }
        if (side == Side.SERVER && Config.enchantsEnabled.getBoolean()) {
            this.calculateEnchantmentChanges(event.player, stats);
        }
        this.saveHeartChange(event.player, stats);
    }

    private void calculateEnchantmentChanges(EntityPlayer player, PlayerStats stats) {
        if (stats.loggedOutHealth == 0.0f) {
            return;
        }
        int armourHealth = 0;
        for (int i = 1; i <= 4; ++i) {
            int extraHealth;
            int extraHearts;
            ItemStack currentArmour = player.func_71124_b(i);
            ItemStack oldArmour = stats.oldArmourSet[i - 1];
            double currentMaxHealthMod = 0.0;
            try {
                currentMaxHealthMod = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(PlayerHandler.HeartLevelsID).func_111164_d();
            }
            catch (Exception e) {
                return;
            }
            if (currentArmour == null && oldArmour != null) {
                extraHearts = EnchantmentHelper.func_77506_a((int)Config.armorEnchantID.getInt(), (ItemStack)oldArmour);
                if (extraHearts > 0) {
                    extraHealth = extraHearts;
                    PlayerHandler.addHealthModifier(player, currentMaxHealthMod - (double)extraHealth);
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.removearmour", new Object[]{extraHearts}));
                    stats.needClientSideHealthUpdate = true;
                }
            } else if (currentArmour != null && oldArmour == null) {
                extraHearts = EnchantmentHelper.func_77506_a((int)Config.armorEnchantID.getInt(), (ItemStack)currentArmour);
                if (extraHearts > 0) {
                    extraHealth = extraHearts;
                    PlayerHandler.addHealthModifier(player, currentMaxHealthMod + (double)extraHealth);
                    if (!stats.justLoggedIn) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.equipnew", new Object[]{extraHearts}));
                    }
                    stats.needClientSideHealthUpdate = true;
                    armourHealth += extraHealth;
                }
            } else if (oldArmour != currentArmour) {
                int oldHealth = EnchantmentHelper.func_77506_a((int)Config.armorEnchantID.getInt(), (ItemStack)oldArmour);
                int newHealth = EnchantmentHelper.func_77506_a((int)Config.armorEnchantID.getInt(), (ItemStack)currentArmour);
                int healthChange = newHealth - oldHealth;
                PlayerHandler.addHealthModifier(player, currentMaxHealthMod + (double)healthChange);
                if (healthChange > 0) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.equipstrong", new Object[]{healthChange}));
                    stats.needClientSideHealthUpdate = true;
                }
                if (healthChange < 0) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.equipweak", new Object[]{healthChange}));
                    stats.needClientSideHealthUpdate = true;
                }
            }
            stats.oldArmourSet[i - 1] = currentArmour;
        }
        if (player.func_110143_aJ() > player.func_110138_aP()) {
            player.func_70606_j(player.func_110138_aP());
        }
        if (stats.justLoggedIn) {
            player.func_70606_j(stats.loggedOutHealth);
            stats.needClientSideHealthUpdate = true;
        }
    }

    private void calculateHeartChange(EntityPlayer player, PlayerStats stats) {
        int maxHearts = Config.maxHearts.getInt();
        if (maxHearts != -1 && maxHearts != 0 && player.func_110138_aP() + 2.0f > (float)maxHearts) {
            return;
        }
        if (this.levelIncreased(player, stats)) {
            if (Config.debug.getBoolean()) {
                HeartLevels.logger.info("The user's level has increased!");
            }
            while (stats.count < HeartLevels.LevelRampInt.length && player.field_71068_ca >= HeartLevels.LevelRampInt[stats.count]) {
                double updatedModifier;
                block8: {
                    if (Config.debug.getBoolean()) {
                        HeartLevels.logger.info("EXP matches next level ramp! Upping player level...");
                    }
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.heartadded", new Object[0]));
                    updatedModifier = 2.0;
                    try {
                        updatedModifier = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(PlayerHandler.HeartLevelsID).func_111164_d() + (double)Config.heartGain.getInt();
                    }
                    catch (Exception e) {
                        if (!Config.debug.getBoolean()) break block8;
                        HeartLevels.logger.catching((Throwable)e);
                    }
                }
                if (!player.field_70170_p.field_72995_K) {
                    PlayerHandler.addHealthModifier(player, updatedModifier);
                }
                stats.healthmod = updatedModifier;
                ++stats.count;
                player.func_70606_j(player.func_110138_aP());
                if (!Config.debug.getBoolean()) continue;
                HeartLevels.logger.info("Player's hearts have been updated!");
            }
        }
    }

    private void saveHeartChange(EntityPlayer player, PlayerStats stats) {
        NBTTagCompound tags = player.getEntityData();
        tags.func_74775_l("HeartLevels 1").func_74768_a("count", stats.count);
        try {
            stats.healthmod = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(PlayerHandler.HeartLevelsID).func_111164_d();
        }
        catch (Exception exception) {
            // empty catch block
        }
        tags.func_74775_l("HeartLevels 1").func_74780_a("healthModifier", stats.healthmod);
        tags.func_74775_l("HeartLevels 1").func_74768_a("previousLevel", stats.previousLevel);
        PlayerHandler.playerStats.put(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString(), stats);
    }

    private boolean levelIncreased(EntityPlayer player, PlayerStats stats) {
        boolean levelIncreased = false;
        if (stats.previousLevel != player.field_71068_ca) {
            stats.previousLevel = player.field_71068_ca;
            levelIncreased = true;
        }
        return levelIncreased;
    }
}

