/*
 * Decompiled with CFR 0.152.
 */
package com.fireboss.heartlevels.handlers;

import com.fireboss.heartlevels.Config;
import com.fireboss.heartlevels.HeartLevels;
import com.fireboss.heartlevels.PlayerStats;
import com.fireboss.heartlevels.handlers.PlayerHandlerHelper;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerHandler {
    public static final UUID HeartLevelsID = UUID.fromString("e3723b50-7cc6-11e3-baa7-0800200c9a66");
    public static ConcurrentHashMap<String, PlayerStats> playerStats = new ConcurrentHashMap();

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound tags = event.player.getEntityData();
        PlayerStats stats = new PlayerStats();
        PlayerHandlerHelper.loadPlayerData(event.player, tags, stats);
        if (stats.start != Config.startHearts.getInt() || !Arrays.equals(stats.LevelArray, HeartLevels.LevelRampInt)) {
            PlayerHandlerHelper.updateHealth(event.player, stats, tags);
        }
        double healthModifier = stats.healthmod;
        PlayerHandler.addHealthModifier(event.player, healthModifier);
        stats.player = event.player;
        stats.justLoggedIn = true;
        EntityPlayer cfr_ignored_0 = event.player;
        playerStats.put(EntityPlayer.func_146094_a((GameProfile)event.player.func_146103_bH()).toString(), stats);
    }

    public static void addHealthModifier(EntityPlayer player, double healthModifier) {
        HeartLevels.healthMod = new AttributeModifier(HeartLevelsID, "Heart Levels Health Modifier", healthModifier, 0);
        IAttributeInstance attinstance = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        attinstance.func_111124_b(HeartLevels.healthMod);
        attinstance.func_111121_a(HeartLevels.healthMod);
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerHandlerHelper.savePlayerData(event.player, true);
    }

    @SubscribeEvent
    public void onPlayerChangedDimention(PlayerEvent.PlayerChangedDimensionEvent event) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        PlayerHandlerHelper.savePlayerData(event.player, false);
        PlayerHandlerHelper.updatePlayerData(event.player);
        EntityPlayer cfr_ignored_0 = event.player;
        PlayerStats stats = PlayerStats.getPlayerStats(EntityPlayer.func_146094_a((GameProfile)event.player.func_146103_bH()).toString());
        stats.needClientSideHealthUpdate = true;
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer cfr_ignored_0 = event.player;
        PlayerStats stats = PlayerStats.getPlayerStats(EntityPlayer.func_146094_a((GameProfile)event.player.func_146103_bH()).toString());
        double healthModifier = stats.healthmod;
        PlayerHandler.addHealthModifier(event.player, healthModifier);
        if (Config.hardcoreMode.getBoolean()) {
            stats.count = 0;
            double baseHearts = event.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
            healthModifier = (double)stats.start - baseHearts;
            PlayerHandler.addHealthModifier(event.player, healthModifier);
        }
        event.player.func_70606_j(event.player.func_110138_aP());
        NBTTagCompound tags = event.player.getEntityData();
        NBTTagCompound tagTemp = new NBTTagCompound();
        tagTemp.func_74768_a("count", stats.count);
        tagTemp.func_74768_a("start", stats.start);
        tagTemp.func_74768_a("previousLevel", stats.previousLevel);
        if (Config.rpgMode.getBoolean()) {
            tagTemp.func_74783_a("LevelArray", stats.LevelArray);
        } else {
            tagTemp.func_74783_a("LevelArray", new int[]{-1});
        }
        tags.func_74782_a("HeartLevels 1", (NBTBase)tagTemp);
        try {
            stats.healthmod = event.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(HeartLevelsID).func_111164_d();
        }
        catch (Exception exception) {
            // empty catch block
        }
        tags.func_74775_l("HeartLevels 1").func_74780_a("healthModifier", stats.healthmod);
        EntityPlayer cfr_ignored_1 = event.player;
        playerStats.put(EntityPlayer.func_146094_a((GameProfile)event.player.func_146103_bH()).toString(), stats);
    }
}

