/*
 * Decompiled with CFR 0.152.
 */
package com.fireboss.heartlevels.handlers;

import com.fireboss.heartlevels.Config;
import com.fireboss.heartlevels.HeartLevels;
import com.fireboss.heartlevels.PlayerStats;
import com.fireboss.heartlevels.handlers.PlayerHandler;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class PlayerHandlerHelper {
    public static void updateHealth(EntityPlayer player, PlayerStats stats, NBTTagCompound tags) {
        NBTTagCompound hlt = (NBTTagCompound)tags.func_74781_a("HeartLevels 1");
        if (stats.start != Config.startHearts.getInt()) {
            stats.start = Config.startHearts.getInt();
        }
        if (!Arrays.equals(stats.LevelArray, HeartLevels.LevelRampInt)) {
            stats.LevelArray = HeartLevels.LevelRampInt;
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.lvlrmpchanged", new Object[0]));
            hlt.func_74783_a("LevelArray", stats.LevelArray);
        }
        player.func_70606_j(player.func_110138_aP());
        if (!Config.rpgMode.getBoolean()) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.heartcontainermode", new Object[0]));
            return;
        }
        double newMax = PlayerHandlerHelper.calcDefaultHearts(player, stats);
        double healthModifier = newMax - 20.0;
        PlayerHandler.addHealthModifier(player, healthModifier);
        player.func_70606_j(player.func_110138_aP());
        if (stats.count > 0) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.heartadded", new Object[0]));
        }
        boolean rpgMode = Config.rpgMode.getBoolean();
        boolean heartItems = Config.heartItems.getBoolean();
        if (rpgMode && heartItems) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.enhancedmode", new Object[0]));
        } else if (rpgMode) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.rpgmode", new Object[0]));
        }
        hlt.func_74768_a("count", stats.count);
        hlt.func_74780_a("healthModifier", stats.healthmod);
    }

    public static double calcDefaultHearts(EntityPlayer player, PlayerStats stats) {
        int rpgHealth = 0;
        int maxHearts = Config.maxHearts.getInt();
        int[] levelRamp = HeartLevels.LevelRampInt;
        for (int i = 0; i < levelRamp.length && player.field_71068_ca >= levelRamp[i]; ++i) {
            rpgHealth += 2;
        }
        if (maxHearts != -1 && maxHearts != 0 && rpgHealth > maxHearts) {
            rpgHealth = maxHearts;
        }
        int extraHearts = 0;
        for (int i = 0; i < stats.oldArmourSet.length; ++i) {
            extraHearts += EnchantmentHelper.func_77506_a((int)Config.armorEnchantID.getInt(), (ItemStack)stats.oldArmourSet[i]);
        }
        double armorHealth = extraHearts;
        double heartContainerHealth = stats.heartContainers;
        return (double)(stats.start + rpgHealth) + armorHealth + heartContainerHealth;
    }

    public static double calcDefaultHeartsNoHC(EntityPlayer player, PlayerStats stats) {
        double health = PlayerHandlerHelper.calcDefaultHearts(player, stats);
        return health -= (double)stats.heartContainers;
    }

    static void setupFirstTime(EntityPlayer player, NBTTagCompound tags, PlayerStats stats) {
        if (Config.debug.getBoolean()) {
            HeartLevels.logger.info("Player not found!");
            HeartLevels.logger.info("Initiating a new player...");
        }
        stats.start = Config.startHearts.getInt();
        stats.LevelArray = HeartLevels.LevelRampInt;
        double healthModifier = stats.start - 20;
        PlayerHandler.addHealthModifier(player, healthModifier);
        stats.count = 0;
        stats.previousLevel = player.field_71068_ca;
        try {
            stats.healthmod = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(PlayerHandler.HeartLevelsID).func_111164_d();
        }
        catch (Exception exception) {
            // empty catch block
        }
        NBTTagCompound hlt = (NBTTagCompound)tags.func_74781_a("HeartLevels 1");
        hlt.func_74768_a("start", stats.start);
        if (Config.rpgMode.getBoolean()) {
            hlt.func_74783_a("LevelArray", stats.LevelArray);
        } else {
            hlt.func_74783_a("LevelArray", new int[]{-1});
        }
        hlt.func_74768_a("count", stats.count);
        hlt.func_74768_a("previousLevel", stats.previousLevel);
        hlt.func_74780_a("healthModifier", stats.healthmod);
        hlt.func_74768_a("heartContainers", stats.heartContainers);
        PlayerHandlerHelper.updateHealth(player, stats, tags);
        if (Config.debug.getBoolean()) {
            HeartLevels.logger.info("New player initated successfully!");
        }
    }

    static void updatePlayerData(EntityPlayer player) {
        PlayerStats stats = PlayerStats.getPlayerStats(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString());
        double healthModifier = stats.healthmod;
        PlayerHandler.addHealthModifier(player, healthModifier);
    }

    public static void savePlayerData(EntityPlayer player, boolean loggedOut) {
        PlayerStats stats;
        if (Config.debug.getBoolean()) {
            HeartLevels.logger.info("Saving player data...");
        }
        if ((stats = PlayerStats.getPlayerStats(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString())) == null) {
            return;
        }
        EntityPlayer realPlayer = stats.player;
        NBTTagCompound entityPlayerTag = realPlayer != null ? realPlayer.getEntityData() : player.getEntityData();
        NBTTagCompound hlt = (NBTTagCompound)entityPlayerTag.func_74781_a("HeartLevels 1");
        hlt.func_74768_a("start", stats.start);
        if (Config.rpgMode.getBoolean()) {
            hlt.func_74783_a("LevelArray", stats.LevelArray);
        } else {
            hlt.func_74783_a("LevelArray", new int[]{-1});
        }
        hlt.func_74768_a("count", stats.count);
        hlt.func_74768_a("previousLevel", stats.previousLevel);
        hlt.func_74780_a("healthModifier", stats.healthmod);
        if (!loggedOut) {
            return;
        }
        double currentMaxHealthMod = 0.0;
        try {
            currentMaxHealthMod = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111127_a(PlayerHandler.HeartLevelsID).func_111164_d();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack currArmor = stats.oldArmourSet[i];
            int extraHearts = EnchantmentHelper.func_77506_a((int)Config.armorEnchantID.getInt(), (ItemStack)currArmor);
            if (extraHearts <= 0) continue;
            int extraHealth = extraHearts;
            currentMaxHealthMod -= (double)extraHealth;
        }
        hlt.func_74780_a("healthModifier", currentMaxHealthMod);
        hlt.func_74776_a("loggedOutHealth", player.func_110143_aJ());
        hlt.func_74768_a("heartContainers", stats.heartContainers);
        PlayerHandler.playerStats.remove(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString());
        if (Config.debug.getBoolean()) {
            HeartLevels.logger.info("Player data saved successfully!");
        }
    }

    public static void loadPlayerData(EntityPlayer player, NBTTagCompound tags, PlayerStats stats) {
        if (Config.debug.getBoolean()) {
            HeartLevels.logger.info("Loading player data...");
        }
        if (!tags.func_74764_b("HeartLevels 1")) {
            tags.func_74782_a("HeartLevels 1", (NBTBase)new NBTTagCompound());
            NBTTagCompound temp = (NBTTagCompound)tags.func_74781_a("MoreHealth 1");
            PlayerHandlerHelper.setupFirstTime(player, tags, stats);
        }
        NBTTagCompound hlt = (NBTTagCompound)tags.func_74781_a("HeartLevels 1");
        stats.start = hlt.func_74762_e("start");
        stats.LevelArray = hlt.func_74759_k("LevelArray");
        stats.count = hlt.func_74762_e("count");
        stats.previousLevel = hlt.func_74762_e("previousLevel");
        stats.healthmod = hlt.func_74769_h("healthModifier");
        stats.loggedOutHealth = hlt.func_74760_g("loggedOutHealth");
        stats.heartContainers = hlt.func_74762_e("heartContainers");
        if (Config.debug.getBoolean()) {
            HeartLevels.logger.info("Player data loaded successfully!");
        }
    }
}

