/*
 * Decompiled with CFR 0.152.
 */
package com.github.hotm.gen;

import com.github.hotm.HotMBlocks;
import com.github.hotm.HotMConfig;
import com.github.hotm.HotMConstants;
import com.github.hotm.HotMLog;
import com.github.hotm.gen.HotMBiomes;
import com.github.hotm.gen.HotMDimensions;
import com.github.hotm.gen.NectereChunkGenerator;
import com.github.hotm.gen.biome.NectereBiome;
import com.github.hotm.gen.feature.HotMStructureFeatures;
import com.github.hotm.gen.feature.NecterePortalGen;
import com.github.hotm.gen.feature.NecterePortalStructureFeature;
import com.github.hotm.mixin.StructureFeatureAccessor;
import com.github.hotm.mixinapi.DimensionAdditions;
import com.github.hotm.mixinapi.MutableMinecraftServer;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.dimension.v1.EntityPlacer;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2700;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_4545;
import net.minecraft.class_4547;
import net.minecraft.class_4766;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5314;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$J(\u0010%\u001a\u00020\u001e2\b\u0010&\u001a\u0004\u0018\u00010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020$0)2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0002J\u001e\u00100\u001a\u00020$2\u0006\u0010\"\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020$0)H\u0002J\u0006\u00103\u001a\u000204J \u00105\u001a\u0004\u0018\u00010$2\u0006\u0010\"\u001a\u0002062\f\u00102\u001a\b\u0012\u0004\u0012\u00020$0)H\u0002J\u0018\u00107\u001a\u00020$2\u0006\u0010\"\u001a\u0002062\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u00108\u001a\u0004\u0018\u00010$2\u0006\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020$J$\u0010;\u001a\b\u0012\u0004\u0012\u00020$0<2\u0006\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020$2\u0006\u00109\u001a\u00020'J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020$0<2\u0006\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020$J\u0018\u0010@\u001a\u0004\u0018\u00010'2\u0006\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020$J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020'H\u0002J\u000e\u0010E\u001a\u00020'2\u0006\u0010F\u001a\u00020GJD\u0010H\u001a\b\u0012\u0004\u0012\u00020$0<2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010>\u001a\u00020J2\u0018\u0010K\u001a\u0014\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020M0L2\u0006\u00109\u001a\u00020'JH\u0010N\u001a\b\u0012\u0004\u0012\u00020$0<2\u0006\u0010>\u001a\u00020J2\u0018\u0010K\u001a\u0014\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020M0L2\u0006\u00109\u001a\u00020'2\u0006\u0010O\u001a\u00020\u00162\u0006\u0010:\u001a\u00020JH\u0002J\u0018\u0010P\u001a\u00020B2\u0006\u0010C\u001a\u00020!2\u0006\u0010Q\u001a\u00020$H\u0002J(\u0010R\u001a\u0004\u0018\u00010$2\u0006\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020$2\u0006\u0010S\u001a\u00020M2\u0006\u0010T\u001a\u00020\u001eJ\u0006\u0010U\u001a\u000204J\b\u0010V\u001a\u000204H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR5\u0010\u0010\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fRf\u0010\u0014\u001aZ\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\r \u0012*\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\f\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00160\u0016 \u0012*,\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\r \u0012*\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\f\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00160\u0016\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\n \u0012*\u0004\u0018\u00010\u00180\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR5\u0010\u001b\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00180\u0018 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/github/hotm/gen/HotMDimensions;", "", "()V", "NECTERE_BIOME_SOURCE_PRESET", "Lnet/minecraft/world/biome/source/MultiNoiseBiomeSource$Preset;", "getNECTERE_BIOME_SOURCE_PRESET", "()Lnet/minecraft/world/biome/source/MultiNoiseBiomeSource$Preset;", "NECTERE_CHUNK_GENERATOR_TYPE_PRESET", "Lnet/minecraft/world/gen/chunk/ChunkGeneratorType$Preset;", "getNECTERE_CHUNK_GENERATOR_TYPE_PRESET", "()Lnet/minecraft/world/gen/chunk/ChunkGeneratorType$Preset;", "NECTERE_KEY", "Lnet/minecraft/util/registry/RegistryKey;", "Lnet/minecraft/world/World;", "getNECTERE_KEY", "()Lnet/minecraft/util/registry/RegistryKey;", "NECTERE_OPTIONS_KEY", "Lnet/minecraft/world/dimension/DimensionOptions;", "kotlin.jvm.PlatformType", "getNECTERE_OPTIONS_KEY", "NECTERE_PORTAL_BIOMES", "Lcom/google/common/collect/HashMultimap;", "Lcom/github/hotm/gen/biome/NectereBiome;", "NECTERE_TYPE", "Lnet/minecraft/world/dimension/DimensionType;", "getNECTERE_TYPE", "()Lnet/minecraft/world/dimension/DimensionType;", "NECTERE_TYPE_KEY", "getNECTERE_TYPE_KEY", "registered", "", "attemptNectereTeleportation", "entity", "Lnet/minecraft/entity/Entity;", "world", "portalPos", "Lnet/minecraft/util/math/BlockPos;", "attemptTeleport", "destWorld", "Lnet/minecraft/server/world/ServerWorld;", "destPoses", "", "createNectereBiomeSource", "Lnet/minecraft/world/biome/source/MultiNoiseBiomeSource;", "seed", "", "createNectereGenerator", "Lcom/github/hotm/gen/NectereChunkGenerator;", "createNecterePortal", "Lnet/minecraft/world/WorldAccess;", "newPoses", "findBiomes", "", "findNecterePortal", "Lnet/minecraft/world/WorldView;", "findPortalBase", "getBaseCorrespondingNonNectereCoords", "nectereWorld", "necterePos", "getCorrespondingNectereCoords", "Ljava/util/stream/Stream;", "currentWorld", "currentPos", "getCorrespondingNonNectereCoords", "getCorrespondingNonNectereWorld", "getGenericTeleportTarget", "Lnet/minecraft/block/pattern/BlockPattern$TeleportTarget;", "oldEntity", "destination", "getNectereWorld", "server", "Lnet/minecraft/server/MinecraftServer;", "getNonNecterePortalCoords", "currentWorldKey", "Lnet/minecraft/util/math/ChunkPos;", "heightFn", "Lkotlin/Function2;", "", "getNonNecterePortalCoordsForBiome", "nectereBiome", "getTeleportTarget", "destinationPos", "locateNonNectereSidePortal", "radius", "skipExistingChunks", "register", "registerImpl", "heart-of-the-machine"})
public final class HotMDimensions {
    private static boolean registered;
    private static final HashMultimap<class_5321<class_1937>, NectereBiome> NECTERE_PORTAL_BIOMES;
    @NotNull
    private static final class_5321<class_1937> NECTERE_KEY;
    private static final class_5321<class_5363> NECTERE_OPTIONS_KEY;
    private static final class_2874 NECTERE_TYPE;
    private static final class_5321<class_2874> NECTERE_TYPE_KEY;
    @NotNull
    private static final class_5284.class_5307 NECTERE_CHUNK_GENERATOR_TYPE_PRESET;
    @NotNull
    private static final class_4766.class_5305 NECTERE_BIOME_SOURCE_PRESET;
    public static final HotMDimensions INSTANCE;

    @NotNull
    public final class_5321<class_1937> getNECTERE_KEY() {
        return NECTERE_KEY;
    }

    public final class_5321<class_5363> getNECTERE_OPTIONS_KEY() {
        return NECTERE_OPTIONS_KEY;
    }

    public final class_2874 getNECTERE_TYPE() {
        return NECTERE_TYPE;
    }

    public final class_5321<class_2874> getNECTERE_TYPE_KEY() {
        return NECTERE_TYPE_KEY;
    }

    @NotNull
    public final class_5284.class_5307 getNECTERE_CHUNK_GENERATOR_TYPE_PRESET() {
        return NECTERE_CHUNK_GENERATOR_TYPE_PRESET;
    }

    @NotNull
    public final class_4766.class_5305 getNECTERE_BIOME_SOURCE_PRESET() {
        return NECTERE_BIOME_SOURCE_PRESET;
    }

    public final void register() {
        if (!registered) {
            registered = true;
            this.registerImpl();
        }
    }

    private final void registerImpl() {
        class_2378.method_10230((class_2378)class_2378.field_25097, (class_2960)HotMConstants.INSTANCE.identifier("nectere"), NectereChunkGenerator.Companion.getCODEC());
        DimensionAdditions.addDimension(NECTERE_OPTIONS_KEY, NECTERE_TYPE_KEY, NECTERE_TYPE, registerImpl.1.INSTANCE);
        DimensionAdditions.setSaveDir(NECTERE_KEY, "DIM-nectere");
        FabricDimensions.registerDefaultPlacer(NECTERE_KEY, (EntityPlacer)registerImpl.2.INSTANCE);
    }

    private final NectereChunkGenerator createNectereGenerator(long seed) {
        class_4766 class_47662 = NECTERE_BIOME_SOURCE_PRESET.method_28469(seed);
        Intrinsics.checkExpressionValueIsNotNull((Object)class_47662, (String)"NECTERE_BIOME_SOURCE_PRESET.getBiomeSource(seed)");
        class_1966 class_19662 = (class_1966)class_47662;
        class_5284 class_52842 = NECTERE_CHUNK_GENERATOR_TYPE_PRESET.method_28568();
        Intrinsics.checkExpressionValueIsNotNull((Object)class_52842, (String)"NECTERE_CHUNK_GENERATOR_\u2026PRESET.chunkGeneratorType");
        return new NectereChunkGenerator(class_19662, seed, class_52842);
    }

    private final class_4766 createNectereBiomeSource(long seed) {
        return new class_4766(seed, (List)HotMBiomes.INSTANCE.biomes().values().stream().flatMap(createNectereBiomeSource.1.INSTANCE).collect(ImmutableList.toImmutableList()), Optional.of(NECTERE_BIOME_SOURCE_PRESET));
    }

    public final boolean attemptNectereTeleportation(@NotNull class_1297 entity, @NotNull class_1937 world, @NotNull class_2338 portalPos) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)portalPos, (String)"portalPos");
        class_1937 class_19372 = world;
        if (!(class_19372 instanceof class_3218)) {
            class_19372 = null;
        }
        class_3218 class_32182 = (class_3218)class_19372;
        if (class_32182 != null) {
            class_3218 class_32183 = class_32182;
            boolean bl2 = false;
            boolean bl3 = false;
            class_3218 serverWorld = class_32183;
            boolean bl4 = false;
            if (entity.field_6018 > 0) {
                entity.field_6018 = entity.method_5806();
                bl = true;
            } else {
                MinecraftServer minecraftServer = serverWorld.method_8503();
                Intrinsics.checkExpressionValueIsNotNull((Object)minecraftServer, (String)"serverWorld.server");
                MinecraftServer server = minecraftServer;
                if (Intrinsics.areEqual((Object)((class_3218)world).method_27983(), NECTERE_KEY)) {
                    List newPoses;
                    class_3218 newWorld = INSTANCE.getCorrespondingNonNectereWorld(serverWorld, portalPos);
                    List list = newPoses = INSTANCE.getCorrespondingNonNectereCoords((class_4538)serverWorld, portalPos).collect(Collectors.toList());
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"newPoses");
                    bl = INSTANCE.attemptTeleport(newWorld, list, entity);
                } else {
                    List newPoses;
                    class_3218 nectereWorld = INSTANCE.getNectereWorld(server);
                    List list = newPoses = INSTANCE.getCorrespondingNectereCoords(serverWorld, portalPos, nectereWorld).collect(Collectors.toList());
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"newPoses");
                    bl = INSTANCE.attemptTeleport(nectereWorld, list, entity);
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean attemptTeleport(class_3218 destWorld, List<? extends class_2338> destPoses, class_1297 entity) {
        class_1297 res2;
        class_2338 finalPos;
        if (destWorld == null) return false;
        Collection collection = destPoses;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        class_2338 destPos = this.findNecterePortal((class_4538)destWorld, destPoses);
        if (destPos == null && HotMConfig.Companion.getCONFIG().getGenerateMissingPortals()) {
            destPos = this.createNecterePortal((class_1936)destWorld, destPoses);
        }
        if ((finalPos = destPos) == null) return false;
        class_1297 class_12972 = res2 = FabricDimensions.teleport((class_1297)entity, (class_3218)destWorld, (EntityPlacer)new EntityPlacer(finalPos){
            final /* synthetic */ class_2338 $finalPos;

            @NotNull
            public final class_2700.class_4297 placeEntity(class_1297 oldEntity, class_3218 $noName_1, class_2350 $noName_2, double $noName_3, double $noName_4) {
                class_1297 class_12972 = oldEntity;
                Intrinsics.checkExpressionValueIsNotNull((Object)class_12972, (String)"oldEntity");
                return HotMDimensions.access$getTeleportTarget(HotMDimensions.INSTANCE, class_12972, this.$finalPos);
            }
            {
                this.$finalPos = class_23382;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)class_12972, (String)"res");
        res2.field_6018 = class_12972.method_5806();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final class_2338 findNecterePortal(class_4538 world, List<? extends class_2338> newPoses) {
        int n = 0;
        int n2 = 256;
        while (n < n2) {
            void offset;
            for (class_2338 class_23382 : newPoses) {
                class_2338 up = class_23382.method_10086((int)offset);
                class_2338 down = class_23382.method_10087((int)offset);
                if (!class_1937.method_8518((class_2338)up)) {
                    class_2680 class_26802 = world.method_8320(up);
                    Intrinsics.checkExpressionValueIsNotNull((Object)class_26802, (String)"world.getBlockState(up)");
                    if (Intrinsics.areEqual((Object)class_26802.method_26204(), (Object)((Object)HotMBlocks.INSTANCE.getNECTERE_PORTAL()))) {
                        class_2338 class_23383 = up;
                        Intrinsics.checkExpressionValueIsNotNull((Object)class_23383, (String)"up");
                        return this.findPortalBase(world, class_23383);
                    }
                }
                if (class_1937.method_8518((class_2338)down)) continue;
                class_2680 class_26803 = world.method_8320(down);
                Intrinsics.checkExpressionValueIsNotNull((Object)class_26803, (String)"world.getBlockState(down)");
                if (!Intrinsics.areEqual((Object)class_26803.method_26204(), (Object)((Object)HotMBlocks.INSTANCE.getNECTERE_PORTAL()))) continue;
                class_2338 class_23384 = down;
                Intrinsics.checkExpressionValueIsNotNull((Object)class_23384, (String)"down");
                return this.findPortalBase(world, class_23384);
            }
            ++offset;
        }
        return null;
    }

    private final class_2338 findPortalBase(class_4538 world, class_2338 portalPos) {
        class_2338.class_2339 mut = portalPos.method_25503();
        while (true) {
            class_2680 class_26802 = world.method_8320(mut.method_10074());
            Intrinsics.checkExpressionValueIsNotNull((Object)class_26802, (String)"world.getBlockState(mut.down())");
            if (!Intrinsics.areEqual((Object)class_26802.method_26204(), (Object)((Object)HotMBlocks.INSTANCE.getNECTERE_PORTAL()))) break;
            mut.method_10098(class_2350.field_11033);
        }
        class_2338 class_23382 = mut.method_10062();
        Intrinsics.checkExpressionValueIsNotNull((Object)class_23382, (String)"mut.toImmutable()");
        return class_23382;
    }

    private final class_2338 createNecterePortal(class_1936 world, List<? extends class_2338> newPoses) {
        Random rand = new Random();
        class_2338 portalXZ = newPoses.get(rand.nextInt(newPoses.size()));
        class_2338 portalPos = new class_2338(portalXZ.method_10263(), NecterePortalGen.INSTANCE.getPortalStructureY(world, portalXZ.method_10263(), portalXZ.method_10260(), rand) + 1, portalXZ.method_10260());
        class_2338 structurePos = NecterePortalGen.INSTANCE.unPortalPos(portalPos);
        NecterePortalGen.INSTANCE.generate(world, structurePos);
        return portalPos;
    }

    private final class_2700.class_4297 getTeleportTarget(class_1297 oldEntity, class_2338 destinationPos) {
        return new class_2700.class_4297(class_243.method_24954((class_2382)((class_2382)destinationPos)).method_1031(0.5, 0.0, 0.5), class_243.field_1353, (int)oldEntity.field_6031);
    }

    private final class_2700.class_4297 getGenericTeleportTarget(class_1297 oldEntity, class_3218 destination) {
        destination.method_22350(oldEntity.method_24515());
        class_2338 position = destination.method_8598(class_2902.class_2903.field_13202, oldEntity.method_24515());
        return new class_2700.class_4297(class_243.method_24954((class_2382)((class_2382)position)).method_1031(0.5, 0.5, 0.5), class_243.field_1353, (int)oldEntity.field_6031);
    }

    @NotNull
    public final class_3218 getNectereWorld(@NotNull MinecraftServer server) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        if (server.method_3847(NECTERE_KEY) == null && server instanceof MutableMinecraftServer) {
            HotMLog.INSTANCE.getLog().info("Adding the Nectere dimension...");
            DimensionAdditions.addDimensionToServer((MutableMinecraftServer)server, NECTERE_OPTIONS_KEY);
        }
        class_3218 class_32182 = server.method_3847(NECTERE_KEY);
        if (class_32182 == null) {
            throw (Throwable)new IllegalStateException("Unable to add Nectere dimension!");
        }
        return class_32182;
    }

    public final void findBiomes() {
        for (class_1959 biome : class_2378.field_11153) {
            if (!(biome instanceof NectereBiome) || !((NectereBiome)biome).isPortalable()) continue;
            NECTERE_PORTAL_BIOMES.put(((NectereBiome)biome).getTargetWorld(), (Object)biome);
        }
        RegistryEntryAddedCallback.event((class_2378)class_2378.field_11153).register((Object)findBiomes.1.INSTANCE);
    }

    @NotNull
    public final Stream<class_2338> getCorrespondingNectereCoords(@NotNull class_3218 currentWorld, @NotNull class_2338 currentPos, @NotNull class_3218 nectereWorld) {
        Intrinsics.checkParameterIsNotNull((Object)currentWorld, (String)"currentWorld");
        Intrinsics.checkParameterIsNotNull((Object)currentPos, (String)"currentPos");
        Intrinsics.checkParameterIsNotNull((Object)nectereWorld, (String)"nectereWorld");
        Stream<class_2338> stream = NECTERE_PORTAL_BIOMES.get((Object)currentWorld.method_27983()).stream().flatMap(new Function<T, Stream<? extends R>>(currentPos, nectereWorld){
            final /* synthetic */ class_2338 $currentPos;
            final /* synthetic */ class_3218 $nectereWorld;

            public final Stream<class_2338> apply(NectereBiome nectereBiome) {
                class_2338 newPos;
                return nectereBiome.isPortalable() ? (nectereBiome.getCoordinateMultiplier() < 1.0 ? IntStream.range(class_3532.method_15357((double)((double)this.$currentPos.method_10263() / nectereBiome.getCoordinateMultiplier())), class_3532.method_15357((double)((double)(this.$currentPos.method_10263() + 1) / nectereBiome.getCoordinateMultiplier()))).mapToObj(getCorrespondingNectereCoords.1.INSTANCE).flatMap((Function)new Function<T, Stream<? extends R>>(this, nectereBiome){
                    final /* synthetic */ getCorrespondingNectereCoords.1 this$0;
                    final /* synthetic */ NectereBiome $nectereBiome;

                    public final Stream<class_2338> apply(Integer x) {
                        return IntStream.range(class_3532.method_15357((double)((double)this.this$0.$currentPos.method_10260() / this.$nectereBiome.getCoordinateMultiplier())), class_3532.method_15357((double)((double)(this.this$0.$currentPos.method_10260() + 1) / this.$nectereBiome.getCoordinateMultiplier()))).mapToObj((IntFunction)new IntFunction<class_2338>(this, x){
                            final /* synthetic */ getCorrespondingNectereCoords.2 this$0;
                            final /* synthetic */ Integer $x;

                            @NotNull
                            public final class_2338 apply(int z) {
                                Integer n = this.$x;
                                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"x");
                                return new class_2338(n.intValue(), this.this$0.this$0.$currentPos.method_10264(), z);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$x = n;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$nectereBiome = nectereBiome;
                    }
                }).filter((Predicate)new Predicate<class_2338>(this, nectereBiome){
                    final /* synthetic */ getCorrespondingNectereCoords.1 this$0;
                    final /* synthetic */ NectereBiome $nectereBiome;

                    public final boolean test(class_2338 it) {
                        return Intrinsics.areEqual((Object)this.this$0.$nectereWorld.method_23753(it), (Object)this.$nectereBiome);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$nectereBiome = nectereBiome;
                    }
                }) : (Intrinsics.areEqual((Object)this.$nectereWorld.method_23753(newPos = new class_2338((double)this.$currentPos.method_10263() / nectereBiome.getCoordinateMultiplier(), (double)this.$currentPos.method_10264(), (double)this.$currentPos.method_10260() / nectereBiome.getCoordinateMultiplier())), (Object)nectereBiome) ? Stream.of(newPos) : Stream.empty())) : Stream.empty();
            }
            {
                this.$currentPos = class_23382;
                this.$nectereWorld = class_32182;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"NECTERE_PORTAL_BIOMES.ge\u2026)\n            }\n        }");
        return stream;
    }

    @NotNull
    public final Stream<class_2338> getNonNecterePortalCoords(@NotNull class_5321<class_1937> currentWorldKey, @NotNull class_1923 currentPos, @NotNull Function2<? super Integer, ? super Integer, Integer> heightFn, @NotNull class_3218 nectereWorld) {
        Intrinsics.checkParameterIsNotNull(currentWorldKey, (String)"currentWorldKey");
        Intrinsics.checkParameterIsNotNull((Object)currentPos, (String)"currentPos");
        Intrinsics.checkParameterIsNotNull(heightFn, (String)"heightFn");
        Intrinsics.checkParameterIsNotNull((Object)nectereWorld, (String)"nectereWorld");
        if (Intrinsics.areEqual(currentWorldKey, NECTERE_KEY)) {
            throw (Throwable)new IllegalArgumentException("Cannot get non-Nectere portal gen coords in a Nectere world");
        }
        Stream<class_2338> stream = NECTERE_PORTAL_BIOMES.get(currentWorldKey).stream().flatMap(new Function<T, Stream<? extends R>>(currentPos, heightFn, nectereWorld){
            final /* synthetic */ class_1923 $currentPos;
            final /* synthetic */ Function2 $heightFn;
            final /* synthetic */ class_3218 $nectereWorld;

            public final Stream<class_2338> apply(NectereBiome nectereBiome) {
                Stream<R> stream;
                if (nectereBiome.isPortalable()) {
                    if (nectereBiome.getCoordinateMultiplier() < 1.0) {
                        stream = IntStream.range(class_3532.method_15357((double)((double)this.$currentPos.field_9181 / nectereBiome.getCoordinateMultiplier())), class_3532.method_15357((double)((double)(this.$currentPos.field_9181 + 1) / nectereBiome.getCoordinateMultiplier()))).mapToObj(getNonNecterePortalCoords.1.INSTANCE).flatMap((Function)new Function<T, Stream<? extends R>>(this, nectereBiome){
                            final /* synthetic */ getNonNecterePortalCoords.1 this$0;
                            final /* synthetic */ NectereBiome $nectereBiome;

                            public final Stream<class_1923> apply(Integer x) {
                                return IntStream.range(class_3532.method_15357((double)((double)this.this$0.$currentPos.field_9180 / this.$nectereBiome.getCoordinateMultiplier())), class_3532.method_15357((double)((double)(this.this$0.$currentPos.field_9180 + 1) / this.$nectereBiome.getCoordinateMultiplier()))).mapToObj((IntFunction)new IntFunction<class_1923>(x){
                                    final /* synthetic */ Integer $x;

                                    @NotNull
                                    public final class_1923 apply(int z) {
                                        Integer n = this.$x;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"x");
                                        return new class_1923(n.intValue(), z);
                                    }
                                    {
                                        this.$x = n;
                                    }
                                });
                            }
                            {
                                this.this$0 = var1_1;
                                this.$nectereBiome = nectereBiome;
                            }
                        }).flatMap((Function)new Function<T, Stream<? extends R>>(this, nectereBiome){
                            final /* synthetic */ getNonNecterePortalCoords.1 this$0;
                            final /* synthetic */ NectereBiome $nectereBiome;

                            @NotNull
                            public final Stream<class_2338> apply(class_1923 necterePos) {
                                class_1923 class_19232 = this.this$0.$currentPos;
                                Function2 function2 = this.this$0.$heightFn;
                                class_3218 class_32182 = this.this$0.$nectereWorld;
                                NectereBiome nectereBiome = this.$nectereBiome;
                                Intrinsics.checkExpressionValueIsNotNull((Object)nectereBiome, (String)"nectereBiome");
                                class_1923 class_19233 = necterePos;
                                Intrinsics.checkExpressionValueIsNotNull((Object)class_19233, (String)"necterePos");
                                return HotMDimensions.access$getNonNecterePortalCoordsForBiome(HotMDimensions.INSTANCE, class_19232, function2, class_32182, nectereBiome, class_19233);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$nectereBiome = nectereBiome;
                            }
                        });
                    } else {
                        class_1923 necterePos = new class_1923(class_3532.method_15357((double)((double)this.$currentPos.field_9181 / nectereBiome.getCoordinateMultiplier())), class_3532.method_15357((double)((double)this.$currentPos.field_9180 / nectereBiome.getCoordinateMultiplier())));
                        NectereBiome nectereBiome2 = nectereBiome;
                        Intrinsics.checkExpressionValueIsNotNull((Object)nectereBiome2, (String)"nectereBiome");
                        stream = HotMDimensions.access$getNonNecterePortalCoordsForBiome(HotMDimensions.INSTANCE, this.$currentPos, this.$heightFn, this.$nectereWorld, nectereBiome2, necterePos);
                    }
                } else {
                    stream = Stream.empty();
                }
                return stream;
            }
            {
                this.$currentPos = class_19232;
                this.$heightFn = function2;
                this.$nectereWorld = class_32182;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"NECTERE_PORTAL_BIOMES.ge\u2026)\n            }\n        }");
        return stream;
    }

    private final Stream<class_2338> getNonNecterePortalCoordsForBiome(class_1923 currentPos, Function2<? super Integer, ? super Integer, Integer> heightFn, class_3218 nectereWorld, NectereBiome nectereBiome, class_1923 necterePos) {
        class_2794 chunkGenerator;
        class_2919 chunkRandom = new class_2919();
        class_3215 class_32152 = nectereWorld.method_14178();
        Intrinsics.checkExpressionValueIsNotNull((Object)class_32152, (String)"nectereWorld.chunkManager");
        class_2794 class_27942 = class_32152.method_12129();
        Intrinsics.checkExpressionValueIsNotNull((Object)class_27942, (String)"nectereWorld.chunkManager.chunkGenerator");
        class_5314 structureConfig = class_27942.method_12109().method_28600((class_3195)HotMStructureFeatures.INSTANCE.getNECTERE_PORTAL());
        class_1923 portalChunk = HotMStructureFeatures.INSTANCE.getNECTERE_PORTAL().method_27218(structureConfig, nectereWorld.method_8412(), chunkRandom, necterePos.field_9181, necterePos.field_9180);
        class_3215 class_32153 = nectereWorld.method_14178();
        Intrinsics.checkExpressionValueIsNotNull((Object)class_32153, (String)"nectereWorld.chunkManager");
        class_2794 class_27943 = chunkGenerator = class_32153.method_12129();
        Intrinsics.checkExpressionValueIsNotNull((Object)class_27943, (String)"chunkGenerator");
        class_1966 biomeSource = class_27943.method_12098();
        NecterePortalStructureFeature necterePortalStructureFeature = HotMStructureFeatures.INSTANCE.getNECTERE_PORTAL();
        if (necterePortalStructureFeature == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.github.hotm.mixin.StructureFeatureAccessor");
        }
        NectereBiome nectereBiome2 = nectereBiome;
        if (nectereBiome2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.world.biome.Biome");
        }
        if (((StructureFeatureAccessor)((Object)necterePortalStructureFeature)).callShouldStartAt(chunkGenerator, biomeSource, nectereWorld.method_8412(), chunkRandom, necterePos.field_9181, necterePos.field_9180, (class_1959)nectereBiome2, necterePos, (class_3037)class_3037.field_13603)) {
            class_2338 necterePortalPos = new class_2338(NecterePortalGen.INSTANCE.getPortalX(portalChunk.field_9181), 64, NecterePortalGen.INSTANCE.getPortalZ(portalChunk.field_9180));
            class_1959 biome = biomeSource.method_16359(necterePortalPos.method_10263() >> 2, necterePortalPos.method_10264() >> 2, necterePortalPos.method_10260() >> 2);
            if (Intrinsics.areEqual((Object)biome, (Object)nectereBiome)) {
                Stream<class_2338> stream;
                int resX = class_3532.method_15357((double)((double)necterePortalPos.method_10263() * nectereBiome.getCoordinateMultiplier()));
                int resZ = class_3532.method_15357((double)((double)necterePortalPos.method_10260() * nectereBiome.getCoordinateMultiplier()));
                if (resX >> 4 == currentPos.field_9181 && resZ >> 4 == currentPos.field_9180) {
                    class_2338 resPos = NecterePortalGen.INSTANCE.unPortalPos(new class_2338(resX, ((Number)heightFn.invoke((Object)resX, (Object)resZ)).intValue() + 1, resZ));
                    Stream<class_2338> stream2 = Stream.of(resPos);
                    stream = stream2;
                    Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"Stream.of(resPos)");
                } else {
                    Stream<class_2338> stream3 = Stream.empty();
                    stream = stream3;
                    Intrinsics.checkExpressionValueIsNotNull(stream3, (String)"Stream.empty()");
                }
                return stream;
            }
            Stream<class_2338> stream = Stream.empty();
            Intrinsics.checkExpressionValueIsNotNull(stream, (String)"Stream.empty()");
            return stream;
        }
        Stream<class_2338> stream = Stream.empty();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"Stream.empty()");
        return stream;
    }

    @NotNull
    public final Stream<class_2338> getCorrespondingNonNectereCoords(@NotNull class_4538 nectereWorld, @NotNull class_2338 necterePos) {
        Stream<class_2338> stream;
        Intrinsics.checkParameterIsNotNull((Object)nectereWorld, (String)"nectereWorld");
        Intrinsics.checkParameterIsNotNull((Object)necterePos, (String)"necterePos");
        class_1959 nectereBiome = nectereWorld.method_23753(necterePos);
        if (nectereBiome instanceof NectereBiome && ((NectereBiome)nectereBiome).isPortalable()) {
            Stream<Object> stream2 = ((NectereBiome)nectereBiome).getCoordinateMultiplier() > 1.0 ? IntStream.range(class_3532.method_15357((double)((double)necterePos.method_10263() * ((NectereBiome)nectereBiome).getCoordinateMultiplier())), class_3532.method_15357((double)((double)(necterePos.method_10263() + 1) * ((NectereBiome)nectereBiome).getCoordinateMultiplier()))).mapToObj(getCorrespondingNonNectereCoords.1.INSTANCE).flatMap(new Function<T, Stream<? extends R>>(necterePos, nectereBiome){
                final /* synthetic */ class_2338 $necterePos;
                final /* synthetic */ class_1959 $nectereBiome;

                public final Stream<class_2338> apply(Integer x) {
                    return IntStream.range(class_3532.method_15357((double)((double)this.$necterePos.method_10260() * ((NectereBiome)this.$nectereBiome).getCoordinateMultiplier())), class_3532.method_15357((double)((double)(this.$necterePos.method_10260() + 1) * ((NectereBiome)this.$nectereBiome).getCoordinateMultiplier()))).mapToObj((IntFunction)new IntFunction<class_2338>(this, x){
                        final /* synthetic */ getCorrespondingNonNectereCoords.2 this$0;
                        final /* synthetic */ Integer $x;

                        @NotNull
                        public final class_2338 apply(int z) {
                            Integer n = this.$x;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"x");
                            return new class_2338(n.intValue(), this.this$0.$necterePos.method_10264(), z);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$x = n;
                        }
                    });
                }
                {
                    this.$necterePos = class_23382;
                    this.$nectereBiome = class_19592;
                }
            }) : Stream.of(new class_2338((double)necterePos.method_10263() * ((NectereBiome)nectereBiome).getCoordinateMultiplier(), (double)necterePos.method_10264(), (double)necterePos.method_10260() * ((NectereBiome)nectereBiome).getCoordinateMultiplier()));
            stream = stream2;
            Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"if (nectereBiome.coordin\u2026          )\n            }");
        } else {
            Stream<class_2338> stream3 = Stream.empty();
            stream = stream3;
            Intrinsics.checkExpressionValueIsNotNull(stream3, (String)"Stream.empty()");
        }
        return stream;
    }

    @Nullable
    public final class_2338 getBaseCorrespondingNonNectereCoords(@NotNull class_4538 nectereWorld, @NotNull class_2338 necterePos) {
        Intrinsics.checkParameterIsNotNull((Object)nectereWorld, (String)"nectereWorld");
        Intrinsics.checkParameterIsNotNull((Object)necterePos, (String)"necterePos");
        class_1959 nectereBiome = nectereWorld.method_23753(necterePos);
        return nectereBiome instanceof NectereBiome && ((NectereBiome)nectereBiome).isPortalable() ? new class_2338((double)necterePos.method_10263() * ((NectereBiome)nectereBiome).getCoordinateMultiplier(), (double)necterePos.method_10264(), (double)necterePos.method_10260() * ((NectereBiome)nectereBiome).getCoordinateMultiplier()) : null;
    }

    @Nullable
    public final class_3218 getCorrespondingNonNectereWorld(@NotNull class_3218 nectereWorld, @NotNull class_2338 necterePos) {
        class_3218 class_32182;
        Intrinsics.checkParameterIsNotNull((Object)nectereWorld, (String)"nectereWorld");
        Intrinsics.checkParameterIsNotNull((Object)necterePos, (String)"necterePos");
        MinecraftServer minecraftServer = nectereWorld.method_8503();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraftServer, (String)"nectereWorld.server");
        MinecraftServer server = minecraftServer;
        class_1959 biome = nectereWorld.method_23753(necterePos);
        if (biome instanceof NectereBiome && ((NectereBiome)biome).isPortalable()) {
            class_3218 world = server.method_3847(((NectereBiome)biome).getTargetWorld());
            if (world == null) {
                HotMLog.INSTANCE.getLog().warn("Attempted to get non-existent world for Nectere biome with world key: " + ((NectereBiome)biome).getTargetWorld());
            }
            class_32182 = world;
        } else {
            class_32182 = null;
        }
        return class_32182;
    }

    @Nullable
    public final class_2338 locateNonNectereSidePortal(@NotNull class_3218 currentWorld, @NotNull class_2338 currentPos, int radius, boolean skipExistingChunks) {
        Intrinsics.checkParameterIsNotNull((Object)currentWorld, (String)"currentWorld");
        Intrinsics.checkParameterIsNotNull((Object)currentPos, (String)"currentPos");
        MinecraftServer minecraftServer = currentWorld.method_8503();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraftServer, (String)"currentWorld.server");
        class_3218 nectereWorld = this.getNectereWorld(minecraftServer);
        return NECTERE_PORTAL_BIOMES.get((Object)currentWorld.method_27983()).stream().flatMap(new Function<T, Stream<? extends R>>(currentPos, nectereWorld, radius, skipExistingChunks, currentWorld){
            final /* synthetic */ class_2338 $currentPos;
            final /* synthetic */ class_3218 $nectereWorld;
            final /* synthetic */ int $radius;
            final /* synthetic */ boolean $skipExistingChunks;
            final /* synthetic */ class_3218 $currentWorld;

            public final Stream<class_2338> apply(NectereBiome nectereBiome) {
                Stream<Object> stream;
                if (nectereBiome.isPortalable()) {
                    class_2338 necterePos = new class_2338((double)this.$currentPos.method_10263() / nectereBiome.getCoordinateMultiplier(), (double)this.$currentPos.method_10264(), (double)this.$currentPos.method_10260() / nectereBiome.getCoordinateMultiplier());
                    NecterePortalStructureFeature necterePortalStructureFeature = HotMStructureFeatures.INSTANCE.getNECTERE_PORTAL();
                    class_4538 class_45382 = (class_4538)this.$nectereWorld;
                    class_5138 class_51382 = this.$nectereWorld.method_27056();
                    Intrinsics.checkExpressionValueIsNotNull((Object)class_51382, (String)"nectereWorld.structureAccessor");
                    long l = this.$nectereWorld.method_8412();
                    class_3215 class_32152 = this.$nectereWorld.method_14178();
                    Intrinsics.checkExpressionValueIsNotNull((Object)class_32152, (String)"nectereWorld.chunkManager");
                    class_2794 class_27942 = class_32152.method_12129();
                    Intrinsics.checkExpressionValueIsNotNull((Object)class_27942, (String)"nectereWorld.chunkManager.chunkGenerator");
                    class_5314 class_53142 = class_27942.method_12109().method_28600((class_3195)HotMStructureFeatures.INSTANCE.getNECTERE_PORTAL());
                    Intrinsics.checkExpressionValueIsNotNull((Object)class_53142, (String)"nectereWorld.chunkManage\u2026eFeatures.NECTERE_PORTAL)");
                    NectereBiome nectereBiome2 = nectereBiome;
                    Intrinsics.checkExpressionValueIsNotNull((Object)nectereBiome2, (String)"nectereBiome");
                    class_2338 foundPos = necterePortalStructureFeature.locateNonNectereSidePortal(class_45382, class_51382, necterePos, this.$radius, this.$skipExistingChunks, l, class_53142, nectereBiome2, this.$currentWorld);
                    stream = foundPos != null ? Stream.of(foundPos) : Stream.empty();
                } else {
                    stream = Stream.empty();
                }
                return stream;
            }
            {
                this.$currentPos = class_23382;
                this.$nectereWorld = class_32182;
                this.$radius = n;
                this.$skipExistingChunks = bl;
                this.$currentWorld = class_32183;
            }
        }).min(Comparator.comparing(new Function<T, U>(currentPos){
            final /* synthetic */ class_2338 $currentPos;

            public final double apply(class_2338 portalPos) {
                return portalPos.method_10262((class_2382)this.$currentPos);
            }
            {
                this.$currentPos = class_23382;
            }
        })).orElse(null);
    }

    private HotMDimensions() {
    }

    static {
        HotMDimensions hotMDimensions;
        INSTANCE = hotMDimensions = new HotMDimensions();
        NECTERE_PORTAL_BIOMES = HashMultimap.create();
        class_5321 class_53212 = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)HotMConstants.INSTANCE.identifier("nectere"));
        Intrinsics.checkExpressionValueIsNotNull((Object)class_53212, (String)"RegistryKey.of(Registry.\u2026ts.identifier(\"nectere\"))");
        NECTERE_KEY = class_53212;
        NECTERE_OPTIONS_KEY = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)HotMConstants.INSTANCE.identifier("nectere"));
        OptionalLong optionalLong = OptionalLong.empty();
        class_4545 class_45452 = (class_4545)class_4547.field_20646;
        class_3494.class_5123 class_51232 = class_3481.field_25588;
        Intrinsics.checkExpressionValueIsNotNull((Object)class_51232, (String)"BlockTags.INFINIBURN_OVERWORLD");
        NECTERE_TYPE = DimensionAdditions.createDimensionType(optionalLong, true, false, false, true, false, false, false, false, false, false, 256, class_45452, class_51232.method_26791(), 0.1f);
        NECTERE_TYPE_KEY = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)HotMConstants.INSTANCE.identifier("nectere"));
        NECTERE_CHUNK_GENERATOR_TYPE_PRESET = new class_5284.class_5307("hotm:nectere", (Function)NECTERE_CHUNK_GENERATOR_TYPE_PRESET.1.INSTANCE);
        NECTERE_BIOME_SOURCE_PRESET = new class_4766.class_5305(HotMConstants.INSTANCE.identifier("nectere"), (LongFunction)NECTERE_BIOME_SOURCE_PRESET.1.INSTANCE);
    }

    public static final /* synthetic */ NectereChunkGenerator access$createNectereGenerator(HotMDimensions $this, long seed) {
        return $this.createNectereGenerator(seed);
    }

    public static final /* synthetic */ class_2700.class_4297 access$getGenericTeleportTarget(HotMDimensions $this, class_1297 oldEntity, class_3218 destination) {
        return $this.getGenericTeleportTarget(oldEntity, destination);
    }

    public static final /* synthetic */ class_2700.class_4297 access$getTeleportTarget(HotMDimensions $this, class_1297 oldEntity, class_2338 destinationPos) {
        return $this.getTeleportTarget(oldEntity, destinationPos);
    }

    public static final /* synthetic */ HashMultimap access$getNECTERE_PORTAL_BIOMES$p(HotMDimensions $this) {
        HotMDimensions hotMDimensions = $this;
        return NECTERE_PORTAL_BIOMES;
    }

    public static final /* synthetic */ Stream access$getNonNecterePortalCoordsForBiome(HotMDimensions $this, class_1923 currentPos, Function2 heightFn, class_3218 nectereWorld, NectereBiome nectereBiome, class_1923 necterePos) {
        return $this.getNonNecterePortalCoordsForBiome(currentPos, (Function2<? super Integer, ? super Integer, Integer>)heightFn, nectereWorld, nectereBiome, necterePos);
    }

    public static final /* synthetic */ class_4766 access$createNectereBiomeSource(HotMDimensions $this, long seed) {
        return $this.createNectereBiomeSource(seed);
    }
}

