/*
 * Decompiled with CFR 0.152.
 */
package com.github.hotm.gen.feature;

import com.github.hotm.gen.feature.FeatureUtils;
import com.github.hotm.gen.feature.ServerTowerConfig;
import com.mojang.serialization.Codec;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J(\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/github/hotm/gen/feature/ServerTowerFeature;", "Lnet/minecraft/world/gen/feature/Feature;", "Lcom/github/hotm/gen/feature/ServerTowerConfig;", "codec", "Lcom/mojang/serialization/Codec;", "(Lcom/mojang/serialization/Codec;)V", "buildBase", "", "world", "Lnet/minecraft/world/ServerWorldAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "size", "", "config", "findLowest", "generate", "", "structureAccessor", "Lnet/minecraft/world/gen/StructureAccessor;", "generator", "Lnet/minecraft/world/gen/chunk/ChunkGenerator;", "random", "Ljava/util/Random;", "heart-of-the-machine"})
public final class ServerTowerFeature
extends class_3031<ServerTowerConfig> {
    public boolean generate(@NotNull class_5281 world, @NotNull class_5138 structureAccessor, @NotNull class_2794 generator, @NotNull Random random, @NotNull class_2338 pos, @NotNull ServerTowerConfig config) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)structureAccessor, (String)"structureAccessor");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        int height = random.nextInt(config.getMaxHeight() - config.getMinHeight() + 1) + config.getMinHeight();
        int size = random.nextInt(config.getMaxSize() - config.getMinSize() + 1) + config.getMinSize();
        int border = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(random.nextInt(config.getMaxBorder() - config.getMinBorder() + 1) + config.getMinBorder()), (int)(size - size / 2 - 1)), (int)0);
        int windowSize = size - border * 2;
        if (FeatureUtils.INSTANCE.isFilledWithAir(world, pos.method_10263() - size + size / 2 + 1, pos.method_10264() + 1, pos.method_10260() - size + size / 2 + 1, pos.method_10263() + size / 2, pos.method_10264() + height + size + 1, pos.method_10260() + size / 2)) {
            this.buildBase(world, pos, size, config);
            FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() - size + size / 2 + 1, pos.method_10264(), pos.method_10260() - size + size / 2 + 1, pos.method_10263() + size / 2, pos.method_10264() + height - 1, pos.method_10260() + size / 2, config.getStructure());
            FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() - size + size / 2 + 1, pos.method_10264() + height, pos.method_10260() - size + size / 2 + 1, pos.method_10263() + size / 2, pos.method_10264() + height, pos.method_10260() + size / 2, random.nextFloat() < config.getFlatLampChance() ? config.getFlatLamp() : config.getStructure());
            FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() - size + size / 2 + 1, pos.method_10264() + height + 1, pos.method_10260() - size + size / 2 + 1, pos.method_10263() + size / 2, pos.method_10264() + height + size, pos.method_10260() + size / 2, config.getStructure());
            FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() - size + size / 2 + 1, pos.method_10264() + height + border + 1, pos.method_10260() - windowSize + windowSize / 2 + 1, pos.method_10263() - size + size / 2 + 1, pos.method_10264() + height + size - border, pos.method_10260() + windowSize / 2, config.getLamp());
            FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() + size / 2, pos.method_10264() + height + border + 1, pos.method_10260() - windowSize + windowSize / 2 + 1, pos.method_10263() + size / 2, pos.method_10264() + height + size - border, pos.method_10260() + windowSize / 2, config.getLamp());
            FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() - windowSize + windowSize / 2 + 1, pos.method_10264() + height + border + 1, pos.method_10260() - size + size / 2 + 1, pos.method_10263() + windowSize / 2, pos.method_10264() + height + size - border, pos.method_10260() - size + size / 2 + 1, config.getLamp());
            FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() - windowSize + windowSize / 2 + 1, pos.method_10264() + height + border + 1, pos.method_10260() + size / 2, pos.method_10263() + windowSize / 2, pos.method_10264() + height + size - border, pos.method_10260() + size / 2, config.getLamp());
            FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() - size + size / 2 + 1, pos.method_10264() + height + size + 1, pos.method_10260() - size + size / 2 + 1, pos.method_10263() + size / 2, pos.method_10264() + height + size + 1, pos.method_10260() + size / 2, random.nextFloat() < config.getFlatLampChance() ? config.getFlatLamp() : config.getStructure());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void buildBase(class_5281 world, class_2338 pos, int size, ServerTowerConfig config) {
        int minY = this.findLowest(world, pos, size, config);
        FeatureUtils.INSTANCE.fillBlocks(world, pos.method_10263() - size + size / 2 + 1, minY, pos.method_10260() - size + size / 2 + 1, pos.method_10263() + size / 2, pos.method_10264(), pos.method_10260() + size / 2, config.getStructure());
    }

    /*
     * WARNING - void declaration
     */
    private final int findLowest(class_5281 world, class_2338 pos, int size, ServerTowerConfig config) {
        class_2338.class_2339 mutable = pos.method_25503();
        boolean water = false;
        for (int y = pos.method_10264(); y >= pos.method_10264() - config.getMaxDrop() || water; --y) {
            int n;
            water = false;
            boolean solid = true;
            int n2 = pos.method_10263() - size + size / 2 + 1;
            if (n2 <= (n = pos.method_10263() + size / 2)) {
                while (true) {
                    void x;
                    int n3;
                    int n4;
                    if ((n4 = pos.method_10260() - size + size / 2 + 1) <= (n3 = pos.method_10260() + size / 2)) {
                        while (true) {
                            void z;
                            mutable.method_10103((int)x, y, (int)z);
                            if (world.method_22347((class_2338)mutable) || world.method_22351((class_2338)mutable)) {
                                solid = false;
                            }
                            if (world.method_22351((class_2338)mutable)) {
                                water = true;
                            }
                            if (z == n3) break;
                            ++z;
                        }
                    }
                    if (x == n) break;
                    ++x;
                }
            }
            if (!solid) continue;
            return y + 1;
        }
        return config.getMaxDrop();
    }

    public ServerTowerFeature(@NotNull Codec<ServerTowerConfig> codec) {
        Intrinsics.checkParameterIsNotNull(codec, (String)"codec");
        super(codec);
    }
}

