/*
 * Decompiled with CFR 0.152.
 */
package com.github.hotm.gen.feature.segment;

import com.github.hotm.gen.feature.segment.BlockPlacement;
import com.github.hotm.gen.feature.segment.PositionedFeatureSegment;
import com.github.hotm.gen.feature.segment.SegmentedFeatureConfig;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.serialization.Codec;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/github/hotm/gen/feature/segment/SegmentedFeature;", "Lnet/minecraft/world/gen/feature/Feature;", "Lcom/github/hotm/gen/feature/segment/SegmentedFeatureConfig;", "codec", "Lcom/mojang/serialization/Codec;", "(Lcom/mojang/serialization/Codec;)V", "generate", "", "world", "Lnet/minecraft/world/ServerWorldAccess;", "structureAccessor", "Lnet/minecraft/world/gen/StructureAccessor;", "generator", "Lnet/minecraft/world/gen/chunk/ChunkGenerator;", "random", "Ljava/util/Random;", "pos", "Lnet/minecraft/util/math/BlockPos;", "config", "Companion", "heart-of-the-machine"})
public final class SegmentedFeature
extends class_3031<SegmentedFeatureConfig> {
    private static final int MAX_SEGMENTS = 128;
    public static final Companion Companion = new Companion(null);

    public boolean generate(@NotNull class_5281 world, @NotNull class_5138 structureAccessor, @NotNull class_2794 generator, @NotNull Random random, @NotNull class_2338 pos, @NotNull SegmentedFeatureConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)structureAccessor, (String)"structureAccessor");
        Intrinsics.checkParameterIsNotNull((Object)generator, (String)"generator");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        HashMap blocks = Maps.newHashMap();
        ArrayDeque segments = Queues.newArrayDeque();
        segments.add(new PositionedFeatureSegment<Unit>(pos, config.getInitial(), Unit.INSTANCE));
        int segmentCount = 0;
        while (true) {
            ArrayDeque arrayDeque = segments;
            Intrinsics.checkExpressionValueIsNotNull((Object)arrayDeque, (String)"segments");
            Collection collection = arrayDeque;
            boolean bl = false;
            if (!(!collection.isEmpty()) || segmentCount >= MAX_SEGMENTS) break;
            PositionedFeatureSegment segment = (PositionedFeatureSegment)segments.remove();
            HashMap hashMap = blocks;
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"blocks");
            if (!segment.tryGenerate(hashMap, segments, world, structureAccessor, generator, random)) {
                return false;
            }
            ++segmentCount;
        }
        HashMap hashMap = blocks;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"blocks");
        Map map = hashMap;
        boolean bl = false;
        for (Map.Entry placement : map.entrySet()) {
            if (!((BlockPlacement)placement.getValue()).getReplaceTerrain() && !world.method_22347((class_2338)placement.getKey())) continue;
            world.method_8652((class_2338)placement.getKey(), ((BlockPlacement)placement.getValue()).getState(), ((BlockPlacement)placement.getValue()).getFlags());
        }
        return true;
    }

    public SegmentedFeature(@NotNull Codec<SegmentedFeatureConfig> codec) {
        Intrinsics.checkParameterIsNotNull(codec, (String)"codec");
        super(codec);
    }

    static {
        MAX_SEGMENTS = 128;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/hotm/gen/feature/segment/SegmentedFeature$Companion;", "", "()V", "MAX_SEGMENTS", "", "heart-of-the-machine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

