/*
 * Decompiled with CFR 0.152.
 */
package com.github.hotm.mixinapi;

import com.github.hotm.gen.HotMDimensions;
import com.github.hotm.mixin.ChunkGeneratorTypeInvoker;
import com.github.hotm.mixin.DimensionTypeInvoker;
import com.github.hotm.mixinapi.ChunkGeneratorSupplier;
import com.github.hotm.mixinapi.DimensionAddition;
import com.github.hotm.mixinapi.MutableMinecraftServer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_4545;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5311;
import net.minecraft.class_5318;
import net.minecraft.class_5321;
import net.minecraft.class_5363;

public class DimensionAdditions {
    private static final List<DimensionAddition> ADDITIONS = new ArrayList<DimensionAddition>();
    private static final Map<class_5321<class_5363>, DimensionAddition> DIMENSION_KEYS = new HashMap<class_5321<class_5363>, DimensionAddition>();
    private static final Map<class_5321<class_1937>, String> SAVE_DIRS = new HashMap<class_5321<class_1937>, String>();

    public static class_5284 createChunkGeneratorType(class_5311 structures, class_5309 noise, class_2680 defaultBlock, class_2680 defaultFluid, int bedrockRoofPosition, int bedrockFloorPosition, int seaLevel, boolean disableMobGeneration) {
        return ChunkGeneratorTypeInvoker.create(structures, noise, defaultBlock, defaultFluid, bedrockRoofPosition, bedrockFloorPosition, seaLevel, disableMobGeneration);
    }

    public static class_5284 createChunkGeneratorType(class_5311 structures, class_5309 noise, class_2680 defaultBlock, class_2680 defaultFluid, int bedrockRoofPosition, int bedrockFloorPosition, int seaLevel, boolean disableMobGeneration, Optional<class_5284.class_5307> preset) {
        return ChunkGeneratorTypeInvoker.create(structures, noise, defaultBlock, defaultFluid, bedrockRoofPosition, bedrockFloorPosition, seaLevel, disableMobGeneration, preset);
    }

    public static class_2874 createDimensionType(OptionalLong fixedTime, boolean hasSkylight, boolean hasCeiling, boolean ultrawarm, boolean natural, boolean shrunk, boolean hasEnderDragonFight, boolean piglinSafe, boolean bedWorks, boolean respawnAnchorWorks, boolean hasRaids, int logicalHeight, class_4545 biomeAccessType, class_2960 infiniburn, float ambientLight) {
        return DimensionTypeInvoker.create(fixedTime, hasSkylight, hasCeiling, ultrawarm, natural, shrunk, hasEnderDragonFight, piglinSafe, bedWorks, respawnAnchorWorks, hasRaids, logicalHeight, biomeAccessType, infiniburn, ambientLight);
    }

    public static void addDimension(DimensionAddition addition) {
        DIMENSION_KEYS.put(addition.getOptionsRegistryKey(), addition);
        ADDITIONS.add(addition);
    }

    public static void addDimension(class_5321<class_5363> optionsKey, class_5321<class_2874> typeKey, class_2874 type, ChunkGeneratorSupplier chunkSupplier) {
        DimensionAdditions.addDimension(new DimensionAddition(optionsKey, typeKey, type, chunkSupplier));
    }

    public static void setSaveDir(class_5321<class_1937> key, String saveDir) {
        SAVE_DIRS.put(key, saveDir);
    }

    public static void setupDimensionOptions(long seed, class_2370<class_5363> optionsRegistry) {
        HotMDimensions.INSTANCE.register();
        System.out.println("HotM Adding Dimensions:");
        for (DimensionAddition addition : ADDITIONS) {
            if (!optionsRegistry.method_10250(addition.getOptionsRegistryKey().method_29177())) {
                optionsRegistry.method_10272(addition.getOptionsRegistryKey(), (Object)new class_5363(addition::getDimensionType, addition.getChunkGeneratorSupplier().getChunkGenerator(seed)));
                optionsRegistry.method_29725(addition.getOptionsRegistryKey());
                System.out.println("    " + addition.getOptionsRegistryKey());
                continue;
            }
            System.out.println("    " + addition.getOptionsRegistryKey() + " : ALREADY REGISTERED");
        }
    }

    public static void setupDimensionTypes(class_5318.class_5319 modifiable) {
        for (DimensionAddition addition : ADDITIONS) {
            modifiable.method_29119(addition.getTypeRegistryKey(), addition.getDimensionType());
        }
    }

    public static boolean containsSaveDir(class_5321<class_1937> key) {
        return SAVE_DIRS.containsKey(key);
    }

    public static File getSaveDir(class_5321<class_1937> key, File root) {
        return new File(root, SAVE_DIRS.get(key));
    }

    public static boolean checkAndRemoveDimensions(long seed, List<Map.Entry<class_5321<class_5363>, class_5363>> list) {
        Iterator<Map.Entry<class_5321<class_5363>, class_5363>> it = list.iterator();
        while (it.hasNext()) {
            Map.Entry<class_5321<class_5363>, class_5363> entry = it.next();
            class_5321<class_5363> key = entry.getKey();
            class_5363 options = entry.getValue();
            if (!DIMENSION_KEYS.containsKey(key)) continue;
            DimensionAddition addition = DIMENSION_KEYS.get(key);
            if (options.method_29570() != addition.getDimensionType()) {
                return false;
            }
            class_2794 generator = addition.getChunkGeneratorSupplier().getChunkGenerator(seed);
            if (!generator.getClass().isAssignableFrom(options.method_29571().getClass())) {
                return false;
            }
            it.remove();
        }
        return true;
    }

    public static void addDimensionToServer(MutableMinecraftServer server, class_5321<class_5363> optionsKey) {
        DimensionAddition addition = DIMENSION_KEYS.get(optionsKey);
        server.hotm_addDimension(optionsKey, new class_5363(addition::getDimensionType, addition.getChunkGeneratorSupplier().getChunkGenerator(server.hotm_getSeed())));
    }
}

