/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.item.IRotorBlade;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.wind.IWindHandler;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityGeneratorBase;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.util.math.Box2D;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class TileEntityWindTurbine
extends TileEntityGeneratorBase {
    public static float MAX_SPEED = 4.0f;
    public static float SPEED_DIFFERENCE = 0.1f;
    @NetworkField(index=7)
    float speed;
    int damageTick = 0;

    public TileEntityWindTurbine() {
        super(2);
        this.production = 32;
        this.maxStorage = 10000;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return null;
    }

    @Override
    public ResourceLocation getTexture() {
        return null;
    }

    @Override
    public Box2D getEnergyBox() {
        return null;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return false;
    }

    @Override
    public boolean gainEnergy() {
        if (this.speed > 0.0f && this.storage <= this.maxStorage) {
            if (this.speed > MAX_SPEED) {
                this.storage = (int)((float)this.storage + (float)this.getProduction() * 0.1f);
                return true;
            }
            this.storage = (int)((float)this.storage + (float)this.getProduction() * this.speed);
            return true;
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        float effect;
        super.func_73660_a();
        IRotorBlade blade = this.getRotorBlade();
        if (blade == null) {
            if (this.speed != 0.0f) {
                this.getNetwork().updateTileGuiField(this, "speed");
            }
            this.speed = 0.0f;
            return;
        }
        EnumFacing facing = this.getFacing();
        float angle = 90.0f;
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            angle = facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 0.0f : 180.0f;
            facing = EnumFacing.NORTH;
        }
        if ((effect = (float)(blade.getWeight((ItemStack)this.inventory.get(1)) / this.getRequiredWeight()) - 0.5f) <= 0.0f) {
            this.speed = Math.max(0.0f, this.speed - SPEED_DIFFERENCE);
            this.getNetwork().updateTileGuiField(this, "speed");
            return;
        }
        effect += 0.5f;
        IWindHandler handler = IC2.windManager.getHanlderFromWorld(this.func_145831_w());
        float expectedSpeed = (float)Math.abs(handler.getWindStrenght(this.func_174877_v(), facing.func_185119_l(), angle)) / (float)handler.getMaxWind();
        expectedSpeed *= MAX_SPEED;
        if (this.speed < 0.2f) {
            this.speed = Math.max(0.0f, this.speed - SPEED_DIFFERENCE);
            this.getNetwork().updateTileGuiField(this, "speed");
            return;
        }
        this.speed = MathHelper.func_76131_a((float)(Math.signum(expectedSpeed - this.speed) * SPEED_DIFFERENCE * effect * blade.getEnergyEfficiency((ItemStack)this.inventory.get(1))), (float)0.0f, (float)(MAX_SPEED * 3.0f));
        this.getNetwork().updateTileGuiField(this, "speed");
        if (this.speed > 0.0f) {
            ++this.damageTick;
            if (this.damageTick >= 200) {
                float damage = this.speed / blade.getMaxSpeed((ItemStack)this.inventory.get(1));
                if ((damage -= 0.05f) > 0.0f && blade.reduceDurability((ItemStack)this.inventory.get(1), (int)(5.0f * damage * (this.speed > MAX_SPEED ? 10.0f : 1.0f)))) {
                    this.inventory.set(1, (Object)ItemStack.field_190927_a);
                }
            }
        }
    }

    public IRotorBlade getRotorBlade() {
        Item item = ((ItemStack)this.inventory.get(1)).func_77973_b();
        return item instanceof IRotorBlade ? (IRotorBlade)item : null;
    }

    public int getRequiredWeight() {
        return 10;
    }

    public int getProduction() {
        return 8;
    }
}

