/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UranEnricherComp
extends GuiComponent {
    TileEntityUraniumEnricher tile;

    public UranEnricherComp(TileEntityUraniumEnricher enrich) {
        super(Ic2GuiComp.uranEnricherFuelBox);
        this.tile = enrich;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        int amount = (int)(this.tile.getAmount() * 33.0f);
        IUranium type = this.tile.getType();
        if (amount > 0 && type != null) {
            Color color = type.getReEnrichedColor();
            GlStateManager.func_179124_c((float)((byte)color.getRed()), (float)((byte)color.getGreen()), (float)((byte)color.getBlue()));
            gui.func_73729_b(x + 91, y + 16 + 33 - amount, 176, 108 - amount, 4, amount + 1);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY)) {
            IUranium type = this.tile.getType();
            tooltips.add(Ic2GuiLang.uranType.getLocalizedFormatted(type == null ? Ic2GuiLang.noUran : type.getIngridient().func_82833_r()));
            tooltips.add(Ic2GuiLang.uranAmount.getLocalizedFormatted(this.tile.amount, 1000));
        }
    }
}

