/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.energy.tile.IEnergyConductorColored;
import ic2.api.event.PaintEvent;
import ic2.api.event.RetextureEvent;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.BlockWall;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.TileEntityTexturedWall;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockWallTextured
extends BlockMultiID
implements ITileEntityProvider {
    public BlockWallTextured() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(30.0f);
        this.func_149663_c("blockWallTextured");
        this.func_149672_a(Block.field_149769_e);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPaint(PaintEvent event) {
        if (event.world.func_147439_a(event.x, event.y, event.z) != this) {
            return;
        }
        TileEntity tile = event.world.func_147438_o(event.x, event.y, event.z);
        if (tile instanceof TileEntityTexturedWall) {
            TileEntityTexturedWall wall = (TileEntityTexturedWall)tile;
            event.painted = wall.setColor(event.side, IEnergyConductorColored.WireColor.values()[event.color + 1]);
        }
    }

    @SubscribeEvent
    public void onRetexture(RetextureEvent event) {
        TileEntity tile;
        Block block = event.world.func_147439_a(event.x, event.y, event.z);
        if (block != this && !(block instanceof BlockWall)) {
            return;
        }
        if (!this.validContent(event)) {
            return;
        }
        int meta = -1;
        if (block != this) {
            meta = event.world.func_72805_g(event.x, event.y, event.z);
            event.world.func_147449_b(event.x, event.y, event.z, (Block)this);
        }
        if ((tile = event.world.func_147438_o(event.x, event.y, event.z)) instanceof TileEntityTexturedWall) {
            TileEntityTexturedWall wall = (TileEntityTexturedWall)tile;
            if (meta != -1) {
                wall.setColor(IEnergyConductorColored.WireColor.values()[meta + 1]);
            }
            event.applied = wall.setIcon(event.side, event.referencedBlock, event.referencedMeta, event.referencedSide);
        }
    }

    private boolean validContent(RetextureEvent event) {
        return !event.isCanceled() && event.referencedBlock != null && event.referencedBlock != Blocks.field_150350_a;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    public ItemStack func_149644_j(int i) {
        return null;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return Ic2Items.constructionFoam.func_77946_l();
    }

    @Override
    public TileEntityBlock createNewTileEntity(World p_149915_1_, int p_149915_2_) {
        return new TileEntityTexturedWall();
    }

    @Override
    public void init() {
        Ic2Items.texturedWall = new ItemStack((Block)this);
    }

    @Override
    protected IIcon[] getIconSheet(int meta) {
        return null;
    }

    @Override
    protected int getIconMeta(int meta) {
        return 0;
    }

    @Override
    protected int getMaxSheetSize(int meta) {
        return 0;
    }

    @Override
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityTexturedWall) {
            TileEntityTexturedWall wall = (TileEntityTexturedWall)tile;
            return wall.getIcon(side);
        }
        return Ic2Icons.getTexture("bcable")[187];
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return Ic2Icons.getTexture("bcable")[187];
    }

    @Override
    public void func_149666_a(Item j, CreativeTabs tabs, List itemList) {
    }

    @Override
    public int func_149645_b() {
        return IC2.platform.getRenderId("wall");
    }
}

