/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import ic2.core.block.BlockMultiID;
import ic2.core.block.RenderBlockCable;
import ic2.core.block.TileEntityTexturedWall;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class RenderTexturedWall
implements ISimpleBlockRenderingHandler {
    public static int renderId = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityTexturedWall)) {
            renderer.func_147784_q(block, x, y, z);
            return true;
        }
        TileEntityTexturedWall wall = (TileEntityTexturedWall)tile;
        BlockMultiID id = (BlockMultiID)block;
        RenderBlockCable.RenderInfo endInfo = new RenderBlockCable.RenderInfo((Block)id, 0, id.func_149720_d(world, x, y, z));
        ArrayList<RenderBlockCable.RenderInfo> infos = new ArrayList<RenderBlockCable.RenderInfo>();
        for (int i = 0; i < 6; ++i) {
            Block mimBlock = wall.storedBlocks[i];
            if (mimBlock == null || mimBlock == Blocks.field_150350_a) {
                endInfo.addSide(i);
                continue;
            }
            int meta = wall.storedMetas[i];
            try {
                int color = mimBlock.func_149720_d(world, x, y, z);
                this.addToList(mimBlock, meta, color, i, infos);
                continue;
            }
            catch (Exception e) {
                endInfo.addSide(i);
            }
        }
        for (RenderBlockCable.RenderInfo info : infos) {
            if (!info.hasSides()) continue;
            id.applySpecialRender(info);
            renderer.func_147784_q(block, x, y, z);
        }
        if (!endInfo.hasSides()) {
            id.resetSpecialRender();
            return true;
        }
        id.applySpecialRender(endInfo);
        renderer.func_147784_q(block, x, y, z);
        id.resetSpecialRender();
        return true;
    }

    private void addToList(Block par1, int par2, int par3, int side, List<RenderBlockCable.RenderInfo> par4) {
        boolean found = false;
        for (RenderBlockCable.RenderInfo info : par4) {
            if (!info.matches(par1, par2, par3)) continue;
            info.addSide(side);
            found = true;
            break;
        }
        if (found) {
            return;
        }
        par4.add(new RenderBlockCable.RenderInfo(par1, par2, par3, side));
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return renderId;
    }
}

