/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.crop.IC2Crops;
import ic2.core.item.ItemCropSeed;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCrop
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
ICropTile {
    public int growthPoints = 0;
    public boolean upgraded = false;
    public char ticker;
    public boolean dirty = true;
    public static char tickRate = (char)256;
    private boolean created = false;
    public byte humidity = (byte)-1;
    public byte nutrients = (byte)-1;
    public byte airQuality = (byte)-1;
    public boolean speedup = false;
    public int speedLeft = 0;
    private int id = -1;
    private byte size = 0;
    private byte statGrowth = 0;
    private byte statGain = 0;
    private byte statResistance = 0;
    private NBTTagCompound customData = new NBTTagCompound();
    private int nutrientStorage = 0;
    private int waterStorage = 0;
    private byte scanLevel = 0;
    private int exStorage = 0;
    public static HashMap<Block, List<Block>> blockStorage = new HashMap();

    public TileEntityCrop() {
        this.ticker = (char)IC2.random.nextInt(tickRate);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.id = nbttagcompound.func_74762_e("cropid");
        this.size = nbttagcompound.func_74771_c("size");
        this.statGrowth = nbttagcompound.func_74771_c("statGrowth");
        this.statGain = nbttagcompound.func_74771_c("statGain");
        this.statResistance = nbttagcompound.func_74771_c("statResistance");
        if (nbttagcompound.func_74764_b("customData")) {
            this.customData = nbttagcompound.func_74775_l("customData");
        }
        this.growthPoints = nbttagcompound.func_74762_e("growthPoints");
        this.nutrientStorage = nbttagcompound.func_74762_e("nutrientStorage");
        this.waterStorage = nbttagcompound.func_74762_e("waterStorage");
        this.upgraded = nbttagcompound.func_74767_n("upgraded");
        this.scanLevel = nbttagcompound.func_74771_c("scanLevel");
        this.speedup = nbttagcompound.func_74767_n("speedUps");
        this.speedLeft = nbttagcompound.func_74762_e("SpeedTicks");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("cropid", this.id);
        nbttagcompound.func_74774_a("size", this.size);
        nbttagcompound.func_74774_a("statGrowth", this.statGrowth);
        nbttagcompound.func_74774_a("statGain", this.statGain);
        nbttagcompound.func_74774_a("statResistance", this.statResistance);
        nbttagcompound.func_74782_a("customData", (NBTBase)this.customData);
        nbttagcompound.func_74768_a("growthPoints", this.growthPoints);
        nbttagcompound.func_74768_a("nutrientStorage", this.nutrientStorage);
        nbttagcompound.func_74768_a("waterStorage", this.waterStorage);
        nbttagcompound.func_74757_a("upgraded", this.upgraded);
        nbttagcompound.func_74774_a("scanLevel", this.scanLevel);
        nbttagcompound.func_74757_a("speedUps", this.speedup);
        nbttagcompound.func_74768_a("SpeedTicks", this.speedLeft);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.created && !IC2.platform.isSimulating()) {
            IC2.network.get().requestInitialData(this);
            this.created = true;
        }
        if (!this.speedup || this.speedup && this.speedLeft > 0) {
            this.ticker = (char)(this.ticker + '\u0001');
            if (this.ticker % tickRate == 0 || this.speedLeft > 0) {
                if (this.speedLeft > 0) {
                    --this.speedLeft;
                }
                this.tick();
            }
        }
        if (this.dirty) {
            this.dirty = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (IC2.platform.isSimulating()) {
                IC2.network.get().announceBlockUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (!IC2.platform.isRendering()) {
                    for (String field : this.getNetworkedFields()) {
                        IC2.network.get().updateTileEntityField(this, field);
                    }
                }
            }
        }
    }

    @Override
    public List<String> getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("id");
        ret.add("size");
        ret.add("upgraded");
        ret.add("customData");
        return ret;
    }

    public void tick() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (this.ticker % (tickRate << 2) == 0) {
            this.humidity = this.updateHumidity();
        }
        if ((this.ticker + tickRate) % (tickRate << 2) == 0) {
            this.nutrients = this.updateNutrients();
        }
        if ((this.ticker + tickRate * 2) % (tickRate << 2) == 0) {
            this.airQuality = this.updateAirQuality();
        }
        if (!(this.id >= 0 || this.upgraded && this.attemptCrossing())) {
            if (IC2.random.nextInt(100) != 0 || this.hasEx()) {
                if (this.exStorage > 0 && IC2.random.nextInt(10) == 0) {
                    --this.exStorage;
                }
                return;
            }
            this.reset();
            this.id = (short)IC2Crops.weed.getId();
            this.size = 1;
        }
        this.crop().tick(this);
        if (this.id == -1) {
            return;
        }
        if (this.crop().canGrow(this)) {
            this.growthPoints += this.calcGrowthRate();
            if (this.id > -1 && this.growthPoints >= this.crop().growthDuration(this)) {
                this.growthPoints = 0;
                this.size = (byte)(this.size + 1);
                this.dirty = true;
            } else if (this.id == -1) {
                return;
            }
        }
        if (this.nutrientStorage > 0) {
            --this.nutrientStorage;
        }
        if (this.waterStorage > 0) {
            --this.waterStorage;
        }
        if (this.crop().isWeed(this) && IC2.random.nextInt(50) - this.statGrowth <= 2) {
            this.generateWeed();
        }
    }

    public void generateWeed() {
        Block block;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        switch (IC2.random.nextInt(8)) {
            case 0: {
                ++x;
                break;
            }
            case 1: {
                --x;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                ++z;
                break;
            }
            case 5: {
                --x;
                --z;
                break;
            }
            case 6: {
                ++x;
                --z;
                break;
            }
            case 7: {
                --x;
                ++z;
            }
        }
        if (this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)this.field_145850_b.func_147438_o(x, y, z);
            if (crop.id == -1 || !crop.crop().isWeed(crop) && IC2.random.nextInt(32) >= crop.statResistance && !crop.hasEx()) {
                byte newGrowth = this.statGrowth;
                if (crop.statGrowth > newGrowth) {
                    newGrowth = crop.statGrowth;
                }
                if (newGrowth < 31 && IC2.random.nextBoolean()) {
                    newGrowth = (byte)(newGrowth + 1);
                }
                crop.reset();
                crop.id = 0;
                crop.setSize((byte)1);
                crop.statGrowth = newGrowth;
                if (this.upgraded) {
                    crop.speedup = true;
                    crop.speedLeft = 1000;
                }
            }
        } else if (this.field_145850_b.func_147437_c(x, y, z) && ((block = this.field_145850_b.func_147439_a(x, y - 1, z)) == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak)) {
            this.field_145850_b.func_147449_b(x, y - 1, z, (Block)Blocks.field_150349_c);
            this.field_145850_b.func_147465_d(x, y, z, (Block)Blocks.field_150329_H, 1, 3);
        }
    }

    public boolean hasEx() {
        if (this.exStorage > 0) {
            this.exStorage -= 5;
            return true;
        }
        return false;
    }

    public boolean attemptCrossing() {
        int k;
        if (IC2.random.nextInt(3) != 0) {
            return false;
        }
        LinkedList crops = new LinkedList();
        int want = 0;
        want += this.askCropJoinCross(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, crops);
        want += this.askCropJoinCross(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, crops);
        want += this.askCropJoinCross(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, crops);
        want += this.askCropJoinCross(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, crops);
        if (crops.size() < 2) {
            if (crops.size() > 0 && crops.size() == want) {
                this.copyCrop((TileEntityCrop)crops.get(0));
                return true;
            }
            return false;
        }
        int[] ratios = new int[((IC2Crops)Crops.instance).getRegisteredCropSize()];
        for (int i = 1; i < ratios.length; ++i) {
            CropCard crop = Crops.instance.getCropList()[i];
            if (crop == null || !crop.canGrow(this)) continue;
            for (int j = 0; j < crops.size(); ++j) {
                int n;
                int[] array = ratios;
                int n2 = n = i;
                array[n2] = array[n2] + this.calculateRatioFor(crop, ((TileEntityCrop)crops.get(j)).crop());
            }
        }
        int total = 0;
        for (k = 0; k < ratios.length; ++k) {
            total += ratios[k];
        }
        total = IC2.random.nextInt(total);
        for (k = 0; k < ratios.length; ++k) {
            if (ratios[k] > 0 && ratios[k] > total) {
                total = k;
                break;
            }
            total -= ratios[k];
        }
        this.upgraded = false;
        this.id = (short)total;
        this.dirty = true;
        this.size = 1;
        this.statGrowth = 0;
        this.statResistance = 0;
        this.statGain = 0;
        for (k = 0; k < crops.size(); ++k) {
            this.statGrowth = (byte)(this.statGrowth + ((TileEntityCrop)crops.get((int)k)).statGrowth);
            this.statResistance = (byte)(this.statResistance + ((TileEntityCrop)crops.get((int)k)).statResistance);
            this.statGain = (byte)(this.statGain + ((TileEntityCrop)crops.get((int)k)).statGain);
        }
        int count = crops.size();
        this.statGrowth = (byte)(this.statGrowth / (byte)count);
        this.statResistance = (byte)(this.statResistance / (byte)count);
        this.statGain = (byte)(this.statGain / (byte)count);
        this.statGrowth = (byte)(this.statGrowth + (byte)(IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statGrowth < 0) {
            this.statGrowth = 0;
        }
        if (this.statGrowth > 31) {
            this.statGrowth = (byte)31;
        }
        this.statGain = (byte)(this.statGain + (byte)(IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statGain < 0) {
            this.statGain = 0;
        }
        if (this.statGain > 31) {
            this.statGain = (byte)31;
        }
        this.statResistance = (byte)(this.statResistance + (byte)(IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statResistance < 0) {
            this.statResistance = 0;
        }
        if (this.statResistance > 31) {
            this.statResistance = (byte)31;
        }
        return true;
    }

    private void copyCrop(TileEntityCrop crop) {
        this.upgraded = false;
        this.id = crop.id;
        this.dirty = true;
        this.size = 1;
        this.statGrowth = (byte)MathHelper.func_76125_a((int)crop.statGrowth, (int)0, (int)31);
        this.statResistance = (byte)MathHelper.func_76125_a((int)crop.statResistance, (int)0, (int)31);
        this.statGain = (byte)MathHelper.func_76125_a((int)crop.statGain, (int)0, (int)31);
        this.scanLevel = crop.scanLevel;
    }

    public int calculateRatioFor(CropCard a, CropCard b) {
        int i;
        if (a == b) {
            return 500;
        }
        int value = 0;
        for (i = 0; i < 5; ++i) {
            int c = a.stat(i) - b.stat(i);
            if (c < 0) {
                c *= -1;
            }
            switch (c) {
                default: {
                    --value;
                }
                case 0: {
                    value += 2;
                }
                case 1: {
                    ++value;
                }
                case 2: 
            }
        }
        for (i = 0; i < a.attributes().length; ++i) {
            for (int j = 0; j < b.attributes().length; ++j) {
                if (!a.attributes()[i].equalsIgnoreCase(b.attributes()[j])) continue;
                value += 5;
            }
        }
        if (b.tier() < a.tier() - 1) {
            value -= 2 * (a.tier() - b.tier());
        }
        if (b.tier() - 3 > a.tier()) {
            value -= b.tier() - a.tier();
        }
        if (value < 0) {
            value = 0;
        }
        return value;
    }

    public int askCropJoinCross(int x, int y, int z, LinkedList crops) {
        if (!(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityCrop)) {
            return 0;
        }
        TileEntityCrop sidecrop = (TileEntityCrop)this.field_145850_b.func_147438_o(x, y, z);
        if (sidecrop.id <= 0) {
            return 0;
        }
        if (!sidecrop.crop().canGrow(this) || !sidecrop.crop().canCross(sidecrop)) {
            return 0;
        }
        int base = 4;
        if (sidecrop.statGrowth >= 16) {
            ++base;
        }
        if (sidecrop.statGrowth >= 30) {
            ++base;
        }
        if (sidecrop.statResistance >= 28) {
            base += 27 - sidecrop.statResistance;
        }
        if (base >= IC2.random.nextInt(20)) {
            crops.add(sidecrop);
        }
        return 1;
    }

    public boolean leftclick(EntityPlayer player) {
        if (this.id >= 0) {
            return this.crop().leftclick(this, player);
        }
        if (this.upgraded) {
            this.upgraded = false;
            this.dirty = true;
            if (IC2.platform.isSimulating()) {
                StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, new ItemStack(Ic2Items.crop.func_77973_b()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pick(boolean manual) {
        int j;
        if (this.id < 0) {
            return false;
        }
        boolean bonus = this.harvest(false);
        float firstchance = this.crop().dropSeedChance(this);
        for (int i = 0; i < this.statResistance; ++i) {
            firstchance *= 1.1f;
        }
        int drop = 0;
        if (bonus) {
            if (IC2.random.nextFloat() <= (firstchance + 1.0f) * 0.8f) {
                ++drop;
            }
            float chance = this.crop().dropSeedChance(this) + (float)this.statGrowth / 100.0f;
            if (!manual) {
                chance *= 0.8f;
            }
            for (j = 23; j < this.statGain; ++j) {
                chance *= 0.95f;
            }
            if (IC2.random.nextFloat() <= chance) {
                ++drop;
            }
        } else if (IC2.random.nextFloat() <= firstchance * 1.5f) {
            ++drop;
        }
        ItemStack[] re = new ItemStack[drop];
        for (j = 0; j < drop; ++j) {
            re[j] = this.crop().getSeeds(this);
        }
        this.reset();
        if (IC2.platform.isSimulating() && re != null && re.length > 0) {
            for (int x = 0; x < re.length; ++x) {
                if (re[x].func_77973_b() != Ic2Items.cropSeed.func_77973_b()) {
                    re[x].field_77990_d = null;
                }
                StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, re[x]);
            }
        }
        return true;
    }

    public boolean rightclick(EntityPlayer player) {
        ItemStack current = player.func_71045_bC();
        if (current != null) {
            if (this.id < 0) {
                if (current.func_77973_b() == Ic2Items.crop.func_77973_b() && !this.upgraded) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStack itemStack = current;
                        --itemStack.field_77994_a;
                        if (current.field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        }
                    }
                    this.upgraded = true;
                    this.dirty = true;
                    return true;
                }
                if (this.applyBaseSeed(current, player)) {
                    return true;
                }
            } else if (current.func_77973_b() == Ic2Items.cropnalyzer.func_77973_b()) {
                if (IC2.platform.isSimulating()) {
                    if (player.func_70093_af()) {
                        if (this.scanLevel >= 4 || this.id == -1) {
                            IC2.platform.messagePlayer(player, "Crop is already Fully Analyzed");
                        } else if (this.scanLevel < 4) {
                            this.scanLevel = (byte)(this.scanLevel + 1);
                            IC2.platform.messagePlayer(player, "Scanning Level increased to " + this.scanLevel);
                        }
                    } else if (this.id == -1 || this.size <= 0 || this.scanLevel < 1 && this.size < this.crop().maxSize()) {
                        IC2.platform.messagePlayer(player, EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"container.cropAnalyzer.CropUnknowen.name"));
                        IC2.platform.messagePlayer(player, EnumChatFormatting.GREEN + "Nutrient Storage: " + this.nutrientStorage + " / " + 100);
                        IC2.platform.messagePlayer(player, EnumChatFormatting.BLUE + "Water Storage: " + this.waterStorage + " / " + 200);
                        IC2.platform.messagePlayer(player, EnumChatFormatting.RED + "WeedEx Storage: " + this.exStorage + " / " + 150);
                        IC2.platform.messagePlayer(player, EnumChatFormatting.DARK_GREEN + "Crop Nutriens: " + this.getNutrients());
                        IC2.platform.messagePlayer(player, EnumChatFormatting.AQUA + "Crop Humidity: " + this.getHumidity());
                        IC2.platform.messagePlayer(player, EnumChatFormatting.YELLOW + "Air Quality: " + this.getAirQuality());
                    } else {
                        IC2.platform.messagePlayer(player, EnumChatFormatting.WHITE + "Crop: " + this.crop().displayName() + ", By: " + this.crop().discoveredBy());
                        IC2.platform.messagePlayer(player, EnumChatFormatting.GREEN + "Size: " + this.size + " / " + this.crop().maxSize());
                        IC2.platform.messagePlayer(player, EnumChatFormatting.GREEN + "Nutrient Storage: " + this.nutrientStorage + " / " + 100);
                        IC2.platform.messagePlayer(player, EnumChatFormatting.BLUE + "Water Storage: " + this.waterStorage + " / " + 200);
                        IC2.platform.messagePlayer(player, EnumChatFormatting.RED + "WeedEx Storage: " + this.exStorage + " / " + 150);
                        IC2.platform.messagePlayer(player, EnumChatFormatting.DARK_GREEN + "Crop Nutriens: " + this.getNutrients());
                        IC2.platform.messagePlayer(player, EnumChatFormatting.AQUA + "Crop Humidity: " + this.getHumidity());
                        IC2.platform.messagePlayer(player, EnumChatFormatting.YELLOW + "Air Quality: " + this.getAirQuality());
                        IC2.platform.messagePlayer(player, EnumChatFormatting.GREEN + "Growth: " + this.statGrowth);
                        IC2.platform.messagePlayer(player, EnumChatFormatting.YELLOW + "Gain: " + this.statGain);
                        IC2.platform.messagePlayer(player, EnumChatFormatting.BLUE + "Resistance: " + this.statResistance);
                    }
                }
                return true;
            }
            if (current.func_77973_b() == Items.field_151131_as) {
                if (this.waterStorage < 10) {
                    this.waterStorage = 10;
                    --current.field_77994_a;
                    if (current.field_77994_a <= 0) {
                        player.func_70062_b(0, new ItemStack(Items.field_151133_ar));
                    } else {
                        player.field_71071_by.func_70441_a(new ItemStack(Items.field_151133_ar));
                    }
                }
                return true;
            }
            if (current.func_77973_b() == Ic2Items.waterCell.func_77973_b()) {
                if (this.waterStorage < 10) {
                    this.waterStorage = 10;
                    --current.field_77994_a;
                    if (current.field_77994_a <= 0) {
                        player.func_70062_b(0, Ic2Items.cell.func_77946_l());
                    } else {
                        player.field_71071_by.func_70441_a(Ic2Items.cell.func_77946_l());
                    }
                }
                return true;
            }
            if (current.func_77973_b() == Items.field_151014_N) {
                if (this.nutrientStorage <= 50) {
                    this.nutrientStorage += 25;
                    ItemStack itemStack2 = current;
                    --itemStack2.field_77994_a;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Items.field_151100_aR && current.func_77960_j() == 15 || current.func_77973_b() == Ic2Items.fertilizer.func_77973_b()) {
                if (this.applyFertilizer(true)) {
                    ItemStack itemStack3 = current;
                    --itemStack3.field_77994_a;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Ic2Items.hydratingCell.func_77973_b()) {
                if (this.applyHydration(true, current)) {
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.func_77973_b() == Ic2Items.weedEx.func_77973_b() && this.applyWeedEx(true)) {
                current.func_77972_a(1, (EntityLivingBase)player);
                if (current.func_77960_j() >= current.func_77958_k()) {
                    ItemStack itemStack4 = current;
                    --itemStack4.field_77994_a;
                }
                if (current.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
                return true;
            }
            if (current.func_77969_a(Ic2Items.specialFertilzer)) {
                if (this.speedup) {
                    return false;
                }
                --current.field_77994_a;
                if (current.field_77994_a <= 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
                this.speedup = true;
                this.speedLeft = 6000;
                return true;
            }
        }
        return this.id >= 0 && this.crop().rightclick(this, player);
    }

    public boolean applyBaseSeed(ItemStack current, EntityPlayer player) {
        BaseSeed seed = Crops.instance.getBaseSeed(current);
        if (seed != null) {
            if (current.field_77994_a < seed.stackSize) {
                return false;
            }
            if (this.tryPlantIn(seed.id, seed.size, seed.statGrowth, seed.statGain, seed.statResistance, 1)) {
                if (current.func_77973_b().hasContainerItem(current)) {
                    current = current.func_77973_b().getContainerItem(current);
                } else {
                    ItemStack itemStack = current;
                    itemStack.field_77994_a -= seed.stackSize;
                    if (current.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean tryPlantIn(int i, int si, int statGr, int statGa, int statRe, int scan) {
        if (this.id > -1 || i <= 0 || this.upgraded) {
            return false;
        }
        CropCard crop = Crops.instance.getCropList()[i];
        if (crop == null || !crop.canGrow(this)) {
            return false;
        }
        this.reset();
        this.id = (short)i;
        this.size = (byte)si;
        this.statGrowth = (byte)statGr;
        this.statGain = (byte)statGa;
        this.statResistance = (byte)statRe;
        this.scanLevel = (byte)scan;
        return true;
    }

    public boolean applyFertilizer(boolean manual) {
        if (this.nutrientStorage >= 100) {
            return false;
        }
        this.nutrientStorage += manual ? 100 : 90;
        return true;
    }

    public boolean applyHydration(boolean manual, ItemStack current) {
        int apply;
        if (!manual && this.waterStorage >= 180 || this.waterStorage >= 200) {
            return false;
        }
        int n = apply = manual ? 200 - this.waterStorage : 180 - this.waterStorage;
        if (apply + current.func_77960_j() > current.func_77958_k()) {
            apply = current.func_77958_k() - current.func_77960_j();
        }
        current.func_77964_b(current.func_77960_j() + apply);
        if (current.func_77960_j() >= current.func_77958_k()) {
            --current.field_77994_a;
        }
        this.waterStorage += apply;
        return true;
    }

    public boolean applyWeedEx(boolean manual) {
        boolean trigger;
        if (this.exStorage >= 100 && manual || this.exStorage >= 150) {
            return false;
        }
        this.exStorage += 50;
        boolean bl = trigger = this.field_145850_b.field_73012_v.nextInt(3) == 0;
        if (manual) {
            boolean bl2 = trigger = this.field_145850_b.field_73012_v.nextInt(5) == 0;
        }
        if (this.id > 0 && this.exStorage >= 75 && trigger) {
            switch (this.field_145850_b.field_73012_v.nextInt(5)) {
                case 0: {
                    if (this.statGrowth > 0) {
                        this.statGrowth = (byte)(this.statGrowth - 1);
                    }
                }
                case 1: {
                    if (this.statGain <= 0) break;
                    this.statGain = (byte)(this.statGain - 1);
                }
            }
            if (this.statResistance > 0) {
                this.statResistance = (byte)(this.statResistance - 1);
            }
        }
        return true;
    }

    @Override
    public boolean harvest(boolean manual) {
        if (this.id < 0 || !this.crop().canBeHarvested(this)) {
            return false;
        }
        float chance = this.crop().dropGainChance();
        for (int i = 0; i < this.statGain; ++i) {
            chance *= 1.03f;
        }
        chance -= IC2.random.nextFloat();
        int drop = 0;
        while (chance > 0.0f) {
            ++drop;
            chance -= IC2.random.nextFloat();
        }
        ItemStack[] re = new ItemStack[drop];
        for (int j = 0; j < drop; ++j) {
            re[j] = this.crop().getGain(this);
            if (re[j] == null || IC2.random.nextInt(100) > this.statGain) continue;
            ItemStack itemStack = re[j];
            ++itemStack.field_77994_a;
        }
        this.size = this.crop().getSizeAfterHarvest(this);
        this.dirty = true;
        if (IC2.platform.isSimulating() && re != null && re.length > 0) {
            for (int x = 0; x < re.length; ++x) {
                StackUtil.dropAsEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, re[x]);
            }
        }
        return true;
    }

    public void onNeighbourChange() {
        if (this.id < 0) {
            return;
        }
        this.crop().onNeighbourChange(this);
    }

    public boolean emitRedstone() {
        return this.id >= 0 && this.crop().emitRedstone(this) > 0;
    }

    public void onBlockDestroyed() {
        if (this.id < 0) {
            return;
        }
        this.crop().onBlockDestroyed(this);
    }

    public int getEmittedLight() {
        if (this.id < 0) {
            return 0;
        }
        return this.crop().getEmittedLight(this);
    }

    @Override
    public byte getHumidity() {
        if (this.humidity == -1) {
            this.humidity = this.updateHumidity();
        }
        return this.humidity;
    }

    @Override
    public byte getNutrients() {
        if (this.nutrients == -1) {
            this.nutrients = this.updateNutrients();
        }
        return this.nutrients;
    }

    @Override
    public byte getAirQuality() {
        if (this.airQuality == -1) {
            this.airQuality = this.updateAirQuality();
        }
        return this.airQuality;
    }

    public byte updateHumidity() {
        int value = Crops.instance.getHumidityBiomeBonus(this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e));
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) >= 7) {
            value += 2;
        }
        if (this.waterStorage >= 5) {
            value += 2;
        }
        return (byte)(value += (this.waterStorage + 24) / 25);
    }

    public byte updateNutrients() {
        int value = Crops.instance.getNutrientBiomeBonus(this.field_145850_b.func_72959_q().func_76935_a(this.field_145851_c, this.field_145849_e));
        for (int i = 2; i < 5 && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e) == Blocks.field_150346_d; ++i) {
            ++value;
        }
        return (byte)(value += (this.nutrientStorage + 19) / 20);
    }

    public byte updateAirQuality() {
        int value = 0;
        int height = (this.field_145848_d - 64) / 15;
        if (height > 4) {
            height = 4;
        }
        if (height < 0) {
            height = 0;
        }
        value += height;
        int fresh = 9;
        for (int x = this.field_145851_c - 1; x < this.field_145851_c + 1 && fresh > 0; ++x) {
            for (int z = this.field_145849_e - 1; z < this.field_145849_e + 1 && fresh > 0; ++z) {
                if (!this.field_145850_b.func_147445_c(x, this.field_145848_d, z, false) && !(this.field_145850_b.func_147438_o(x, this.field_145848_d, z) instanceof TileEntityCrop)) continue;
                --fresh;
            }
        }
        value += fresh / 2;
        if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            value += 2;
        }
        return (byte)value;
    }

    public byte updateMultiCulture() {
        LinkedList crops = new LinkedList();
        for (int x = -1; x < 1; ++x) {
            for (int z = -1; z < 1; ++z) {
                if (!(this.field_145850_b.func_147438_o(x + this.field_145851_c, this.field_145848_d, z + this.field_145849_e) instanceof TileEntityCrop)) continue;
                this.addIfNotPresent(((TileEntityCrop)this.field_145850_b.func_147438_o(x + this.field_145851_c, this.field_145848_d, z + this.field_145849_e)).crop(), crops);
            }
        }
        return (byte)(crops.size() - 1);
    }

    public void addIfNotPresent(CropCard crop, LinkedList crops) {
        for (int i = 0; i < crops.size(); ++i) {
            if (crop != crops.get(i)) continue;
            return;
        }
        crops.add(crop);
    }

    public int calcGrowthRate() {
        int have;
        int base = 3 + IC2.random.nextInt(7) + this.statGrowth;
        int need = (this.crop().tier() - 1) * 4 + this.statGrowth + this.statGain + this.statResistance;
        if (need < 0) {
            need = 0;
        }
        if ((have = this.crop().weightInfluences(this, this.getHumidity(), this.getNutrients(), this.getAirQuality()) * 5) >= need) {
            base = base * (100 + (have - need)) / 100;
        } else {
            int neg = (need - have) * 4;
            if (neg > 100 && IC2.random.nextInt(32) > this.statResistance) {
                this.reset();
                base = 0;
            } else if ((base = base * (100 - neg) / 100) < 0) {
                base = 0;
            }
        }
        return base;
    }

    public void calcTrampling() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (IC2.random.nextInt(100) == 0 && IC2.random.nextInt(40) > this.statResistance) {
            this.reset();
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Blocks.field_150346_d);
        }
    }

    public CropCard crop() {
        return Crops.instance.getCropList()[this.id];
    }

    public IIcon getSprite() {
        if (this.id >= 0) {
            return this.crop().getSprite(this);
        }
        if (!this.upgraded) {
            return Ic2Icons.getTexture("bc")[0];
        }
        return Ic2Icons.getTexture("bc")[1];
    }

    public void onEntityCollision(Entity entity) {
        if (this.id < 0) {
            return;
        }
        if (this.crop().onEntityCollision(this, entity)) {
            this.calcTrampling();
        }
    }

    @Override
    public void reset() {
        this.id = -1;
        this.size = 0;
        this.customData = new NBTTagCompound();
        this.dirty = true;
        this.statGain = 0;
        this.statResistance = 0;
        this.statGrowth = 0;
        this.nutrients = (byte)-1;
        this.airQuality = (byte)-1;
        this.humidity = (byte)-1;
        this.growthPoints = 0;
        this.upgraded = false;
        this.scanLevel = 0;
    }

    @Override
    public void updateState() {
        this.dirty = true;
    }

    public String getScanned() {
        if (this.scanLevel <= 0 || this.id < 0) {
            return StatCollector.func_74838_a((String)"container.cropAnalyzer.CropUnknowen.name");
        }
        if (this.scanLevel >= 4) {
            return StatCollector.func_74837_a((String)"container.cropAnalyzer.Crop.name", (Object[])new Object[]{this.crop().displayName(), this.statGrowth, this.statGain, this.statResistance});
        }
        return this.crop().displayName();
    }

    @Override
    public boolean isBlockBelow(Block block) {
        List<Block> list = this.getOreDict(block);
        for (int i = 1; i < 4; ++i) {
            Block id = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e);
            if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - i, this.field_145849_e)) {
                return false;
            }
            if (!list.contains(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlockBelow(String oreDictionaryName) {
        List stack = OreDictionary.getOres((String)oreDictionaryName, (boolean)false);
        for (int i = 1; i < 4; ++i) {
            Block id = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - i, this.field_145849_e);
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - i, this.field_145849_e)) {
                return false;
            }
            ItemStack item = new ItemStack(id, 1, meta);
            if (!stack.contains(item)) continue;
            return true;
        }
        return false;
    }

    public List<Block> getOreDict(Block par1) {
        if (blockStorage.containsKey(par1)) {
            return blockStorage.get(par1);
        }
        ItemStack item = new ItemStack(par1);
        ArrayList<Block> results = new ArrayList<Block>();
        int[] ints = OreDictionary.getOreIDs((ItemStack)item);
        if (ints != null && ints.length > 0) {
            Block block;
            boolean anyMatch = false;
            block0: for (int id : ints) {
                if (anyMatch) break;
                for (ItemStack cu : OreDictionary.getOres((Integer)id)) {
                    if (cu == null || cu.func_77973_b() == null || (block = Block.func_149634_a((Item)cu.func_77973_b())) != par1) continue;
                    anyMatch = true;
                    continue block0;
                }
            }
            if (anyMatch) {
                for (int id : ints) {
                    for (ItemStack cu : OreDictionary.getOres((Integer)id)) {
                        if (cu == null || cu.func_77973_b() == null || (block = Block.func_149634_a((Item)cu.func_77973_b())) == Blocks.field_150350_a) continue;
                        results.add(block);
                    }
                }
            } else {
                results.add(par1);
            }
        } else {
            results.add(par1);
        }
        if (!blockStorage.containsKey(par1)) {
            blockStorage.put(par1, results);
        }
        return results;
    }

    @Override
    public ItemStack generateSeeds(short plant, byte growth, byte gain, byte resis, byte scan) {
        return ItemCropSeed.generateItemStackFromValues(plant, growth, gain, resis, scan);
    }

    @Override
    public CropCard getCrop() {
        return IC2Crops.getCropFromId(this.id);
    }

    @Override
    public void setCrop(CropCard cropCard) {
        this.id = cropCard.getId();
    }

    @Override
    public ItemStack[] harvest_automated(boolean Optimal) {
        if (this.id < 0 || !this.crop().canBeHarvested(this)) {
            return null;
        }
        float chance = this.crop().dropGainChance();
        for (int i = 0; i < this.statGain; ++i) {
            chance *= 1.03f;
        }
        chance -= IC2.random.nextFloat();
        int drop = 0;
        while (chance > 0.0f) {
            ++drop;
            chance -= IC2.random.nextFloat();
        }
        ItemStack[] re = new ItemStack[drop];
        for (int j = 0; j < drop; ++j) {
            re[j] = this.crop().getGain(this);
            if (re[j] == null || IC2.random.nextInt(100) > this.statGain) continue;
            ItemStack itemStack = re[j];
            ++itemStack.field_77994_a;
        }
        this.size = this.crop().getSizeAfterHarvest(this);
        this.dirty = true;
        return re;
    }

    @Override
    public ItemStack generateSeeds(CropCard crop, byte growth, byte gain, byte resis, byte scan) {
        return this.generateSeeds((short)crop.getId(), growth, gain, resis, scan);
    }

    @Override
    public void onNetworkUpdate(String field) {
        this.dirty = true;
    }

    @Override
    public short getID() {
        return (short)this.id;
    }

    @Override
    public void setID(short id) {
        this.id = id;
    }

    @Override
    public byte getSize() {
        return this.size;
    }

    @Override
    public void setSize(byte size) {
        this.size = size;
    }

    @Override
    public byte getGrowth() {
        return this.statGrowth;
    }

    @Override
    public void setGrowth(byte growth) {
        this.statGrowth = growth;
    }

    @Override
    public byte getGain() {
        return this.statGain;
    }

    @Override
    public void setGain(byte gain) {
        this.statGain = gain;
    }

    @Override
    public byte getResistance() {
        return this.statResistance;
    }

    @Override
    public void setResistance(byte resistance) {
        this.statResistance = resistance;
    }

    @Override
    public byte getScanLevel() {
        return this.scanLevel;
    }

    @Override
    public void setScanLevel(byte scanLevel) {
        this.scanLevel = scanLevel;
    }

    @Override
    public NBTTagCompound getCustomData() {
        return this.customData;
    }

    @Override
    public int getNutrientStorage() {
        return this.nutrientStorage;
    }

    @Override
    public void setNutrientStorage(int nutrientStorage) {
        this.nutrientStorage = nutrientStorage;
    }

    @Override
    public int getHydrationStorage() {
        return this.waterStorage;
    }

    @Override
    public void setHydrationStorage(int hydrationStorage) {
        this.waterStorage = hydrationStorage;
    }

    @Override
    public int getWeedExStorage() {
        return this.exStorage;
    }

    @Override
    public void setWeedExStorage(int weedExStorage) {
        this.exStorage = weedExStorage;
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public ChunkCoordinates getLocation() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int getLightLevel() {
        return this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

