/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.energy.tile.IEnergyConductorColored;
import ic2.core.Ic2Icons;
import ic2.core.block.TileEntityBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;

public class TileEntityTexturedWall
extends TileEntityBlock {
    public Block[] storedBlocks = new Block[6];
    public int[] storedMetas = new int[6];
    public int[] storedSides = new int[6];
    public int[] color = new int[6];

    public TileEntityTexturedWall() {
        this.addNetworkFields("storedBlocks", "storedMetas", "storedSides", "color");
    }

    public Block getBlock(int side) {
        return this.storedBlocks[side];
    }

    public IIcon getIcon(int side) {
        Block block = this.storedBlocks[side];
        if (block == null || block == Blocks.field_150350_a) {
            return Ic2Icons.getTexture("bcable")[187 + this.color[side]];
        }
        return block.func_149691_a(this.storedSides[side], this.storedMetas[side]);
    }

    public boolean setIcon(int state, Block block, int meta, int side) {
        if (this.storedBlocks[state] == block && this.storedMetas[state] == meta && this.storedSides[state] == side) {
            return false;
        }
        if (!Block.func_149680_a((Block)this.storedBlocks[state], (Block)block)) {
            this.storedBlocks[state] = block;
            this.getNetwork().updateTileEntityField(this, "storedBlocks");
        }
        if (this.storedMetas[state] != meta) {
            this.storedMetas[state] = meta;
            this.getNetwork().updateTileEntityField(this, "storedMetas");
        }
        if (this.storedSides[state] != side) {
            this.storedSides[state] = side;
            this.getNetwork().updateTileEntityField(this, "storedSides");
        }
        if (block != null && this.color[state] != 0) {
            this.color[state] = 0;
            this.getNetwork().updateTileEntityField(this, "color");
        }
        return true;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("color") || field.equals("storedBlocks") || field.equals("storedMetas") || field.equals("storedSides")) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        super.onNetworkUpdate(field);
    }

    public void setColor(IEnergyConductorColored.WireColor wireColor) {
        for (int i = 0; i < 6; ++i) {
            if (this.color[i] == wireColor.ordinal()) continue;
            this.color[i] = wireColor.ordinal();
            this.getNetwork().updateTileEntityField(this, "color");
        }
    }

    public boolean setColor(int side, IEnergyConductorColored.WireColor wireColor) {
        if (this.color[side] != wireColor.ordinal()) {
            this.color[side] = wireColor.ordinal();
            this.getNetwork().updateTileEntityField(this, "color");
            this.setIcon(side, null, 0, 0);
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.storedBlocks = new Block[6];
        this.storedMetas = new int[6];
        this.storedSides = new int[6];
        this.color = new int[6];
        NBTTagList list = nbttagcompound.func_150295_c("DataList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            int slot = nbt.func_74762_e("Slot");
            this.color[slot] = nbt.func_74762_e("Color");
            String id = nbt.func_74779_i("ID");
            this.storedBlocks[slot] = id.equals("Empty") ? null : Block.func_149684_b((String)id);
            this.storedMetas[slot] = nbt.func_74762_e("Meta");
            this.storedSides[slot] = nbt.func_74762_e("Side");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 6; ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("Slot", i);
            nbt.func_74768_a("Color", this.color[i]);
            Block block = this.storedBlocks[i];
            String id = block == null || block == Blocks.field_150350_a ? "Empty" : Block.field_149771_c.func_148750_c((Object)block);
            nbt.func_74778_a("ID", id);
            nbt.func_74768_a("Meta", this.storedMetas[i]);
            nbt.func_74768_a("Side", this.storedSides[i]);
            list.func_74742_a((NBTBase)nbt);
        }
        nbttagcompound.func_74782_a("DataList", (NBTBase)list);
    }
}

