/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.ICropTile;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.crop.CropCardBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class CropHops
extends CropCardBase {
    @Override
    public String name() {
        return "Hops";
    }

    @Override
    public int tier() {
        return 5;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Green", "Ingredient", "Wheat"};
    }

    @Override
    public IIcon getSprite(ICropTile crop) {
        if (crop.getSize() >= 5) {
            return Ic2Icons.getTexture("bc")[crop.getSize() + 39];
        }
        return Ic2Icons.getTexture("bc")[crop.getSize() + 1];
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return 600;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 7 && crop.getLightLevel() >= 9;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 7;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(Ic2Items.hops.func_77973_b(), 1);
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 3;
    }

    @Override
    public int maxSize() {
        return 7;
    }

    @Override
    public int getOptimalHavestSize(ICropTile crop) {
        return this.maxSize();
    }
}

