/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.generator.tileentity.TileEntityGenerator;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactor;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.block.generator.tileentity.TileEntityNuclearReactorSteam;
import ic2.core.block.generator.tileentity.TileEntitySolarGenerator;
import ic2.core.block.generator.tileentity.TileEntitySolarHV;
import ic2.core.block.generator.tileentity.TileEntitySolarLV;
import ic2.core.block.generator.tileentity.TileEntitySolarMV;
import ic2.core.block.generator.tileentity.TileEntityWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityWaterHV;
import ic2.core.block.generator.tileentity.TileEntityWaterLV;
import ic2.core.block.generator.tileentity.TileEntityWaterMV;
import ic2.core.block.generator.tileentity.TileEntityWindGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGenerator
extends BlockMultiID {
    public static Class tileEntityNuclearReactorClass = TileEntityNuclearReactorElectric.class;
    public static ItemStack[] optionalDrops = new ItemStack[16];

    public BlockGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(IC2.tabIC2);
    }

    @Override
    protected IIcon[] getIconSheet(int meta) {
        return Ic2Icons.getTexture("bgen");
    }

    @Override
    protected int getIconMeta(int meta) {
        return meta;
    }

    public int func_149692_a(int meta) {
        switch (meta) {
            case 2: {
                return 2;
            }
            case 7: {
                return meta;
            }
            case 8: {
                return meta;
            }
            case 9: {
                return meta;
            }
            case 10: {
                return meta;
            }
            case 11: {
                return meta;
            }
            case 12: {
                return meta;
            }
        }
        return 0;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (optionalDrops[metadata] != null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(optionalDrops[metadata].func_77946_l());
            return list;
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    @Override
    protected int getMaxSheetSize(int meta) {
        return 16;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World world, int meta) {
        try {
            switch (meta) {
                case 0: {
                    return new TileEntityGenerator();
                }
                case 1: {
                    return new TileEntityGeoGenerator();
                }
                case 2: {
                    return new TileEntityWaterGenerator();
                }
                case 3: {
                    return new TileEntitySolarGenerator();
                }
                case 4: {
                    return new TileEntityWindGenerator();
                }
                case 5: {
                    return (TileEntityBlock)tileEntityNuclearReactorClass.newInstance();
                }
                case 6: {
                    return new TileEntityNuclearReactorSteam();
                }
                case 7: {
                    return new TileEntitySolarLV();
                }
                case 8: {
                    return new TileEntitySolarMV();
                }
                case 9: {
                    return new TileEntitySolarHV();
                }
                case 10: {
                    return new TileEntityWaterLV();
                }
                case 11: {
                    return new TileEntityWaterMV();
                }
                case 12: {
                    return new TileEntityWaterHV();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 3 || meta == 7 || meta == 8 || meta == 9) {
            return false;
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        if (!IC2.platform.isRendering()) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        if (meta == 0 && BlockGenerator.isActive((IBlockAccess)world, i, j, k)) {
            TileEntityBlock te = (TileEntityBlock)world.func_147438_o(i, j, k);
            short l = te.getFacing();
            float f = (float)i + 0.5f;
            float f2 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f3 = (float)k + 0.5f;
            float f4 = 0.52f;
            float f5 = random.nextFloat() * 0.6f - 0.3f;
            switch (l) {
                case 4: {
                    world.func_72869_a("smoke", (double)(f - f4), (double)f2, (double)(f3 + f5), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - f4), (double)f2, (double)(f3 + f5), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f2, (double)(f3 + f5), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f2, (double)(f3 + f5), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("smoke", (double)(f + f5), (double)f2, (double)(f3 - f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f5), (double)f2, (double)(f3 - f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("smoke", (double)(f + f5), (double)f2, (double)(f3 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f5), (double)f2, (double)(f3 + f4), 0.0, 0.0, 0.0);
                }
            }
        } else if (meta == 5 || meta == 6) {
            int n;
            int puffs = ((TileEntityNuclearReactor)world.func_147438_o((int)i, (int)j, (int)k)).heat / 1000;
            if (puffs <= 0) {
                return;
            }
            puffs = world.field_73012_v.nextInt(puffs);
            for (n = 0; n < puffs; ++n) {
                world.func_72869_a("smoke", (double)((float)i + random.nextFloat()), (double)((float)j + 0.95f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
            }
            puffs -= world.field_73012_v.nextInt(4) + 3;
            for (n = 0; n < puffs; ++n) {
                world.func_72869_a("flame", (double)((float)i + random.nextFloat()), (double)((float)j + 1.0f), (double)((float)k + random.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float a, float b, float c) {
        return (entityplayer.func_71045_bC() == null || !entityplayer.func_71045_bC().func_77969_a(Ic2Items.reactorChamber) || !entityplayer.func_71045_bC().func_77969_a(Ic2Items.steamReactorChamber)) && super.func_149727_a(world, i, j, k, entityplayer, side, a, b, c);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack stack) {
        return stack.func_77960_j() == 5 || stack.func_77960_j() == 6 ? EnumRarity.uncommon : EnumRarity.common;
    }

    @Override
    public void init() {
        Ic2Items.generator = new ItemStack((Block)this, 1, 0);
        Ic2Items.geothermalGenerator = new ItemStack((Block)this, 1, 1);
        Ic2Items.waterMill = new ItemStack((Block)this, 1, 2);
        Ic2Items.solarPanel = new ItemStack((Block)this, 1, 3);
        Ic2Items.windMill = new ItemStack((Block)this, 1, 4);
        Ic2Items.nuclearReactor = new ItemStack((Block)this, 1, 5);
        Ic2Items.steamReactor = new ItemStack((Block)this, 1, 6);
        Ic2Items.lvSolarPanel = new ItemStack((Block)this, 1, 7);
        Ic2Items.mvSolarPanel = new ItemStack((Block)this, 1, 8);
        Ic2Items.hvSolarPanel = new ItemStack((Block)this, 1, 9);
        Ic2Items.lvWaterMill = new ItemStack((Block)this, 1, 10);
        Ic2Items.mvWaterMill = new ItemStack((Block)this, 1, 11);
        Ic2Items.hvWaterMill = new ItemStack((Block)this, 1, 12);
    }
}

