/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyContainer;
import ic2.api.energy.tile.IEnergySourceInfo;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityBaseGenerator
extends TileEntityMachine
implements IEnergySourceInfo,
IHasGui,
IEnergyContainer {
    public static Random random = new Random();
    public int fuel = 0;
    public short storage = 0;
    public short maxStorage;
    public int production;
    public int tier = 1;
    public int ticksSinceLastActiveUpdate;
    public int activityMeter = 0;
    public boolean addedToEnergyNet = false;
    public AudioSource audioSource = null;

    public TileEntityBaseGenerator(int slots, int production, int maxStorage) {
        super(slots);
        this.production = production;
        this.maxStorage = (short)maxStorage;
        this.ticksSinceLastActiveUpdate = random.nextInt(256);
        this.addGuiFields("storage", "fuel");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.func_74762_e("fuel");
        }
        catch (Throwable e) {
            this.fuel = nbttagcompound.func_74765_d("fuel");
        }
        this.storage = nbttagcompound.func_74765_d("storage");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74777_a("storage", this.storage);
    }

    public int gaugeStorageScaled(int i) {
        return this.storage * i / this.maxStorage;
    }

    public abstract int gaugeFuelScaled(int var1);

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.needsFuel() && this.gainFuel()) {
            needsInvUpdate = true;
            this.getNetwork().updateTileGuiField(this, "fuel");
        }
        short oldEnergy = this.storage;
        boolean newActive = this.gainEnergy();
        if (this.storage > this.maxStorage) {
            this.storage = this.maxStorage;
        }
        if (this.storage > 0 && this.inventory[0] != null && (this.inventory[0].func_77973_b() instanceof IElectricItem || ElectricItem.getBackupManager(this.inventory[0]) != null)) {
            int used = (int)ElectricItem.manager.charge(this.inventory[0], this.storage, this.tier, false, false);
            this.storage = (short)(this.storage - (short)used);
            if (used > 0) {
                needsInvUpdate = true;
            }
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (!this.delayActiveUpdate()) {
            this.setActive(newActive);
        } else {
            if (this.ticksSinceLastActiveUpdate % 256 == 0) {
                this.setActive(this.activityMeter > 0);
                this.activityMeter = 0;
            }
            this.activityMeter = newActive ? ++this.activityMeter : --this.activityMeter;
            ++this.ticksSinceLastActiveUpdate;
        }
        if (oldEnergy != this.storage || newActive) {
            this.getNetwork().updateTileGuiField(this, "storage");
        }
    }

    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.storage = (short)(this.storage + (short)this.production);
            --this.fuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
            return true;
        }
        return false;
    }

    public boolean isConverting() {
        return this.fuel > 0 && this.storage + this.production <= this.maxStorage;
    }

    public boolean needsFuel() {
        return this.fuel <= 0 && this.storage + this.production <= this.maxStorage;
    }

    public abstract boolean gainFuel();

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        if ((double)this.storage < 1.0) {
            return 0.0;
        }
        return Math.min(this.production, this.storage);
    }

    @Override
    public void drawEnergy(double amount) {
        this.storage = (short)((double)this.storage - amount);
        this.getNetwork().updateTileGuiField(this, "storage");
    }

    @Override
    public abstract String func_145825_b();

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String getOperationSoundFile() {
        return null;
    }

    public boolean delayActiveUpdate() {
        return false;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource != null && this.audioSource.isRemoved()) {
                this.audioSource = null;
            }
            if (this.audioSource == null && this.getOperationSoundFile() != null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, this.getOperationSoundFile(), true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public float getWrenchDropRate() {
        return 0.9f;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }

    @Override
    public int getStoredEnergy() {
        return this.storage;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getEnergyUsage() {
        return 0;
    }

    @Override
    public int getEnergyProduction() {
        return this.production;
    }

    @Override
    public int getMaxEnergyInput() {
        return 0;
    }
}

