/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.generator.container.ContainerBaseGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityGeoGenerator
extends TileEntityBaseGenerator
implements ISidedInventory,
IFluidHandler {
    public int maxLava = 24000;

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public TileEntityGeoGenerator() {
        super(2, IC2.energyGeneratorGeo, IC2.energyGeneratorGeo);
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxLava;
    }

    @Override
    public boolean gainFuel() {
        if (this.inventory[1] == null || this.maxLava - this.fuel < 1000) {
            return false;
        }
        if (this.inventory[1].func_77973_b() == Items.field_151129_at) {
            this.fuel += 1000;
            this.inventory[1].func_150996_a(Items.field_151133_ar);
            return true;
        }
        if (this.inventory[1].func_77973_b() == Ic2Items.lavaCell.func_77973_b()) {
            this.fuel += 1000;
            ItemStack itemStack = this.inventory[1];
            --itemStack.field_77994_a;
            if (this.inventory[1].field_77994_a <= 0) {
                this.inventory[1] = null;
            }
            return true;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[1]);
        if (liquid != null && liquid.getFluidID() == FluidRegistry.LAVA.getID()) {
            this.fuel += liquid.amount;
            if (this.inventory[1].func_77973_b().hasContainerItem(this.inventory[1])) {
                this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
            } else {
                ItemStack itemStack2 = this.inventory[1];
                --itemStack2.field_77994_a;
                if (this.inventory[1].field_77994_a <= 0) {
                    this.inventory[1] = null;
                }
            }
            return true;
        }
        return false;
    }

    public boolean gainFuelSub(ItemStack stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxLava;
    }

    public int distributeLava(int amount) {
        int need = this.maxLava - this.fuel;
        if (need > amount) {
            need = amount;
        }
        this.fuel += need / 2;
        this.getNetwork().updateTileGuiField(this, "fuel");
        return amount -= need;
    }

    public boolean canTakeBucket() {
        return this.fuel <= 23000;
    }

    @Override
    public String func_145825_b() {
        if (this.isRendering()) {
            return "Geothermal Generator";
        }
        return "Geoth. Generator";
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBaseGenerator(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.generator.gui.GuiGeoGenerator";
    }

    public void onBlockBreak(int a, int b) {
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(new FluidStack(FluidRegistry.LAVA, this.fuel), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public int[] func_94128_d(int var1) {
        if (var1 > 1) {
            return new int[0];
        }
        return new int[]{0};
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluidID() != FluidRegistry.LAVA.getID()) {
            return 0;
        }
        int toAdd = Math.min(resource.amount, this.maxLava - this.fuel);
        if (doFill) {
            this.fuel += toAdd;
        }
        return toAdd;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.getID() == FluidRegistry.LAVA.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(FluidRegistry.LAVA, this.fuel), this.maxLava)};
    }

    @Override
    public int getMaxEnergyAmount() {
        return IC2.energyGeneratorGeo;
    }
}

