/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.generator.container.ContainerWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.util.AabbUtil;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityWaterGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public static AabbUtil.IBlockFilter filter = new WaterFilter();
    public static Random randomizer = new Random();
    public int ticker;
    public int water = 0;
    public int microStorage = 0;
    public int maxWater = 2000;
    public int fuelMultiplier;

    public TileEntityWaterGenerator() {
        this(1);
        this.ticker = randomizer.nextInt(this.tickRate());
    }

    public TileEntityWaterGenerator(int par4) {
        super(2 * par4, 2 * par4, 2 * par4);
        this.fuelMultiplier = par4;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateWaterCount();
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxWater;
    }

    @Override
    public boolean gainEnergy() {
        if (this.isConverting()) {
            this.storage = (short)(this.storage + (short)this.production);
            --this.fuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
            return true;
        }
        return this.water > 0;
    }

    @Override
    public boolean gainFuel() {
        if (this.inventory[1] != null && this.maxWater - this.fuel >= 500) {
            if (this.inventory[1].func_77973_b() == Items.field_151131_as) {
                this.production = this.fuelMultiplier;
                this.fuel += 500 / this.fuelMultiplier;
                this.inventory[1].func_150996_a(Items.field_151133_ar);
                return true;
            }
            if (this.inventory[1].func_77973_b() == Ic2Items.waterCell.func_77973_b()) {
                this.production = this.fuelMultiplier * 2;
                this.fuel += 500 / this.fuelMultiplier;
                ItemStack itemStack = this.inventory[1];
                --itemStack.field_77994_a;
                if (this.inventory[1].field_77994_a <= 0) {
                    this.inventory[1] = null;
                }
                return true;
            }
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[1]);
            if (liquid != null && liquid.getFluidID() == FluidRegistry.WATER.getID()) {
                this.fuel += liquid.amount / 2 / this.fuelMultiplier;
                if (this.inventory[1].func_77973_b().hasContainerItem(this.inventory[1])) {
                    this.production = this.fuelMultiplier;
                    this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
                } else {
                    this.production = this.fuelMultiplier * 2;
                    ItemStack itemStack2 = this.inventory[1];
                    --itemStack2.field_77994_a;
                    if (this.inventory[1].field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                }
                return true;
            }
        } else if (this.fuel <= 0) {
            this.flowPower();
            this.production = this.microStorage / 100;
            this.microStorage -= this.production * 100;
            if (this.production > 0) {
                ++this.fuel;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean gainFuelSub(ItemStack stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxWater;
    }

    public void flowPower() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateWaterCount();
        }
        this.water = this.water * IC2.energyGeneratorWater / 100;
        if (this.water > 0) {
            this.microStorage += this.water;
        }
    }

    public void updateWaterCount() {
        this.water = AabbUtil.getBlockCount(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, filter, true, false, Arrays.asList(ForgeDirection.VALID_DIRECTIONS));
    }

    @Override
    public String func_145825_b() {
        return "Water Mill";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.generator.gui.GuiWaterGenerator";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/WatermillLoop.ogg";
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerWaterGenerator(entityPlayer, this);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{1};
    }

    @Override
    public int getMaxEnergyAmount() {
        return 2;
    }

    public static class WaterFilter
    implements AabbUtil.IBlockFilter {
        @Override
        public boolean isBlockValid(Block block, int meta) {
            return block == Blocks.field_150358_i || block == Blocks.field_150355_j;
        }

        @Override
        public boolean isBlockValid(World world, int x, int y, int z) {
            Block block = world.func_147439_a(x, y, z);
            return block == Blocks.field_150358_i || block == Blocks.field_150355_j;
        }
    }
}

