/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.container;

import ic2.core.ContainerIC2;
import ic2.core.block.machine.logic.ReactorInventory;
import ic2.core.block.machine.logic.ReactorLogicBase;
import ic2.core.block.machine.tileentity.TileEntityReactorPlanner;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerReactorPlanner
extends ContainerIC2 {
    public TileEntityReactorPlanner planner;

    public ContainerReactorPlanner(InventoryPlayer player, TileEntityReactorPlanner tile) {
        this.planner = tile;
        this.addReactor();
        this.addComponents();
        this.addPlayerInv(player);
    }

    public void clear() {
        this.field_75153_a.clear();
        this.field_75151_b.clear();
    }

    public void reset(InventoryPlayer player) {
        this.clear();
        this.addReactor();
        this.addComponents();
        this.addPlayerInv(player);
    }

    public void addReactor() {
        ReactorInventory inv = new ReactorInventory(this.planner);
        int size = this.planner.reactorSize + 3;
        int remove = this.planner.reactorSize * 9;
        for (int i = 0; i < 54; ++i) {
            int x = i % 9;
            int y = i / 9;
            if (x >= size) continue;
            this.func_75146_a(new SlotPlanner(inv, i, 61 + x * 18 - remove, 21 + y * 18));
        }
    }

    public void addComponents() {
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.func_75146_a(new SlotComponent(this.planner.components, x + y * 3, 216 + 18 * x, 18 + 18 * y));
            }
        }
    }

    public void addPlayerInv(InventoryPlayer player) {
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)player, j, 8 + j * 18, 188));
        }
    }

    @Override
    public int guiInventorySize() {
        return 15 + (this.planner.reactorSize + 3) * 9;
    }

    @Override
    public int getInput() {
        return 0;
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        if (slotID >= this.field_75151_b.size()) {
            return;
        }
        Slot slot = this.func_75139_a(slotID);
        if (slot == null) {
            return;
        }
        slot.func_75215_d(stack);
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.planner.canInteractWith(player);
    }

    @Nullable
    public ItemStack func_75144_a(int slotId, int dragType, int clickType, EntityPlayer player) {
        if (slotId != -999) {
            if (slotId >= this.guiInventorySize()) {
                return null;
            }
            boolean client = this.planner.isRendering();
            Slot slot = this.func_75139_a(slotId);
            if (slot instanceof SlotComponent) {
                if (client) {
                    return null;
                }
                this.planner.selectedSlot = slot.getSlotIndex();
                this.planner.getNetwork().updateTileEntityField(this.planner, "selectedSlot");
                return null;
            }
            if (slot instanceof SlotPlanner) {
                if (client) {
                    return null;
                }
                ReactorLogicBase logic = this.planner.getReactorLogic();
                ReactorLogicBase.IReactorPrediction predict = this.planner.getPrediction();
                if (dragType == 0) {
                    ItemStack stack;
                    if (logic.isValid()) {
                        predict.clear();
                        logic.reset();
                        this.planner.updatePrediction();
                        this.planner.updateReactor();
                    }
                    if ((stack = ItemStack.func_77944_b((ItemStack)this.planner.components.func_70301_a(this.planner.selectedSlot))) != null) {
                        stack.field_77994_a = Math.min(stack.func_77976_d(), this.planner.stackSize);
                    }
                    slot.func_75215_d(stack);
                    this.func_75142_b();
                } else if (dragType == 1) {
                    if (logic.isValid()) {
                        predict.clear();
                        logic.reset();
                        this.planner.updatePrediction();
                        this.planner.updateReactor();
                    }
                    slot.func_75215_d(null);
                    this.func_75142_b();
                }
                return null;
            }
        }
        return super.func_75144_a(slotId, dragType, clickType, player);
    }

    public static class SlotGhoest
    extends Slot {
        public SlotGhoest(IInventory p_i1824_1_, int p_i1824_2_, int p_i1824_3_, int p_i1824_4_) {
            super(p_i1824_1_, p_i1824_2_, p_i1824_3_, p_i1824_4_);
        }

        public boolean func_75214_a(ItemStack p_75214_1_) {
            return false;
        }

        public boolean func_82869_a(EntityPlayer p_82869_1_) {
            return false;
        }
    }

    public static class SlotPlanner
    extends SlotGhoest {
        public SlotPlanner(IInventory inv, int index, int xPosition, int yPosition) {
            super(inv, index, xPosition, yPosition);
        }
    }

    public static class SlotComponent
    extends SlotGhoest {
        public SlotComponent(IInventory inv, int index, int xPosition, int yPosition) {
            super(inv, index, xPosition, yPosition);
        }
    }
}

