/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.logic;

import ic2.api.network.INetworkFieldData;
import ic2.api.reactor.IReactorPlanner;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.core.IC2;
import ic2.core.block.machine.tileentity.TileEntityReactorPlanner;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public abstract class ReactorLogicBase
implements IReactorPlanner,
IInventory,
INetworkFieldData {
    TileEntityReactorPlanner planner;
    public int ticksDone;
    public int ticksLeft;
    public int maxTick;
    public boolean custom;
    public int currentHeat;
    public int maxHeat;
    public float explosionEffect;
    public float production;
    public boolean producing;
    public boolean isExploded;
    public boolean didComponentBreak;
    public boolean isValid;
    public boolean collecting;
    public int fuelPulses;
    public int reEnrichPulses;
    public ItemStack[] inv = new ItemStack[54];

    public ReactorLogicBase(TileEntityReactorPlanner tile) {
        this.planner = tile;
    }

    public abstract void onTick();

    public abstract void onFinished();

    public abstract void validate();

    public abstract void reset();

    public abstract IReactorPrediction createPrediction();

    public abstract TileEntityReactorPlanner.ReactorBackup createBackup();

    public abstract void restoreFromBackup(TileEntityReactorPlanner.ReactorBackup var1);

    public abstract boolean isSteamLogic();

    public void pauseProduction() {
        this.producing = false;
    }

    public void continueProduction() {
        this.producing = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean didReactorBreak() {
        return this.didComponentBreak || this.isExploded;
    }

    public boolean isFinished() {
        return this.ticksLeft == 0;
    }

    public TileEntityReactorPlanner getPlanner() {
        return this.planner;
    }

    public int getReactorSize() {
        return 3 + this.getPlanner().reactorSize;
    }

    public void onSizeUpdate() {
        int size;
        for (int x = size = this.getReactorSize(); x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                this.func_70299_a(y * 9 + x, null);
            }
        }
    }

    @Override
    public void setRedstoneSignal(boolean redstone) {
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inv[par1];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.inv[p_70298_1_] != null) {
            if (this.inv[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.inv[p_70298_1_];
                this.inv[p_70298_1_] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inv[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.inv[p_70298_1_].field_77994_a == 0) {
                this.inv[p_70298_1_] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        if (this.inv[p_70304_1_] != null) {
            ItemStack itemstack = this.inv[p_70304_1_];
            this.inv[p_70304_1_] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.inv[p_70299_1_] = p_70299_2_;
    }

    public String func_145825_b() {
        return "ReactorLogicBase";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    @Override
    public World getWorld() {
        return this.getPlanner().func_145831_w();
    }

    @Override
    public ChunkCoordinates getPosition() {
        TileEntityReactorPlanner planner = this.getPlanner();
        return new ChunkCoordinates(planner.field_145851_c, planner.field_145848_d, planner.field_145849_e);
    }

    @Override
    public int getHeat() {
        return this.currentHeat;
    }

    @Override
    public void setHeat(int heat) {
        this.currentHeat = heat;
    }

    @Override
    public int addHeat(int amount) {
        return this.currentHeat += amount;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public void addEmitHeat(int heat) {
    }

    @Override
    public float getHeatEffectModifier() {
        return this.explosionEffect;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.explosionEffect = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.production;
    }

    @Override
    public double getReactorEUEnergyOutput() {
        return this.production * (float)IC2.energyGeneratorNuclear;
    }

    @Override
    public float addOutput(float energy) {
        return this.production += energy;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.getMatrixItem(x, y);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        this.setMatrixItem(x, y, item);
    }

    public void setMatrixItem(int x, int y, ItemStack item) {
        if (x < 0 || x >= this.getReactorSize() || y < 0 || y >= 6) {
            return;
        }
        this.func_70299_a(y * 9 + x, item);
    }

    public ItemStack getMatrixItem(int x, int y) {
        if (x < 0 || x >= this.getReactorSize() || y < 0 || y >= 6) {
            return null;
        }
        return this.func_70301_a(y * 9 + x);
    }

    @Override
    public void explode() {
    }

    @Override
    public int getTickRate() {
        return 0;
    }

    @Override
    public boolean produceEnergy() {
        return this.producing;
    }

    @Override
    public boolean isFluidCooled() {
        return false;
    }

    public IReactorPlannerComponent getComponent(int slot) {
        ItemStack item = this.inv[slot];
        if (item == null) {
            return null;
        }
        if (item.func_77973_b() instanceof IReactorPlannerComponent) {
            return (IReactorPlannerComponent)item.func_77973_b();
        }
        return null;
    }

    @Override
    public void read(DataInput stream) {
        try {
            this.ticksDone = stream.readInt();
            this.ticksLeft = stream.readInt();
            this.maxTick = stream.readInt();
            this.currentHeat = stream.readInt();
            this.maxHeat = stream.readInt();
            this.explosionEffect = stream.readFloat();
            this.production = stream.readFloat();
            this.producing = stream.readBoolean();
            this.isExploded = stream.readBoolean();
            this.isValid = stream.readBoolean();
            this.custom = stream.readBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(DataOutput stream) {
        try {
            stream.writeInt(this.ticksDone);
            stream.writeInt(this.ticksLeft);
            stream.writeInt(this.maxTick);
            stream.writeInt(this.currentHeat);
            stream.writeInt(this.maxHeat);
            stream.writeFloat(this.explosionEffect);
            stream.writeFloat(this.production);
            stream.writeBoolean(this.producing);
            stream.writeBoolean(this.isExploded);
            stream.writeBoolean(this.isValid);
            stream.writeBoolean(this.custom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readStateFromNBT(NBTTagCompound nbt) {
        this.ticksDone = nbt.func_74762_e("TimeGone");
        this.ticksLeft = nbt.func_74762_e("TimeLeft");
        this.maxTick = nbt.func_74762_e("TotalTime");
        this.currentHeat = nbt.func_74762_e("Heat");
        this.maxHeat = nbt.func_74762_e("MaxHeat");
        this.explosionEffect = nbt.func_74760_g("ExplosionEffect");
        this.production = nbt.func_74760_g("Production");
        this.producing = nbt.func_74767_n("Producing");
        this.isExploded = nbt.func_74767_n("IsExploded");
        this.isValid = nbt.func_74767_n("isValid");
        this.custom = nbt.func_74767_n("Custom");
        NBTTagList list = nbt.func_150295_c("Setup", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            this.inv[data.func_74762_e((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
    }

    public void writeStateToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("TimeGone", this.ticksDone);
        nbt.func_74768_a("TimeLeft", this.ticksLeft);
        nbt.func_74768_a("TotalTime", this.maxTick);
        nbt.func_74768_a("Heat", this.currentHeat);
        nbt.func_74768_a("MaxHeat", this.maxHeat);
        nbt.func_74776_a("ExplosionEffect", this.explosionEffect);
        nbt.func_74776_a("Production", this.production);
        nbt.func_74757_a("Producing", this.producing);
        nbt.func_74757_a("IsExploded", this.isExploded);
        nbt.func_74757_a("isValid", this.isValid);
        nbt.func_74757_a("Custom", this.custom);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 54; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            this.inv[i].func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Setup", (NBTBase)list);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("TimeGone", this.ticksDone);
        nbt.func_74768_a("TimeLeft", this.ticksLeft);
        nbt.func_74768_a("TotalTime", this.maxTick);
        nbt.func_74768_a("Heat", this.currentHeat);
        nbt.func_74768_a("MaxHeat", this.maxHeat);
        nbt.func_74776_a("ExplosionEffect", this.explosionEffect);
        nbt.func_74776_a("Production", this.production);
        nbt.func_74757_a("Producing", this.producing);
        nbt.func_74757_a("IsExploded", this.isExploded);
        nbt.func_74757_a("isValid", this.isValid);
        nbt.func_74757_a("Custom", this.custom);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 54; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            this.inv[i].func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Setup", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.ticksDone = nbt.func_74762_e("TimeGone");
        this.ticksLeft = nbt.func_74762_e("TimeLeft");
        this.maxTick = nbt.func_74762_e("TotalTime");
        this.currentHeat = nbt.func_74762_e("Heat");
        this.maxHeat = nbt.func_74762_e("MaxHeat");
        this.explosionEffect = nbt.func_74760_g("ExplosionEffect");
        this.production = nbt.func_74760_g("Production");
        this.producing = nbt.func_74767_n("Producing");
        this.isExploded = nbt.func_74767_n("IsExploded");
        this.isValid = nbt.func_74767_n("isValid");
        this.custom = nbt.func_74767_n("Custom");
        this.inv = new ItemStack[54];
        NBTTagList list = nbt.func_150295_c("Setup", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            this.inv[data.func_74762_e((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
    }

    public void clear() {
        this.ticksDone = 0;
        this.ticksLeft = 0;
        this.maxTick = 0;
        this.currentHeat = 0;
        this.maxHeat = 10000;
        this.explosionEffect = 1.0f;
        this.production = 0.0f;
        this.producing = false;
        this.isExploded = false;
        this.isValid = false;
        this.custom = false;
        this.inv = new ItemStack[54];
    }

    @Override
    public boolean isCollecting() {
        return this.collecting;
    }

    @Override
    public void addFuelPulse() {
        ++this.fuelPulses;
    }

    @Override
    public void addReEnrichPulse() {
        ++this.reEnrichPulses;
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public static interface IReactorPrediction
    extends INetworkFieldData {
        public void readFromNBT(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound var1);

        public boolean isSteam();

        public void clear();
    }
}

