/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.logic;

import ic2.api.network.INetworkFieldData;
import ic2.api.reactor.IReactorPlannerComponent;
import ic2.core.block.machine.logic.PlannerRegistry;
import ic2.core.block.machine.tileentity.TileEntityReactorPlanner;
import ic2.core.util.StackUtil;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ReactorPlannerInv
implements IInventory,
INetworkFieldData {
    TileEntityReactorPlanner planner;
    ItemStack[] currentSet = new ItemStack[0];
    ItemStack[] items = new ItemStack[15];
    public int offset = 0;
    public byte type = (byte)-1;

    public ReactorPlannerInv(TileEntityReactorPlanner tile) {
        this.planner = tile;
    }

    public void create() {
        this.currentSet = this.getItemsFromType();
        this.init();
    }

    void init() {
        int start = this.offset * 3;
        for (int i = 0; i < 15; ++i) {
            ItemStack stack;
            int slot = start + i;
            this.items[i] = slot >= this.currentSet.length ? null : ((stack = this.currentSet[slot]) == null ? null : StackUtil.copyWithSize(stack, 1));
        }
    }

    public boolean canDecrease() {
        return this.offset > 0;
    }

    public boolean canIncrease() {
        return this.offset * 3 + 15 < (this.currentSet == null ? 0 : this.currentSet.length);
    }

    public void setFilter(IReactorPlannerComponent.ReactorComponentType newType) {
        this.offset = 0;
        this.type = (byte)(newType == null ? -1 : newType.ordinal());
        this.currentSet = this.getItemsFromType();
        this.init();
    }

    public void setNextFilter() {
        IReactorPlannerComponent.ReactorComponentType[] array = IReactorPlannerComponent.ReactorComponentType.values();
        if (this.type + 1 >= array.length) {
            this.setFilter(null);
            return;
        }
        this.setFilter(array[this.type + 1]);
    }

    public void applyOffset(int extra) {
        if (extra > 0) {
            int realOffset = this.offset * 3 + 15;
            if (realOffset >= this.currentSet.length) {
                return;
            }
            this.offset += extra;
            int max = (this.currentSet.length - 15) / 3 + 1;
            if (this.offset > max) {
                this.offset = max;
            }
            this.init();
        } else if (extra < 0) {
            this.offset += extra;
            if (this.offset < 0) {
                this.offset = 0;
            }
            this.init();
        }
    }

    public int func_70302_i_() {
        return 15;
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.items[p_70299_1_] = p_70299_2_;
    }

    public String func_145825_b() {
        return "Planner Inv";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public ItemStack[] getItemsFromType() {
        return PlannerRegistry.getItemsByType(this.type, this.planner.isSteamReactor);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.type = nbt.func_74771_c("Type");
        this.offset = nbt.func_74762_e("Offset");
        this.currentSet = this.getItemsFromType();
        this.init();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("Type", this.type);
        nbt.func_74768_a("Offset", this.offset);
    }

    @Override
    public void read(DataInput stream) {
        try {
            this.type = stream.readByte();
            this.offset = stream.readInt();
            this.currentSet = new ItemStack[stream.readInt()];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void write(DataOutput stream) {
        try {
            stream.writeByte(this.type);
            stream.writeInt(this.offset);
            stream.writeInt(this.currentSet == null ? 0 : this.currentSet.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

