/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.logic.encoder.impl;

import ic2.core.block.machine.logic.PlannerRegistry;
import ic2.core.block.machine.logic.ReactorLogicBase;
import ic2.core.block.machine.logic.encoder.ByteShifter;
import ic2.core.block.machine.logic.encoder.IEncoder;
import ic2.core.block.machine.tileentity.TileEntityReactorPlanner;
import ic2.core.util.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TalonEncoder
implements IEncoder {
    @Override
    public NBTTagCompound createDecodedData(String data) {
        if (!data.startsWith("http://www.talonfiremage.pwp.blueyonder.co.uk/v3/reactorplanner.html")) {
            return null;
        }
        if (data.indexOf("?") == -1) {
            return null;
        }
        ByteShifter shift = new ByteShifter(data.substring(data.indexOf(63) + 1));
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Heat", shift.readInt(10) * 100);
        NBTTagList list = new NBTTagList();
        for (int x = 8; x >= 0; --x) {
            for (int y = 5; y >= 0; --y) {
                int stackSize;
                int nextType = shift.readInt(7);
                if (nextType == 0) continue;
                int n = stackSize = nextType == 0 ? 0 : 1;
                if (nextType > 64) {
                    stackSize = nextType - 64 + 1;
                    nextType = shift.readInt(7);
                }
                NBTTagCompound nbtData = new NBTTagCompound();
                nbtData.func_74768_a("Slot", y * 9 + x);
                nbtData.func_74777_a("ID", this.convertID(nextType));
                nbtData.func_74774_a("StackSize", (byte)stackSize);
                list.func_74742_a((NBTBase)nbtData);
            }
        }
        nbt.func_74782_a("ReactorData", (NBTBase)list);
        nbt.func_74774_a("Size", (byte)shift.readInt(3));
        return nbt;
    }

    @Override
    public void processData(NBTTagCompound decodedData, TileEntityReactorPlanner planner) {
        planner.isSteamReactor = false;
        planner.reactorSize = decodedData.func_74762_e("Size");
        ReactorLogicBase base = planner.getReactorLogic();
        base.clear();
        boolean valid = false;
        NBTTagList list = decodedData.func_150295_c("ReactorData", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            ItemStack stack = PlannerRegistry.getComponentFromID(nbt.func_74765_d("ID"));
            if (stack == null) continue;
            int slot = nbt.func_74762_e("Slot");
            base.func_70299_a(slot, StackUtil.copyWithSize(stack, nbt.func_74762_e("StackSize")));
            valid = true;
        }
        if (valid) {
            planner.getUserSettings().startingHeat = decodedData.func_74762_e("Heat");
            base.validate();
        }
    }

    @Override
    public String createEncodedData(TileEntityReactorPlanner planner) {
        ReactorLogicBase base = planner.getReactorLogic();
        ByteShifter shifter = new ByteShifter();
        shifter.writeInteger(0, 16);
        shifter.writeInteger(planner.reactorSize, 3);
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                ItemStack stack = base.getMatrixItem(x, y);
                if (stack == null) {
                    shifter.writeInteger(0, 7);
                    continue;
                }
                int id = this.convertBack(PlannerRegistry.getID(stack));
                shifter.writeInteger(id, 7);
                if (stack.field_77994_a <= 1) continue;
                shifter.writeInteger(64 + (stack.field_77994_a - 1), 7);
            }
        }
        shifter.writeInteger(planner.getUserSettings().startingHeat / 100, 10);
        return this.getURL() + "?" + shifter.getDataCode();
    }

    @Override
    public String getName() {
        return "Talon";
    }

    @Override
    public boolean hasBitLimit() {
        return true;
    }

    @Override
    public int getBitLimit() {
        return 7;
    }

    public short convertID(int id) {
        switch (id) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 36;
            }
            case 5: {
                return 34;
            }
            case 6: {
                return 35;
            }
            case 7: {
                return 18;
            }
            case 8: {
                return 19;
            }
            case 9: {
                return 21;
            }
            case 10: {
                return 20;
            }
            case 11: {
                return 26;
            }
            case 12: {
                return 15;
            }
            case 13: {
                return 16;
            }
            case 14: {
                return 27;
            }
            case 15: {
                return 28;
            }
            case 16: {
                return 29;
            }
            case 17: {
                return 30;
            }
            case 18: {
                return 31;
            }
            case 19: {
                return 33;
            }
            case 20: {
                return 32;
            }
            case 21: {
                return 12;
            }
            case 22: {
                return 13;
            }
            case 23: {
                return 14;
            }
            case 24: {
                return 17;
            }
        }
        return -1;
    }

    public int convertBack(short id) {
        switch (id) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 36: {
                return 4;
            }
            case 34: {
                return 5;
            }
            case 35: {
                return 6;
            }
            case 18: {
                return 7;
            }
            case 19: {
                return 8;
            }
            case 21: {
                return 9;
            }
            case 20: {
                return 10;
            }
            case 26: {
                return 11;
            }
            case 15: {
                return 12;
            }
            case 16: {
                return 13;
            }
            case 27: {
                return 14;
            }
            case 28: {
                return 15;
            }
            case 29: {
                return 16;
            }
            case 30: {
                return 17;
            }
            case 31: {
                return 18;
            }
            case 33: {
                return 19;
            }
            case 32: {
                return 20;
            }
            case 12: {
                return 21;
            }
            case 13: {
                return 22;
            }
            case 14: {
                return 23;
            }
            case 17: {
                return 24;
            }
        }
        return 0;
    }

    public String getURL() {
        return "http://www.talonfiremage.pwp.blueyonder.co.uk/v3/reactorplanner.html";
    }
}

