/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.energy.EnergyNet;
import ic2.api.item.IMachineUpgradeItem;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.RecipeOutput;
import ic2.api.tile.IMachine;
import ic2.api.tile.IRecipeMachine;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.container.ContainerAdvancedMachine;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class TileEntityAdvancedMachine
extends TileEntityElecMachine
implements IRecipeMachine,
IHasGui,
INetworkTileEntityEventListener,
ISidedInventory {
    public int speed = 0;
    public int MaxSpeed;
    public short progress = 0;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public float soundLevel = 1.0f;
    public AudioSource audioSource;
    public boolean redstoneInverted;
    public boolean redstoneSensitive;
    public boolean defaultSensitive;
    public boolean isProcessing;
    public List<ItemStack> results = new ArrayList<ItemStack>();
    private static int EventStart = 0;
    private static int EventInterrupt = 1;
    private static int EventStop = 2;

    public TileEntityAdvancedMachine(int slots, int usage, int maxProgress) {
        super(slots + 2, 0, 10000, 128, 2);
        this.defaultEnergyConsume = this.energyConsume = usage;
        this.MaxSpeed = 10000;
        this.defaultOperationLength = this.operationLength = maxProgress;
        this.defaultEnergyStorage = 10000;
        this.redstoneSensitive = true;
        this.defaultSensitive = true;
        this.addNetworkFields("redstoneInverted", "redstoneSensitive", "soundLevel");
        this.addGuiFields("operationLength", "progress", "speed");
    }

    public abstract RecipeOutput getResultFor(ItemStack var1, boolean var2);

    @Override
    public abstract IMachineRecipeManager getRecipeList();

    public abstract Slot[] getInvSlots(InventoryPlayer var1);

    public abstract int[] getOutputSlots();

    public abstract boolean isInputSlot(int var1);

    public abstract boolean isOutputSlot(int var1);

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
        this.speed = nbttagcompound.func_74762_e("Speed");
        this.results.clear();
        NBTTagList list = nbttagcompound.func_150295_c("Results", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            this.results.add(ItemStack.func_77949_a((NBTTagCompound)nbt));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
        nbttagcompound.func_74768_a("Speed", this.speed);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.results) {
            NBTTagCompound nbt = new NBTTagCompound();
            item.func_77955_b(nbt);
            list.func_74742_a((NBTBase)nbt);
        }
        nbttagcompound.func_74782_a("Results", (NBTBase)list);
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxEnergy;
        if (ret < 0.0f) {
            ret = 0.0f;
        }
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    public float getSpeedLevel() {
        float ret = (float)this.speed / (float)this.MaxSpeed;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    public float getProgress() {
        float ret = (float)this.getClientProgress() / (float)this.getClientOperationLenght();
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public boolean isProcessing() {
        return this.isProcessing;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void func_145845_h() {
        boolean canWork;
        super.func_145845_h();
        this.handleRedstone();
        boolean needsInvUpdate = this.addToInventory();
        RecipeOutput output = this.getOutput();
        boolean bl = canWork = this.canWork() || output != null && this.energy > 0;
        if (this.energy < this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if ((canWork || output != null) && this.energy > 0) {
            if (this.speed < this.MaxSpeed) {
                ++this.speed;
                this.getNetwork().updateTileGuiField(this, "speed");
            }
            this.useEnergy(1);
        } else if (this.speed > 0) {
            this.speed -= Math.min(this.speed, 4);
            this.getNetwork().updateTileGuiField(this, "speed");
        }
        if (canWork && output != null && this.energy >= this.energyConsume) {
            this.setActive(true);
            this.isProcessing = true;
            if (this.progress == 0) {
                this.getNetwork().initiateTileEntityEvent(this, 0, true);
            }
            this.progress = (short)(this.progress + this.speed / 30);
            this.useEnergy(this.energyConsume);
            if (this.progress >= this.getOperationLenght()) {
                this.progress = 0;
                this.operate();
                needsInvUpdate = true;
                this.getNetwork().initiateTileEntityEvent(this, 2, true);
            }
            this.getNetwork().updateTileGuiField(this, "progress");
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.getNetwork().initiateTileEntityEvent(this, 1, true);
            }
            if (output == null && this.progress != 0) {
                this.progress = 0;
                this.getNetwork().updateTileGuiField(this, "progress");
            }
            this.isProcessing = false;
            this.setActive(false);
        }
        if (canWork && this.energy > 0) {
            this.setActive(true);
        }
        for (int i = 0; i < 4; ++i) {
            IMachineUpgradeItem upgrade;
            ItemStack item = this.inventory[i + this.inventory.length - 4];
            if (item == null || !(item.func_77973_b() instanceof IMachineUpgradeItem) || !(upgrade = (IMachineUpgradeItem)item.func_77973_b()).onTick(item, this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    public void operate() {
        this.operate(1);
    }

    public void operate(int ... slots) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot : slots) {
            RecipeOutput output = this.getOutput(slot);
            if (output == null) continue;
            this.operateOnce(this.copy(output), slot, result);
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack itemStack = this.inventory[i + this.inventory.length - 2];
            if (itemStack == null || !(itemStack.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem item = (IMachineUpgradeItem)itemStack.func_77973_b();
            item.onProcessEnd(itemStack, this, result);
        }
        if (result.size() > 0) {
            this.results.addAll(result);
            this.addToInventory();
        }
        for (int slot : slots) {
            if (this.inventory[slot] == null || this.inventory[slot].field_77994_a > 0) continue;
            this.inventory[slot] = null;
        }
    }

    public void operateOnce(RecipeOutput result, int slot, List<ItemStack> items) {
        this.getResultFor(this.inventory[slot], true);
        items.addAll(result.items);
    }

    private RecipeOutput copy(RecipeOutput par1) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : par1.items) {
            items.add(item.func_77946_l());
        }
        return new RecipeOutput(par1.metadata, items);
    }

    public RecipeOutput getOutput() {
        return this.getOutput(1);
    }

    public RecipeOutput getOutput(int input) {
        if (this.inventory[input] == null && !this.canWorkWithoutItems()) {
            return null;
        }
        if (this.results.size() > 0) {
            return null;
        }
        ItemStack item = ItemStack.func_77944_b((ItemStack)this.inventory[input]);
        RecipeOutput out = this.getResultFor(item, false);
        if (out == null) {
            return null;
        }
        if (this.hasEmptyOutput()) {
            return out;
        }
        for (ItemStack output : out.items) {
            for (int slot : this.getOutputSlots()) {
                if (!this.inventory[slot].func_77969_a(output) || !ItemStack.func_77970_a((ItemStack)this.inventory[slot], (ItemStack)output) || this.inventory[slot].field_77994_a + output.field_77994_a > this.inventory[slot].func_77976_d()) continue;
                return out;
            }
        }
        return null;
    }

    private boolean hasEmptyOutput() {
        for (int slot : this.getOutputSlots()) {
            if (this.inventory[slot] != null) continue;
            return true;
        }
        return false;
    }

    public boolean canWorkWithoutItems() {
        return false;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public int getOperationLenght() {
        return this.operationLength;
    }

    public int getClientProgress() {
        return this.progress;
    }

    public int getClientOperationLenght() {
        return this.operationLength;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerAdvancedMachine(this, p0.field_71071_by);
    }

    public void setOverclockRates() {
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        float soundModfier = 1.0f;
        boolean redstonePowered = false;
        this.redstoneSensitive = this.defaultSensitive;
        for (int i = 0; i < 2; ++i) {
            ItemStack item = this.inventory[i + this.inventory.length - 2];
            if (item == null || !(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, this);
            extraProcessTime += upgrade.getExtraProcessTime(item, this) * item.field_77994_a;
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(item, this), item.field_77994_a);
            extraEnergyDemand += upgrade.getExtraEnergyDemand(item, this) * item.field_77994_a;
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(item, this), item.field_77994_a);
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, this) * item.field_77994_a;
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, this), item.field_77994_a);
            soundModfier = (float)((double)soundModfier * Math.pow(upgrade.getSoundVolumeMultiplier(item, this), item.field_77994_a));
            extraTier += upgrade.getExtraTier(item, this) * item.field_77994_a;
            if (!upgrade.useRedstoneinverter(item, this)) continue;
            redstonePowered = true;
        }
        this.redstoneInverted = redstonePowered;
        this.energyConsume = TileEntityAdvancedMachine.applyModifier(this.defaultEnergyConsume, extraEnergyDemand, energyDemandMultiplier);
        this.operationLength = TileEntityAdvancedMachine.applyModifier(this.defaultOperationLength, extraProcessTime, processTimeMultiplier);
        this.setMaxEnergy(TileEntityAdvancedMachine.applyModifier(this.defaultEnergyStorage, extraEnergyStorage, energyStorageMultiplier));
        this.tier = this.baseTier + extraTier;
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        this.soundLevel = soundModfier;
        if (this.maxInput < 0) {
            this.maxInput = Integer.MAX_VALUE;
        }
        if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        if (this.energyConsume < 1) {
            this.energyConsume = 1;
        }
        this.getNetwork().updateTileEntityField(this, "redstoneInverted");
        this.getNetwork().updateTileEntityField(this, "redstoneSensitive");
        this.getNetwork().updateTileEntityField(this, "soundLevel");
        this.getNetwork().updateTileGuiField(this, "operationLength");
        this.getNetwork().updateTileGuiField(this, "energyConsume");
        this.getNetwork().updateTileGuiField(this, "maxInput");
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public abstract String func_145825_b();

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public void onNetworkEvent(int event) {
        if (this.audioSource != null && this.audioSource.isRemoved()) {
            this.audioSource = null;
        }
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, this.getStartSoundFile(), true, false, IC2.audioManager.defaultVolume * this.soundLevel);
            this.audioSource.setLoop(true);
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce(this, PositionSpec.Center, this.getInterruptSoundFile(), false, IC2.audioManager.defaultVolume * this.soundLevel);
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("soundLevel") && this.audioSource != null) {
            this.audioSource.setVolume(IC2.audioManager.defaultVolume * this.soundLevel);
        }
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount, boolean simulate) {
        if (amount > (double)this.energy) {
            return false;
        }
        if (!simulate) {
            this.energy = (int)((double)this.energy - amount);
        }
        return true;
    }

    @Override
    public void setRedstoneSensitive(boolean active) {
        if (this.redstoneSensitive != active) {
            this.redstoneSensitive = active;
        }
    }

    public boolean canWork() {
        if (!this.redstoneSensitive) {
            return true;
        }
        return this.isRedstonePowered();
    }

    @Override
    public boolean isRedstonePowered() {
        if (this.redstoneInverted) {
            return !super.isRedstonePowered();
        }
        return super.isRedstonePowered();
    }

    @Override
    public boolean isRedstoneSensitive() {
        return this.redstoneSensitive;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        return this.inventory[1] == null || this.inventory[1].func_77969_a(par1) && ItemStack.func_77970_a((ItemStack)this.inventory[1], (ItemStack)par1);
    }

    @Override
    public List<IMachine.UpgradeType> getSupportedTypes() {
        ArrayList<IMachine.UpgradeType> types = new ArrayList<IMachine.UpgradeType>();
        types.addAll(Arrays.asList(IMachine.UpgradeType.values()));
        types.remove((Object)IMachine.UpgradeType.MachineModifierA);
        return types;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.isInputSlot(i) && this.isValidInput(itemstack);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.isInputSlot(i) && this.isValidInput(itemstack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return this.isOutputSlot(i);
    }

    public boolean addToInventory() {
        if (this.results.isEmpty()) {
            return false;
        }
        int added = 0;
        block0: for (int i = 0; i < this.results.size(); ++i) {
            ItemStack item = this.results.get(i);
            if (item != null && item.field_77994_a <= 0) {
                this.results.remove(i--);
                continue;
            }
            for (int slot : this.getOutputSlots()) {
                int itemLeft;
                int left;
                if (this.results.isEmpty() || item == null) continue block0;
                if (this.inventory[slot] == null) {
                    this.inventory[slot] = ItemStack.func_77944_b((ItemStack)item);
                    this.results.remove(i--);
                    ++added;
                    continue block0;
                }
                if (!item.func_77969_a(this.inventory[slot]) || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.inventory[slot]) || (left = this.inventory[slot].func_77976_d() - this.inventory[slot].field_77994_a) <= 0) continue;
                if (left >= item.field_77994_a) {
                    this.inventory[slot].field_77994_a += item.field_77994_a;
                    ++added;
                    this.results.remove(i--);
                    continue block0;
                }
                item.field_77994_a = itemLeft = item.field_77994_a - left;
                this.inventory[slot].field_77994_a = this.inventory[slot].func_77976_d();
                ++added;
                continue block0;
            }
        }
        return added > 0;
    }

    @Override
    public int getEnergyUsage() {
        return this.energyConsume + 1;
    }
}

