/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.energy.tile.IEnergyContainer;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.container.ContainerElectrolyzer;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.wiring.IElectrolyzerProvider;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityElectrolyzer
extends TileEntityMachine
implements IHasGui,
IEnergyContainer {
    public static Random randomizer = new Random();
    public static HashMap<ItemRecipe, ItemStack> charge = new HashMap();
    public static HashMap<ItemRecipe, ItemStack> discharge = new HashMap();
    public static HashMap<ItemRecipe, Integer> energyNeeds = new HashMap();
    public short energy = 0;
    public short maxEnergy = 0;
    public IElectrolyzerProvider mfe = null;
    public int ticker = randomizer.nextInt(16);
    public AudioSource audioSource;

    public TileEntityElectrolyzer() {
        super(2);
    }

    public static void init() {
        TileEntityElectrolyzer.addRecipe(Ic2Items.waterCell, Ic2Items.electrolyzedWaterCell, 20000, true, true);
    }

    public static void addRecipe(ItemStack input, ItemStack output, int required, boolean doCharge, boolean doDischarge) {
        if (!doCharge && !doDischarge) {
            return;
        }
        energyNeeds.put(TileEntityElectrolyzer.getRecipe(input), required);
        if (doCharge) {
            charge.put(TileEntityElectrolyzer.getRecipe(input), output);
        }
        if (doDischarge) {
            discharge.put(TileEntityElectrolyzer.getRecipe(output), input);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74765_d("energy");
        this.maxEnergy = nbttagcompound.func_74765_d("total");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("energy", this.energy);
        nbttagcompound.func_74777_a("total", this.maxEnergy);
    }

    @Override
    public String func_145825_b() {
        return "Electrolyzer";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        boolean turnActive = false;
        if (this.ticker++ % 16 == 0) {
            this.mfe = this.lookForMFE();
        }
        if (this.mfe == null) {
            return;
        }
        if (this.shouldDrain() && this.canDrain()) {
            needsInvUpdate = this.drain();
            turnActive = true;
        }
        if (this.shouldPower() && (this.canPower() || this.energy > 0)) {
            needsInvUpdate = this.power();
            turnActive = true;
        }
        if (this.getActive() != turnActive) {
            this.setActive(turnActive);
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    public boolean shouldDrain() {
        return this.mfe != null && (double)this.mfe.getStoredPower() / (double)this.mfe.getMaxStorage() >= 0.7;
    }

    public boolean shouldPower() {
        return this.mfe != null && (double)this.mfe.getStoredPower() / (double)this.mfe.getMaxStorage() <= 0.3;
    }

    public boolean canDrain() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemRecipe item = TileEntityElectrolyzer.getRecipe(this.inventory[0]);
        ItemStack result = charge.get(item);
        if (result == null) {
            return false;
        }
        if (energyNeeds.get(item) > this.mfe.getStoredPower()) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(result)) {
            return false;
        }
        return this.inventory[1].field_77994_a + result.field_77994_a <= this.inventory[1].func_77976_d();
    }

    public boolean canPower() {
        if (this.inventory[1] == null) {
            return false;
        }
        ItemRecipe item = TileEntityElectrolyzer.getRecipe(this.inventory[1]);
        ItemStack result = discharge.get(item);
        if (result == null) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(result)) {
            return false;
        }
        return this.inventory[0].field_77994_a + result.field_77994_a <= this.inventory[0].func_77976_d();
    }

    public boolean drain() {
        int req = energyNeeds.get(TileEntityElectrolyzer.getRecipe(this.inventory[0]));
        if (this.maxEnergy != req) {
            this.maxEnergy = (short)req;
            this.getNetwork().updateTileGuiField(this, "maxEnergy");
        }
        IElectrolyzerProvider mfe = this.mfe;
        mfe.drawPower(this.processRate());
        this.energy = (short)(this.energy + (short)this.processRate());
        this.getNetwork().updateTileGuiField(this, "energy");
        if (this.energy >= req) {
            this.energy = (short)(this.energy - req);
            ItemStack result = charge.get(TileEntityElectrolyzer.getRecipe(this.inventory[0])).func_77946_l();
            ItemStack itemStack = this.inventory[0];
            --itemStack.field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            if (this.inventory[1] == null) {
                this.inventory[1] = result;
            } else {
                this.inventory[1].field_77994_a += result.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean power() {
        if (this.energy > 0) {
            int out = this.processRate();
            if (out > this.energy) {
                out = this.energy;
            }
            this.energy = (short)(this.energy - (short)out);
            this.getNetwork().updateTileGuiField(this, "energy");
            IElectrolyzerProvider mfe = this.mfe;
            mfe.addPower(out);
            return false;
        }
        if (this.inventory[1] == null) {
            return false;
        }
        ItemStack result = discharge.get(TileEntityElectrolyzer.getRecipe(this.inventory[1])).func_77946_l();
        if (result == null) {
            return false;
        }
        int totalEnergy = energyNeeds.get(TileEntityElectrolyzer.getRecipe(result));
        int base = (int)((double)totalEnergy / 10.0 * 6.0);
        int extra = (int)((double)totalEnergy / 10.0 * (double)this.mfe.getTier());
        this.energy = (short)(this.energy + (base + extra));
        this.maxEnergy = (short)(base + extra);
        ItemStack itemStack = this.inventory[1];
        --itemStack.field_77994_a;
        this.getNetwork().updateTileGuiField(this, "energy");
        this.getNetwork().updateTileGuiField(this, "maxEnergy");
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
        if (this.inventory[0] == null) {
            this.inventory[0] = result;
        } else {
            this.inventory[0].field_77994_a += result.field_77994_a;
        }
        return true;
    }

    public int processRate() {
        return this.mfe.getProcessRate();
    }

    public IElectrolyzerProvider lookForMFE() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof IElectrolyzerProvider) {
            return (IElectrolyzerProvider)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof IElectrolyzerProvider) {
            return (IElectrolyzerProvider)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof IElectrolyzerProvider) {
            return (IElectrolyzerProvider)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof IElectrolyzerProvider) {
            return (IElectrolyzerProvider)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof IElectrolyzerProvider) {
            return (IElectrolyzerProvider)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof IElectrolyzerProvider) {
            return (IElectrolyzerProvider)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        }
        return null;
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 20000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectrolyzer(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiElectrolyzer";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    private static ItemRecipe getRecipe(ItemStack par1) {
        return new ItemRecipe(par1);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (itemstack == null) {
            return false;
        }
        if (i == 0) {
            return charge.containsKey(TileEntityElectrolyzer.getRecipe(itemstack));
        }
        if (i == 1) {
            return discharge.containsKey(TileEntityElectrolyzer.getRecipe(itemstack));
        }
        return false;
    }

    @Override
    public int getStoredEnergy() {
        return this.energy;
    }

    @Override
    public int getEnergyCapacity() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyUsage() {
        return this.getSpeed();
    }

    @Override
    public int getEnergyProduction() {
        return this.getSpeed();
    }

    public int getSpeed() {
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.mfe = this.lookForMFE();
        }
        return this.mfe != null ? this.mfe.getProcessRate() : 0;
    }

    @Override
    public int getMaxEnergyInput() {
        return 0;
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active")) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/ElectrolyzerLoop.ogg", true, true, IC2.audioManager.defaultVolume);
            }
            if (this.audioSource != null) {
                if (this.getActive()) {
                    this.audioSource.play();
                } else {
                    this.audioSource.pause();
                }
            }
        }
        super.onNetworkUpdate(field);
    }

    public static class ItemRecipe {
        final Item item;
        final int meta;

        public ItemRecipe(ItemStack par1) {
            this(par1.func_77973_b(), par1.func_77960_j());
        }

        public ItemRecipe(Item par1, int par2) {
            this.item = par1;
            this.meta = par2;
        }

        public boolean equals(Object arg0) {
            if (!(arg0 instanceof ItemRecipe)) {
                return false;
            }
            ItemRecipe item = (ItemRecipe)arg0;
            return item.item == this.item && item.meta == this.meta;
        }

        public int hashCode() {
            return this.item.hashCode() + this.meta;
        }

        public String toString() {
            String a = "Name: " + new ItemStack(this.item, 1, this.meta).func_77977_a();
            String b = "Data: " + Item.func_150891_b((Item)this.item) + ":" + this.meta;
            return b + " " + a;
        }

        public ItemStack toItem() {
            return new ItemStack(this.item, 1, this.meta);
        }
    }
}

