/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.RecipeOutput;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.tileentity.TileEntityAdvancedMachine;
import ic2.core.block.machine.tileentity.TileEntityElecFurnace;
import ic2.core.slot.SlotDischarge;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class TileEntityInduction
extends TileEntityAdvancedMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(64);
    private static int inputSlot = 1;
    private static int fuelSlot = 0;
    private static int outputSlot = 3;

    public TileEntityInduction() {
        super(5, 15, 4000);
    }

    @Override
    public String func_145825_b() {
        if (this.isRendering()) {
            return "Induction Furnace";
        }
        return "InductionFurnace";
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiInduction";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int[] func_94128_d(int var1) {
        return new int[]{1, 2, 3, 4};
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public RecipeOutput getResultFor(ItemStack input, boolean adjusted) {
        if (input == null || FurnaceRecipes.func_77602_a().func_151395_a(input) == null) {
            return null;
        }
        if (adjusted) {
            --input.field_77994_a;
        }
        return new RecipeOutput(null, FurnaceRecipes.func_77602_a().func_151395_a(input).func_77946_l());
    }

    @Override
    public RecipeOutput getOutput() {
        RecipeOutput output = this.getOutput(1);
        if (output == null) {
            output = this.getOutput(2);
        }
        return output;
    }

    @Override
    public Slot[] getInvSlots(InventoryPlayer par2) {
        Slot[] slots = new Slot[]{new SlotDischarge(this, this.tier, 0, 56, 53), new Slot((IInventory)this, 1, 47, 17), new Slot((IInventory)this, 2, 63, 17), new SlotFurnace(par2.field_70458_d, (IInventory)this, 3, 113, 35), new SlotFurnace(par2.field_70458_d, (IInventory)this, 4, 131, 35)};
        return slots;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{3, 4};
    }

    @Override
    public boolean isInputSlot(int slotID) {
        return slotID == 1 || slotID == 2;
    }

    @Override
    public boolean isOutputSlot(int slotID) {
        return slotID == 3 || slotID == 4;
    }

    @Override
    public void operate() {
        this.operate(1, 2);
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/Induction Furnace/InductionLoop.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 != null && FurnaceRecipes.func_77602_a().func_151395_a(par1) != null) {
            if (this.inventory[1] == null || this.inventory[1].func_77969_a(par1) && ItemStack.func_77970_a((ItemStack)this.inventory[1], (ItemStack)par1)) {
                return true;
            }
            if (this.inventory[2] == null || this.inventory[2].func_77969_a(par1) && ItemStack.func_77970_a((ItemStack)this.inventory[2], (ItemStack)par1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public IMachineRecipeManager getRecipeList() {
        return TileEntityElecFurnace.recipes;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.getActive() != this.prevActive) {
            if (this.getActive()) {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/Induction Furnace/InductionStart.ogg", true, IC2.audioManager.defaultVolume * this.soundLevel);
            } else {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/Induction Furnace/InductionStop.ogg", true, IC2.audioManager.defaultVolume * this.soundLevel);
            }
        }
        super.onNetworkUpdate(field);
    }
}

