/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMiningDrill;
import ic2.api.item.IScannerItem;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.container.ContainerMiner;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;

public class TileEntityMiner
extends TileEntityElecMachine
implements IHasGui {
    public static ForgeDirection[] validDirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    public int targetX = 0;
    public int targetY = -1;
    public int targetZ = 0;
    public int currentX = 0;
    public int currentY = 0;
    public int currentZ = 0;
    public short miningTicker = 0;
    public String stuckOn = null;
    private AudioSource audioSource;

    public TileEntityMiner() {
        super(4, 0, 1000, 32, IC2.enableMinerLapotron ? 3 : 1);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean wasOperating = this.isOperating();
        boolean needsInvUpdate = false;
        if (this.isOperating()) {
            this.useEnergy(1);
            if (this.inventory[1] != null && this.inventory[1].func_77973_b() instanceof IElectricItem) {
                this.energy = (int)((double)this.energy - ElectricItem.manager.charge(this.inventory[1], this.energy, 2, false, false));
            }
            if (this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IElectricItem) {
                this.energy = (int)((double)this.energy - ElectricItem.manager.charge(this.inventory[3], this.energy, 2, false, false));
            }
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (wasOperating) {
            needsInvUpdate = this.mine();
        } else if (this.inventory[3] == null) {
            if (this.energy >= 2 && this.canWithdraw()) {
                this.targetY = -1;
                this.miningTicker = (short)(this.miningTicker + 1);
                this.useEnergy(2);
                if (this.miningTicker >= 20) {
                    this.miningTicker = 0;
                    needsInvUpdate = this.withdrawPipe();
                }
            } else if (this.isStuck()) {
                this.miningTicker = 0;
            }
        }
        this.setActive(this.isOperating());
        if (wasOperating != this.isOperating()) {
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
        this.miningTicker = nbttagcompound.func_74765_d("miningTicker");
        this.currentX = nbttagcompound.func_74762_e("currentX");
        this.currentY = nbttagcompound.func_74762_e("currentY");
        this.currentZ = nbttagcompound.func_74762_e("currentZ");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("targetX", this.targetX);
        nbttagcompound.func_74768_a("targetY", this.targetY);
        nbttagcompound.func_74768_a("targetZ", this.targetZ);
        nbttagcompound.func_74777_a("miningTicker", this.miningTicker);
        nbttagcompound.func_74768_a("currentX", this.currentX);
        nbttagcompound.func_74768_a("currentY", this.currentY);
        nbttagcompound.func_74768_a("currentZ", this.currentZ);
    }

    public boolean mine() {
        if (this.targetY < 0) {
            this.aquireTarget();
            return false;
        }
        boolean forcedTickSkip = false;
        while (!this.canReachTarget(this.currentX, this.currentY, this.currentZ, true)) {
            int x = this.currentX - this.field_145851_c;
            int z = this.currentZ - this.field_145849_e;
            if (Math.abs(x) > Math.abs(z)) {
                this.currentX = x > 0 ? --this.currentX : ++this.currentX;
            } else {
                this.currentZ = z > 0 ? --this.currentZ : ++this.currentZ;
            }
            forcedTickSkip = true;
        }
        if (forcedTickSkip) {
            return false;
        }
        if (!this.canMine(this.currentX, this.currentY, this.currentZ)) {
            Block id = this.field_145850_b.func_147439_a(this.currentX, this.currentY, this.currentZ);
            if ((id == Blocks.field_150358_i || id == Blocks.field_150355_j || id == Blocks.field_150356_k || id == Blocks.field_150353_l) && this.isAnyPumpConnected()) {
                return false;
            }
            this.miningTicker = (short)-1;
            this.stuckOn = id.func_149739_a();
            return false;
        }
        this.stuckOn = null;
        this.miningTicker = (short)(this.miningTicker + 1);
        --this.energy;
        IMiningDrill drill = (IMiningDrill)this.inventory[3].func_77973_b();
        if (!drill.isBasicDrill(this.inventory[3])) {
            this.miningTicker = (short)(this.miningTicker + drill.getExtraSpeed(this.inventory[3]));
            this.energy -= drill.getExtraEnergyCost(this.inventory[3]);
        }
        if (this.miningTicker >= 200) {
            this.miningTicker = 0;
            this.mineBlock();
            return true;
        }
        return false;
    }

    public boolean isValueableOre(int x, int y, int z) {
        ItemStack stack = this.inventory[1];
        if (stack == null) {
            return false;
        }
        IScannerItem item = (IScannerItem)stack.func_77973_b();
        return item.isValuableOre(stack, this.field_145850_b.func_147439_a(x, y, z), this.field_145850_b.func_72805_g(x, y, z));
    }

    public void mineBlock() {
        if (this.inventory[3].func_77973_b() instanceof IMiningDrill) {
            ((IMiningDrill)this.inventory[3].func_77973_b()).useDrill(this.inventory[3]);
        }
        Block id = this.field_145850_b.func_147439_a(this.currentX, this.currentY, this.currentZ);
        int meta = this.field_145850_b.func_72805_g(this.currentX, this.currentY, this.currentZ);
        boolean liquid = false;
        if (id == Blocks.field_150358_i || id == Blocks.field_150355_j || id == Blocks.field_150356_k || id == Blocks.field_150353_l) {
            liquid = true;
            if (meta != 0) {
                id = null;
            }
        }
        if (!this.field_145850_b.func_147437_c(this.currentX, this.currentY, this.currentZ)) {
            if (!liquid) {
                Block ore = id;
                if (this.hasEnchantment(this.inventory[3], Enchantment.field_77348_q) && ore.canSilkHarvest(this.func_145831_w(), (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w())), this.currentX, this.currentY, this.currentZ, meta)) {
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    ItemStack stack = this.createStackedBlock(ore, meta);
                    if (stack != null) {
                        drops.add(stack);
                    }
                    ForgeEventFactory.fireBlockHarvesting(drops, (World)this.func_145831_w(), (Block)ore, (int)this.currentX, (int)this.currentY, (int)this.currentZ, (int)meta, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w())));
                    StackUtil.distributeDrop(this, drops);
                } else {
                    int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)this.inventory[3]);
                    ArrayList drops = ore.getDrops(this.field_145850_b, this.currentX, this.currentY, this.currentZ, meta, fortune);
                    ForgeEventFactory.fireBlockHarvesting((ArrayList)drops, (World)this.func_145831_w(), (Block)ore, (int)this.currentX, (int)this.currentY, (int)this.currentZ, (int)meta, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w())));
                    StackUtil.distributeDrop(this, drops);
                }
            } else {
                if (id == Blocks.field_150358_i || id == Blocks.field_150355_j) {
                    this.usePump(Blocks.field_150355_j);
                }
                if (id == Blocks.field_150356_k || id == Blocks.field_150353_l) {
                    this.usePump(Blocks.field_150353_l);
                }
            }
            this.field_145850_b.func_147468_f(this.currentX, this.currentY, this.currentZ);
            this.energy -= 2 * (this.field_145848_d - this.currentY);
        }
        if (this.currentX == this.field_145851_c && this.currentZ == this.field_145849_e) {
            this.field_145850_b.func_147449_b(this.currentX, this.currentY, this.currentZ, Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()));
            if (this.inventory[2].field_77994_a == 0) {
                this.inventory[2] = null;
            }
            this.energy -= 10;
        }
        this.updateMineTip(this.currentY);
        if (this.currentX == this.targetX && this.currentY == this.targetY && this.currentZ == this.targetZ || this.field_145850_b.func_147437_c(this.targetX, this.targetY, this.targetZ) || !this.isValueableOre(this.targetX, this.targetY, this.targetZ)) {
            this.targetY = -1;
        } else {
            this.currentX = this.targetX;
            this.currentY = this.targetY;
            this.currentZ = this.targetZ;
        }
    }

    private ItemStack createStackedBlock(Block ore, int meta) {
        Item item;
        int resultMeta = 0;
        if (ore != null && (item = Item.func_150898_a((Block)ore)) != null && item.func_77614_k()) {
            resultMeta = meta;
        }
        return new ItemStack(ore, 1, resultMeta);
    }

    private boolean hasEnchantment(ItemStack itemStack, Enchantment ench) {
        NBTTagList list = itemStack.func_77986_q();
        boolean flag = false;
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                short id = data.func_74765_d("id");
                if (id != ench.field_77352_x) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public boolean withdrawPipe() {
        int y = this.getPipeTip();
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        if (!this.field_145850_b.func_147437_c(this.field_145851_c, y, this.field_145849_e)) {
            // empty if block
        }
        if (this.field_145848_d - y > 1) {
            StackUtil.distributeDrop(this, block.getDrops(this.field_145850_b, this.field_145851_c, y, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, y, this.field_145849_e), 0));
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, y, this.field_145849_e);
        if (this.inventory[2] != null && this.inventory[2].func_77973_b() != Ic2Items.miningPipe.func_77973_b() && Block.func_149634_a((Item)this.inventory[2].func_77973_b()) != Blocks.field_150350_a) {
            this.field_145850_b.func_147465_d(this.field_145851_c, y, this.field_145849_e, Block.func_149634_a((Item)this.inventory[2].func_77973_b()), this.inventory[2].func_77960_j(), 3);
            ItemStack itemStack = this.inventory[2];
            --itemStack.field_77994_a;
            if (this.inventory[2].field_77994_a == 0) {
                this.inventory[2] = null;
            }
            this.updateMineTip(y + 1);
            return true;
        }
        this.updateMineTip(y + 1);
        return false;
    }

    public void updateMineTip(int low) {
        if (low == this.field_145848_d) {
            return;
        }
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        for (int y = this.field_145848_d - 1; y > low; --y) {
            Block id = this.field_145850_b.func_147439_a(x, y, z);
            if (id == Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()) || this.inventory[2] == null || this.inventory[2].field_77994_a <= 0) continue;
            this.field_145850_b.func_147449_b(x, y, z, Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()));
            ItemStack itemStack = this.inventory[2];
            --itemStack.field_77994_a;
            if (this.inventory[2].field_77994_a > 0) continue;
            this.inventory[2] = null;
        }
        this.field_145850_b.func_147449_b(x, low, z, Block.func_149634_a((Item)Ic2Items.miningPipeTip.func_77973_b()));
    }

    public boolean canReachTarget(int x, int y, int z, boolean ignore) {
        if (this.field_145851_c == x && this.field_145849_e == z) {
            return true;
        }
        if (!(ignore || this.canPass(this.field_145850_b.func_147439_a(x, y, z)) || this.field_145850_b.func_147437_c(x, y, z))) {
            return false;
        }
        int xdif = x - this.field_145851_c;
        int zdif = z - this.field_145849_e;
        if (Math.abs(xdif) > Math.abs(zdif)) {
            x = xdif > 0 ? --x : ++x;
        } else {
            z = zdif > 0 ? --z : ++z;
        }
        return this.canReachTarget(x, y, z, false);
    }

    public void aquireTarget() {
        int y = this.getPipeTip();
        if (y >= this.field_145848_d || this.inventory[1] == null || !(this.inventory[1].func_77973_b() instanceof IScannerItem)) {
            this.setTarget(this.field_145851_c, y - 1, this.field_145849_e);
            return;
        }
        IScannerItem item = (IScannerItem)this.inventory[1].func_77973_b();
        int scanrange = item.startLayerScan(this.inventory[1]);
        if (scanrange > 0) {
            int minX = this.field_145851_c - scanrange;
            int maxX = this.field_145851_c + scanrange;
            int minZ = this.field_145849_e - scanrange;
            int maxZ = this.field_145849_e + scanrange;
            HashSet<ChunkCoordinates> visited = new HashSet<ChunkCoordinates>();
            ArrayList<ChunkCoordinates> toCheck = new ArrayList<ChunkCoordinates>();
            visited.add(new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            toCheck.addAll(this.getAroundCoords(new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e)));
            Collections.shuffle(toCheck);
            while (!toCheck.isEmpty()) {
                ChunkCoordinates coords = (ChunkCoordinates)toCheck.remove(0);
                int x = coords.field_71574_a;
                int z = coords.field_71573_c;
                if (visited.contains(coords) || x < minX || x > maxX || z < minZ || z > maxZ) continue;
                visited.add(coords);
                if (!this.canMine(x, y, z)) continue;
                Block n = this.field_145850_b.func_147439_a(x, y, z);
                int m = this.field_145850_b.func_72805_g(x, y, z);
                if (this.isAnyPumpConnected() && this.field_145850_b.func_72805_g(x, y, z) == 0 && (n == Blocks.field_150356_k || n == Blocks.field_150353_l)) {
                    this.setTarget(x, y, z);
                    return;
                }
                if (item.isValuableOre(this.inventory[1], n, m)) {
                    this.setTarget(x, y, z);
                    return;
                }
                toCheck.addAll(this.getAroundCoords(coords));
            }
        }
        this.setTarget(this.field_145851_c, y - 1, this.field_145849_e);
    }

    public List<ChunkCoordinates> getAroundCoords(ChunkCoordinates par1) {
        ArrayList<ChunkCoordinates> result = new ArrayList<ChunkCoordinates>();
        for (ForgeDirection dir : validDirs) {
            result.add(new ChunkCoordinates(par1.field_71574_a + dir.offsetX, par1.field_71572_b + dir.offsetY, par1.field_71573_c + dir.offsetZ));
        }
        return result;
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.currentX = x;
        this.currentY = y;
        this.currentZ = z;
    }

    public int getPipeTip() {
        int y = this.field_145848_d;
        while (this.field_145850_b.func_147439_a(this.field_145851_c, y - 1, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()) || this.field_145850_b.func_147439_a(this.field_145851_c, y - 1, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.miningPipeTip.func_77973_b())) {
            --y;
        }
        return y;
    }

    public boolean canPass(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_150358_i || block == Blocks.field_150355_j || block == Blocks.field_150356_k || block == Blocks.field_150353_l || block == Block.func_149634_a((Item)Ic2Items.miner.func_77973_b()) || block == Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()) || block == Block.func_149634_a((Item)Ic2Items.miningPipeTip.func_77973_b());
    }

    public boolean isOperating() {
        return this.energy > 100 && this.canOperate();
    }

    public boolean canOperate() {
        return this.inventory[2] != null && this.inventory[3] != null && this.inventory[2].func_77973_b() == Ic2Items.miningPipe.func_77973_b() && this.canMiningDrillBeUsed() && !this.isStuck();
    }

    public boolean canMiningDrillBeUsed() {
        if (!(this.inventory[3].func_77973_b() instanceof IMiningDrill)) {
            return false;
        }
        IMiningDrill drill = (IMiningDrill)this.inventory[3].func_77973_b();
        if (!drill.canMine(this.inventory[3])) {
            if (!(drill instanceof IElectricItem)) {
                return false;
            }
            IElectricItem item = (IElectricItem)((Object)drill);
            if (item.getMaxCharge(this.inventory[3]) == 0.0 || item.getTransferLimit(this.inventory[3]) == 0.0) {
                return false;
            }
        }
        return true;
    }

    public boolean isStuck() {
        return this.miningTicker < 0;
    }

    public String getStuckOn() {
        return this.stuckOn;
    }

    public boolean canMine(int x, int y, int z) {
        Block id = this.field_145850_b.func_147439_a(x, y, z);
        int meta = this.field_145850_b.func_72805_g(x, y, z);
        if (this.field_145850_b.func_147437_c(x, y, z)) {
            return this.canMineEvent(x, y, z, id, meta);
        }
        if (id == Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()) || id == Block.func_149634_a((Item)Ic2Items.miningPipeTip.func_77973_b()) || id == Blocks.field_150486_ae) {
            return false;
        }
        if ((id == Blocks.field_150358_i || id == Blocks.field_150355_j || id == Blocks.field_150356_k || id == Blocks.field_150353_l) && this.isPumpConnected()) {
            return this.canMineEvent(x, y, z, id, meta);
        }
        Block block = id;
        if (block.func_149712_f(this.field_145850_b, x, y, z) < 0.0f) {
            return false;
        }
        if (block.func_149678_a(meta, false) && block.func_149688_o().func_76229_l()) {
            return this.canMineEvent(x, y, z, block, meta);
        }
        if (id == Blocks.field_150321_G) {
            return this.canMineEvent(x, y, z, block, meta);
        }
        if (this.inventory[3] != null) {
            if (!ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)this.inventory[3]) && !this.inventory[3].func_150998_b(block)) {
                return false;
            }
            return this.canMineEvent(x, y, z, block, meta);
        }
        return false;
    }

    public boolean canMineEvent(int x, int y, int z, Block block, int meta) {
        BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(x, y, z, this.field_145850_b, block, meta, (EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.field_145850_b)));
        evt.setExpToDrop(0);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public boolean canWithdraw() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.miningPipe.func_77973_b()) || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Block.func_149634_a((Item)Ic2Items.miningPipeTip.func_77973_b());
    }

    public boolean isPumpConnected() {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).canHarvest() || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).canHarvest() || this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).canHarvest() || this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).canHarvest() || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).canHarvest() || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).canHarvest();
    }

    public boolean isAnyPumpConnected() {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityPump || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump || this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump || this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump || this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump;
    }

    public void usePump(Block water) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).pumpThis(water);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).pumpThis(water);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).pumpThis(water);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).pumpThis(water);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).pumpThis(water);
            return;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump && ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).canHarvest()) {
            ((TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).pumpThis(water);
        }
    }

    @Override
    public String func_145825_b() {
        return "Miner";
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 1000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerMiner(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiMiner";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
        if (this.stuckOn != null) {
            entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("Is Stuck on: " + this.stuckOn + " Coords: x" + this.currentX + " y:" + this.currentY + " z:" + this.currentZ));
        }
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource != null && this.audioSource.isRemoved()) {
                this.audioSource = null;
            }
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/MinerOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public int[] func_94128_d(int side) {
        ForgeDirection leftSide = null;
        ForgeDirection rightSide = null;
        ForgeDirection frontSide = null;
        ForgeDirection backSide = null;
        switch (this.getFacing()) {
            case 2: {
                leftSide = ForgeDirection.WEST;
                rightSide = ForgeDirection.EAST;
                frontSide = ForgeDirection.SOUTH;
                backSide = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                leftSide = ForgeDirection.EAST;
                rightSide = ForgeDirection.WEST;
                frontSide = ForgeDirection.NORTH;
                backSide = ForgeDirection.SOUTH;
                break;
            }
            case 4: {
                leftSide = ForgeDirection.SOUTH;
                rightSide = ForgeDirection.NORTH;
                frontSide = ForgeDirection.EAST;
                backSide = ForgeDirection.WEST;
                break;
            }
            default: {
                leftSide = ForgeDirection.NORTH;
                rightSide = ForgeDirection.SOUTH;
                frontSide = ForgeDirection.WEST;
                backSide = ForgeDirection.EAST;
            }
        }
        if (side == leftSide.ordinal() || side == frontSide.ordinal()) {
            return new int[]{3};
        }
        if (side == rightSide.ordinal() || side == backSide.ordinal()) {
            return new int[]{1};
        }
        if (side == 0) {
            return new int[]{0};
        }
        return new int[]{2};
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public int getEnergyUsage() {
        return 1 + (this.inventory[3] != null && this.inventory[3].func_77973_b() instanceof IMiningDrill ? ((IMiningDrill)this.inventory[3].func_77973_b()).getExtraEnergyCost(this.inventory[3]) : 0);
    }
}

