/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IScannerItem;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.container.ContainerOreScanner;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.block.machine.tileentity.TileEntityElectrolyzer;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityOreScanner
extends TileEntityElecMachine
implements IHasGui,
INetworkClientTileEntityEventListener {
    public int range;
    public int currentX;
    public int currentZ;
    public int maxBlocks;
    public int currentBlocks;
    public boolean reset;
    public boolean started;
    public boolean finished;
    public long scannerID = -1L;
    public int state = -1;
    Map<Block, Map<Integer, Integer>> oresMap = new HashMap<Block, Map<Integer, Integer>>();
    public OreInventory inv = new OreInventory();
    public NBTTagCompound oreData = new NBTTagCompound();

    public TileEntityOreScanner() {
        super(2, 0, 50000, 128, 2);
        this.addGuiFields("finished", "maxBlocks", "currentBlocks", "oreData", "state");
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    @Override
    public String func_145825_b() {
        return "OreScanner";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.energy < this.maxEnergy && this.inventory[0] != null) {
            this.provideEnergy();
        }
        if (!this.canRun()) {
            this.onChanged();
            return;
        }
        if (this.inventory[1].func_77973_b() instanceof IElectricItem) {
            int moved = (int)ElectricItem.manager.charge(this.inventory[1], this.energy, Integer.MAX_VALUE, false, false);
            this.useEnergy(moved);
            if (moved > 0) {
                return;
            }
        }
        if (this.hasChanged()) {
            this.onChanged();
        }
        if (this.finished) {
            return;
        }
        if (!this.started) {
            this.started = true;
            this.restart();
            return;
        }
        this.work();
    }

    public void work() {
        IScannerItem item = (IScannerItem)this.inventory[1].func_77973_b();
        for (int i = 0; i < 4 && this.energy >= this.field_145848_d && !this.finished; ++i) {
            this.scanArea(item, this.currentX, this.currentZ);
            ++this.currentX;
            if (this.currentX > this.field_145851_c + this.range) {
                this.currentX = this.field_145851_c - this.range;
                ++this.currentZ;
                if (this.currentZ > this.field_145849_e + this.range) {
                    this.finished = true;
                    this.onFinish();
                }
            }
            this.useEnergy(this.field_145848_d);
        }
    }

    public void onFinish() {
        HashMap<ItemStack, Integer> items = new HashMap<ItemStack, Integer>();
        for (Map.Entry<Block, Map<Integer, Integer>> entry : this.oresMap.entrySet()) {
            Block block = entry.getKey();
            if (Item.func_150898_a((Block)block) == null) continue;
            Map<Integer, Integer> value = entry.getValue();
            for (Map.Entry<Integer, Integer> data : value.entrySet()) {
                items.put(new ItemStack(block, 0, data.getKey().intValue()), data.getValue());
            }
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : items.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            ((ItemStack)entry.getKey()).func_77955_b(data);
            data.func_74768_a("amount", ((Integer)entry.getValue()).intValue());
            list.func_74742_a((NBTBase)data);
        }
        this.oreData.func_74782_a("Items", (NBTBase)list);
        this.inv.readOreData(this.oreData);
        this.finished = true;
        this.started = false;
        this.reset = false;
        this.state = 0;
        this.getNetwork().updateTileGuiField(this, "oreData");
        this.getNetwork().updateTileGuiField(this, "finished");
        this.getNetwork().updateTileGuiField(this, "state");
    }

    public void scanArea(IScannerItem item, int x, int z) {
        for (int y = 0; y < this.field_145848_d; ++y) {
            Map<Integer, Integer> map;
            int meta;
            ++this.currentBlocks;
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (!item.isValuableOre(this.inventory[1], block, meta = this.field_145850_b.func_72805_g(x, y, z))) continue;
            if (!this.oresMap.containsKey(block)) {
                this.oresMap.put(block, new HashMap());
            }
            if (!(map = this.oresMap.get(block)).containsKey(meta)) {
                map.put(meta, 1);
            } else {
                map.put(meta, map.get(meta) + 1);
            }
            this.oresMap.put(block, map);
        }
        this.getNetwork().updateTileGuiField(this, "currentBlocks");
    }

    public void onChanged() {
        if (this.finished && this.inventory[1] != null) {
            this.started = false;
            this.reset = true;
            this.finished = false;
            this.getNetwork().updateTileGuiField(this, "finished");
        }
        if (this.started) {
            this.started = false;
            this.reset = true;
        }
        if (this.reset) {
            this.reset = false;
            this.maxBlocks = 0;
            this.currentBlocks = 0;
            this.range = 0;
            this.state = 0;
            this.scannerID = -1L;
            this.oresMap.clear();
            this.inv.clear();
            this.oreData = new NBTTagCompound();
            this.getNetwork().updateTileGuiField(this, "oreData");
            this.getNetwork().updateTileGuiField(this, "maxBlocks");
            this.getNetwork().updateTileGuiField(this, "currentBlocks");
            this.getNetwork().updateTileGuiField(this, "state");
        }
    }

    public void restart() {
        int totalBlocks;
        int newRange;
        IScannerItem item = (IScannerItem)this.inventory[1].func_77973_b();
        this.range = newRange = item.startLayerScan(this.inventory[1]);
        newRange *= 2;
        int blocksXZ = ++newRange * newRange;
        this.maxBlocks = totalBlocks = blocksXZ * this.field_145848_d;
        this.getNetwork().updateTileGuiField(this, "maxBlocks");
        this.setScannerID(this.inventory[1]);
        this.scannerID = this.getScannerID(this.inventory[1]);
        this.currentX = this.field_145851_c - this.range;
        this.currentZ = this.field_145849_e - this.range;
    }

    public boolean hasChanged() {
        if (this.scannerID == -1L || !this.hasScannerID(this.inventory[1])) {
            return true;
        }
        return this.scannerID != this.getScannerID(this.inventory[1]);
    }

    public boolean canRun() {
        if (this.inventory[1] == null) {
            return false;
        }
        return this.inventory[1].func_77973_b() instanceof IScannerItem;
    }

    public void setScannerID(ItemStack par1) {
        if (par1 == null) {
            return;
        }
        StackUtil.getOrCreateNbtData(par1).func_74772_a("ScannerID", System.currentTimeMillis());
    }

    public boolean hasScannerID(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        return StackUtil.getOrCreateNbtData(par1).func_74764_b("ScannerID");
    }

    public long getScannerID(ItemStack par1) {
        if (par1 == null) {
            return -1L;
        }
        return StackUtil.getOrCreateNbtData(par1).func_74763_f("ScannerID");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.started = nbttagcompound.func_74767_n("Started");
        this.reset = nbttagcompound.func_74767_n("Reset");
        this.finished = nbttagcompound.func_74767_n("Finished");
        this.currentBlocks = nbttagcompound.func_74762_e("currentBlocks");
        this.currentX = nbttagcompound.func_74762_e("StateX");
        this.currentZ = nbttagcompound.func_74762_e("StateZ");
        this.maxBlocks = nbttagcompound.func_74762_e("Max");
        this.range = nbttagcompound.func_74762_e("Range");
        this.state = nbttagcompound.func_74762_e("state");
        this.oresMap.clear();
        NBTTagList list = nbttagcompound.func_150295_c("OreValues", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            Block block = Block.func_149684_b((String)nbt.func_74779_i("BlockID"));
            NBTTagList metaList = nbt.func_150295_c("MetaValue", 10);
            HashMap<Integer, Integer> metaMap = new HashMap<Integer, Integer>();
            for (int z = 0; z < metaList.func_74745_c(); ++z) {
                NBTTagCompound data = metaList.func_150305_b(z);
                metaMap.put(data.func_74762_e("MetaData"), data.func_74762_e("Count"));
            }
            this.oresMap.put(block, metaMap);
        }
        this.inv.clear();
        this.oreData = nbttagcompound.func_74775_l("OreData");
        this.inv.readOreData(this.oreData);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("Started", this.started);
        nbttagcompound.func_74757_a("Reset", this.reset);
        nbttagcompound.func_74757_a("Finished", this.finished);
        nbttagcompound.func_74768_a("currentBlocks", this.currentBlocks);
        nbttagcompound.func_74768_a("StateX", this.currentX);
        nbttagcompound.func_74768_a("StateZ", this.currentZ);
        nbttagcompound.func_74768_a("Max", this.maxBlocks);
        nbttagcompound.func_74768_a("Range", this.range);
        nbttagcompound.func_74768_a("state", this.state);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Block, Map<Integer, Integer>> maps : this.oresMap.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            String id = Block.field_149771_c.func_148750_c((Object)maps.getKey());
            data.func_74778_a("BlockID", id);
            NBTTagList metaAndStack = new NBTTagList();
            for (Map.Entry<Integer, Integer> meta : maps.getValue().entrySet()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("MetaData", meta.getKey().intValue());
                nbt.func_74768_a("Count", meta.getValue().intValue());
                metaAndStack.func_74742_a((NBTBase)nbt);
            }
            data.func_74782_a("MetaValue", (NBTBase)metaAndStack);
            list.func_74742_a((NBTBase)data);
        }
        nbttagcompound.func_74782_a("OreValues", (NBTBase)list);
        nbttagcompound.func_74782_a("OreData", (NBTBase)this.oreData);
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("oreData")) {
            this.inv.readOreData(this.oreData);
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerOreScanner(p0.field_71071_by, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiOreScanner";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == -1 || event == 1) {
            this.state += event;
            if (this.state < 0) {
                this.state = 0;
            } else if (event > 0 && this.state > this.inv.func_70302_i_() / 5) {
                --this.state;
            }
            this.getNetwork().updateTileGuiField(this, "state");
            this.getNetwork().updateTileGuiField(this, "oreData");
        } else if (event == 0) {
            this.scannerID = -1L;
        }
    }

    @Override
    public int getEnergyUsage() {
        return this.field_145848_d * 4;
    }

    public class OreInventory
    implements IInventory {
        ItemStack[] items = new ItemStack[0];
        Map<TileEntityElectrolyzer.ItemRecipe, Integer> sizes = new HashMap<TileEntityElectrolyzer.ItemRecipe, Integer>();

        public int func_70302_i_() {
            return this.items.length;
        }

        public int getSize(ItemStack par1) {
            if (par1 == null) {
                return 0;
            }
            TileEntityElectrolyzer.ItemRecipe recipe = new TileEntityElectrolyzer.ItemRecipe(par1);
            if (this.sizes.containsKey(recipe)) {
                return this.sizes.get(recipe);
            }
            return 0;
        }

        public ItemStack func_70301_a(int par1) {
            if ((par1 += TileEntityOreScanner.this.state * 5) >= this.items.length || par1 < 0) {
                return null;
            }
            return this.items[par1];
        }

        public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
            return null;
        }

        public ItemStack func_70304_b(int par1) {
            return this.func_70301_a(par1);
        }

        public void func_70299_a(int par1, ItemStack par2) {
            if ((par1 += TileEntityOreScanner.this.state * 5) >= this.items.length || par1 < 0) {
                return;
            }
            this.items[par1] = par2;
        }

        public String func_145825_b() {
            return null;
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 0;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer p_70300_1_) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
            return false;
        }

        public void clear() {
            this.sizes.clear();
            this.items = new ItemStack[0];
        }

        public void readOreData(NBTTagCompound nbt) {
            ArrayList<ItemStack> array = new ArrayList<ItemStack>();
            NBTTagList list = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)data);
                int amount = data.func_74762_e("amount");
                array.add(stack);
                this.sizes.put(new TileEntityElectrolyzer.ItemRecipe(stack), amount);
            }
            Collections.sort(array, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack par1, ItemStack par2) {
                    int sizeB;
                    int sizeA = OreInventory.this.getSize(par1);
                    if (sizeA > (sizeB = OreInventory.this.getSize(par2))) {
                        return -1;
                    }
                    if (sizeB > sizeA) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.items = array.toArray(new ItemStack[array.size()]);
        }
    }
}

