/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2.core.block.machine.container.ContainerPump;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityPump
extends TileEntityElecMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(64);
    public short pumpCharge = 0;
    public byte delay = 0;
    private AudioSource audioSource;

    public TileEntityPump() {
        super(2, 1, 200, 32);
        this.addGuiFields("pumpCharge");
    }

    @Override
    public String func_145825_b() {
        return "Pump";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.energy > 0 && !this.isPumpReady()) {
            this.useEnergy(1);
            this.pumpCharge = (short)(this.pumpCharge + 1);
            this.getNetwork().updateTileGuiField(this, "pumpCharge");
        }
        if (this.delay > 0) {
            this.delay = (byte)(this.delay - 1);
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (this.delay <= 0 && this.isPumpReady() && (needsInvUpdate = this.pump())) {
            this.delay = (byte)120;
            this.getNetwork().updateTileGuiField(this, "pumpCharge");
        }
        if (this.getActive() == this.isPumpReady() && this.energy > 0) {
            this.setActive(!this.getActive());
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean pump() {
        Block id;
        if (!this.canHarvest() || !this.isFluidBelow()) {
            return false;
        }
        if ((this.isWaterBelow() || this.isLavaBelow()) && ((id = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) == Blocks.field_150355_j || id == Blocks.field_150353_l) && this.pumpThis(id)) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() == Items.field_151133_ar) {
            FillBucketEvent evt = new FillBucketEvent((EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w())), new ItemStack(Items.field_151133_ar), this.field_145850_b, new MovingObjectPosition(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, 1, Vec3.func_72443_a((double)this.field_145851_c, (double)(this.field_145848_d - 1), (double)this.field_145849_e)));
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (evt.result != null && evt.result.func_77973_b() != Items.field_151133_ar) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.add(evt.result);
                StackUtil.distributeDrop(this, drops);
                ItemStack itemStack = this.inventory[0];
                --itemStack.field_77994_a;
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                this.pumpCharge = 0;
                return true;
            }
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem item = (IFluidContainerItem)this.inventory[0].func_77973_b();
            FluidStack fluid = this.getFluidBelow(false);
            boolean flag = false;
            if (item.fill(this.inventory[0], fluid, false) == fluid.amount) {
                item.fill(this.inventory[0], this.getFluidBelow(true), true);
                flag = true;
                this.pumpCharge = 0;
            }
            if (flag && this.isFull(this.inventory[0], item) || !flag) {
                ArrayList<ItemStack> drops2 = new ArrayList<ItemStack>();
                drops2.add(this.inventory[0].func_77946_l());
                this.inventory[0] = null;
                StackUtil.distributeDrop(this, drops2);
            }
            return flag;
        }
        return false;
    }

    public boolean isFluidBelow() {
        return this.getFluidBelow(false) != null;
    }

    public FluidStack getFluidBelow(boolean drain) {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            return null;
        }
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid == null) {
            return null;
        }
        if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA) {
            if (drain) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            }
            return new FluidStack(fluid, 1000);
        }
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).drain(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, drain);
        }
        return null;
    }

    public boolean isGeoAvaible() {
        return this.isGeoAviable(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) || this.isGeoAviable(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) || this.isGeoAviable(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) || this.isGeoAviable(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) || this.isGeoAviable(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) || this.isGeoAviable(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
    }

    public boolean isGeoAviable(int x, int y, int z) {
        return this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityGeoGenerator;
    }

    public boolean isWaterBelow() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150355_j && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == 0;
    }

    public boolean isLavaBelow() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150353_l && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == 0;
    }

    public boolean pumpThis(Block water) {
        if (water == Blocks.field_150353_l && this.deliverLavaToGeo()) {
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() == Items.field_151133_ar) {
            ItemStack drop = null;
            if (water == Blocks.field_150355_j) {
                drop = new ItemStack(Items.field_151131_as);
            }
            if (water == Blocks.field_150353_l) {
                drop = new ItemStack(Items.field_151129_at);
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(drop);
            StackUtil.distributeDrop(this, drops);
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() == Ic2Items.cell.func_77973_b()) {
            ItemStack drop = null;
            if (water == Blocks.field_150355_j) {
                drop = Ic2Items.waterCell.func_77946_l();
            }
            if (water == Blocks.field_150353_l) {
                drop = Ic2Items.lavaCell.func_77946_l();
            }
            ItemStack itemStack = this.inventory[0];
            --itemStack.field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            ArrayList<ItemStack> drops2 = new ArrayList<ItemStack>();
            drops2.add(drop);
            StackUtil.distributeDrop(this, drops2);
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem item = (IFluidContainerItem)this.inventory[0].func_77973_b();
            FluidStack stack = water == Blocks.field_150355_j ? new FluidStack(FluidRegistry.WATER, 1000) : new FluidStack(FluidRegistry.LAVA, 1000);
            boolean flag = false;
            if (item.fill(this.inventory[0], stack, false) == stack.amount) {
                item.fill(this.inventory[0], stack, true);
                this.pumpCharge = 0;
                flag = true;
            }
            if (flag && this.isFull(this.inventory[0], item) || !flag) {
                ArrayList<ItemStack> drops2 = new ArrayList<ItemStack>();
                drops2.add(this.inventory[0].func_77946_l());
                this.inventory[0] = null;
                StackUtil.distributeDrop(this, drops2);
            }
            return flag;
        }
        this.pumpCharge = 0;
        return this.putInChestBucket(water);
    }

    private boolean isFull(ItemStack par1, IFluidContainerItem par2) {
        if (par2.getFluid(par1) == null) {
            return false;
        }
        return par2.getFluid((ItemStack)par1).amount >= par2.getCapacity(par1);
    }

    public boolean putInChestBucket(Block water) {
        return this.putInChestBucket(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, water) || this.putInChestBucket(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, water) || this.putInChestBucket(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, water) || this.putInChestBucket(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, water) || this.putInChestBucket(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, water) || this.putInChestBucket(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, water);
    }

    public boolean putInChestBucket(int x, int y, int z, Block water) {
        if (!(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityChest)) {
            return false;
        }
        TileEntityChest chest = (TileEntityChest)this.field_145850_b.func_147438_o(x, y, z);
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i) == null || chest.func_70301_a(i).func_77973_b() != Items.field_151133_ar) continue;
            if (water == Blocks.field_150355_j) {
                chest.func_70301_a(i).func_150996_a(Items.field_151131_as);
            }
            if (water == Blocks.field_150353_l) {
                chest.func_70301_a(i).func_150996_a(Items.field_151129_at);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.pumpCharge = nbttagcompound.func_74765_d("pumpCharge");
        this.delay = nbttagcompound.func_74771_c("Delay");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("pumpCharge", this.pumpCharge);
        nbttagcompound.func_74774_a("Delay", this.delay);
    }

    public boolean isPumpReady() {
        return this.pumpCharge >= 200;
    }

    public boolean canHarvest() {
        return this.isPumpReady() && (this.inventory[0] != null && (this.inventory[0].func_77973_b() == Ic2Items.cell.func_77973_b() || this.inventory[0].func_77973_b() == Items.field_151133_ar || this.inventory[0].func_77973_b() instanceof IFluidContainerItem) || this.isBucketInChestAvaible() || this.isGeoAvaible());
    }

    public boolean isBucketInChestAvaible() {
        return this.isBucketInChestAvaible(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) || this.isBucketInChestAvaible(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) || this.isBucketInChestAvaible(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) || this.isBucketInChestAvaible(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) || this.isBucketInChestAvaible(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) || this.isBucketInChestAvaible(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
    }

    public boolean isBucketInChestAvaible(int x, int y, int z) {
        if (!(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityChest)) {
            return false;
        }
        TileEntityChest chest = (TileEntityChest)this.field_145850_b.func_147438_o(x, y, z);
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i) == null || chest.func_70301_a(i).func_77973_b() != Items.field_151133_ar) continue;
            return true;
        }
        return false;
    }

    public boolean deliverLavaToGeo() {
        TileEntityGeoGenerator geo;
        boolean flag = false;
        if (!flag && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityGeoGenerator && (geo = (TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).canTakeBucket()) {
            flag = true;
            geo.distributeLava(1000);
        }
        if (!flag && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityGeoGenerator && (geo = (TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).canTakeBucket()) {
            flag = true;
            geo.distributeLava(1000);
        }
        if (!flag && this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityGeoGenerator && (geo = (TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).canTakeBucket()) {
            flag = true;
            geo.distributeLava(1000);
        }
        if (!flag && this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityGeoGenerator && (geo = (TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).canTakeBucket()) {
            flag = true;
            geo.distributeLava(1000);
        }
        if (!flag && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityGeoGenerator && (geo = (TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).canTakeBucket()) {
            flag = true;
            geo.distributeLava(1000);
        }
        if (!flag && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityGeoGenerator && (geo = (TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).canTakeBucket()) {
            flag = true;
            geo.distributeLava(1000);
        }
        return flag;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiPump";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    @Override
    public int getEnergyUsage() {
        return 1;
    }
}

