/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.block.machine.tileentity.TileEntityAdvancedMachine;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.slot.SlotDischarge;
import ic2.core.slot.SlotOutput;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntitySingularity
extends TileEntityAdvancedMachine {
    public TileEntityPump validPump;

    public TileEntitySingularity() {
        super(3, 15, 4000);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiSingularity";
    }

    public int[] func_94128_d(int side) {
        return new int[]{1, 2};
    }

    @Override
    public RecipeOutput getResultFor(ItemStack input, boolean adjusted) {
        RecipeOutput output;
        RecipeOutput recipeOutput = output = input == null ? null : Recipes.compressor.getOutputFor(input, adjusted);
        if (output == null) {
            if (this.getValidPump() != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("Pump", true);
                return new RecipeOutput(nbt, new ItemStack(Items.field_151126_ay));
            }
            return null;
        }
        return output;
    }

    @Override
    public boolean canWorkWithoutItems() {
        return true;
    }

    @Override
    public void operateOnce(RecipeOutput result, int slot, List<ItemStack> items) {
        super.operateOnce(result, slot, items);
        ItemStack item = result.items.get(0);
        if (item != null && item.func_77973_b() == Items.field_151126_ay && result.metadata != null && result.metadata.func_74767_n("Pump")) {
            TileEntityPump pump = this.getValidPump();
            if (pump == null) {
                return;
            }
            pump.pumpCharge = 0;
            this.getNetwork().updateTileGuiField(pump, "pumpCharge");
            this.field_145850_b.func_147468_f(pump.field_145851_c, pump.field_145848_d - 1, pump.field_145849_e);
        }
    }

    public TileEntityPump getValidPump() {
        TileEntityPump pump;
        if (this.validPump != null && !this.validPump.func_145837_r() && this.validPump.isPumpReady() && this.validPump.isWaterBelow()) {
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityPump && (pump = (TileEntityPump)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).isPumpReady() && pump.isWaterBelow()) {
            this.validPump = pump;
            return this.validPump;
        }
        return null;
    }

    @Override
    public Slot[] getInvSlots(InventoryPlayer par2) {
        Slot[] slots = new Slot[]{new SlotDischarge(this, Integer.MAX_VALUE, 0, 56, 53), new Slot((IInventory)this, 1, 56, 17), new SlotOutput(par2.field_70458_d, this, 2, 116, 35)};
        return slots;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{2};
    }

    @Override
    public String func_145825_b() {
        return "Singularity Compressor";
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        for (IRecipeInput input : Recipes.compressor.getRecipes().keySet()) {
            if (!input.matches(par1)) continue;
            return super.isValidInput(par1);
        }
        return false;
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/CompressorOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public boolean isInputSlot(int slotID) {
        return slotID == 1;
    }

    @Override
    public boolean isOutputSlot(int slotID) {
        return slotID == 2;
    }

    @Override
    public IMachineRecipeManager getRecipeList() {
        return Recipes.compressor;
    }
}

