/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.Direction;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBlock;
import ic2.core.item.boats.EntityClassicBoat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class TileEntityTeleporter
extends TileEntityBlock
implements INetworkTileEntityEventListener {
    private static Direction[] directions;
    public boolean targetSet = false;
    public int targetX;
    public int targetY;
    public int targetZ;
    public int targetDimension;
    private AudioSource audioSource = null;
    private static int EventTeleport;

    public TileEntityTeleporter() {
        this.addNetworkFields("targetX", "targetY", "targetZ", "targetDimension");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.targetSet = nbttagcompound.func_74767_n("targetSet");
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
        this.targetDimension = nbttagcompound.func_74762_e("targetDimension");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("targetSet", this.targetSet);
        nbttagcompound.func_74768_a("targetX", this.targetX);
        nbttagcompound.func_74768_a("targetY", this.targetY);
        nbttagcompound.func_74768_a("targetZ", this.targetZ);
        nbttagcompound.func_74768_a("targetDimension", this.targetDimension);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isSimulating()) {
            if (this.targetSet && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                World world = this.getWorld();
                if (world == null) {
                    this.setActive(false);
                } else {
                    boolean prevWorldChunkLoadOverride = world.field_72987_B;
                    world.field_72987_B = true;
                    Chunk chunk = world.func_72863_F().func_73154_d(this.targetX >> 4, this.targetZ >> 4);
                    world.field_72987_B = prevWorldChunkLoadOverride;
                    if (chunk == null || chunk.func_150810_a(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Block.func_149634_a((Item)Ic2Items.teleporter.func_77973_b()) || chunk.func_76628_c(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.func_77960_j()) {
                        this.targetSet = false;
                        this.setActive(false);
                    } else {
                        this.setActive(true);
                        List entitiesNearby = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2)));
                        if (!entitiesNearby.isEmpty()) {
                            double minDistanceSquared = Double.MAX_VALUE;
                            Entity closestEntity = null;
                            for (Entity entity : entitiesNearby) {
                                double distSquared;
                                if (entity.field_70154_o != null || entity.field_70128_L || (distSquared = ((double)this.field_145851_c - entity.field_70165_t) * ((double)this.field_145851_c - entity.field_70165_t) + ((double)(this.field_145848_d + 1) - entity.field_70163_u) * ((double)(this.field_145848_d + 1) - entity.field_70163_u) + ((double)this.field_145849_e - entity.field_70161_v) * ((double)this.field_145849_e - entity.field_70161_v)) >= minDistanceSquared) continue;
                                minDistanceSquared = distSquared;
                                closestEntity = entity;
                            }
                            this.teleport(closestEntity);
                        }
                    }
                }
            } else {
                this.setActive(false);
            }
        }
        if (this.isRendering() && this.getActive()) {
            this.spawnBlueParticles(2, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public World getWorld() {
        return MinecraftServer.func_71276_C().func_71218_a(this.targetDimension);
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public void teleport(Entity user) {
        boolean dimSwitch;
        double distance = Math.sqrt((this.field_145851_c - this.targetX) * (this.field_145851_c - this.targetX) + (this.field_145848_d - this.targetY) * (this.field_145848_d - this.targetY) + (this.field_145849_e - this.targetZ) * (this.field_145849_e - this.targetZ));
        int weight = this.getWeightOf(user);
        boolean bl = dimSwitch = this.field_145850_b.field_73011_w.field_76574_g != this.targetDimension;
        if (weight == 0) {
            return;
        }
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0);
        if (dimSwitch) {
            energyCost *= 10;
        }
        if (energyCost > this.getAvailableEnergy()) {
            return;
        }
        this.consumeEnergy(energyCost);
        if (user instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)user;
            if (!IC2.enableTeleporterInventory) {
                player.field_71071_by.func_70436_m();
            }
            if (dimSwitch) {
                user.func_70080_a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.func_70033_W(), (double)this.targetZ + 0.5, user.field_70177_z, user.field_70125_A);
            } else {
                player.func_70634_a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.func_70033_W(), (double)this.targetZ + 0.5);
            }
        } else {
            user.func_70080_a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.func_70033_W(), (double)this.targetZ + 0.5, user.field_70177_z, user.field_70125_A);
        }
        if (dimSwitch) {
            this.switchDimension(user);
        }
        IC2.network.get().initiateTileEntityEvent(this, 0, true);
        if (user instanceof EntityPlayer && distance >= 1000.0) {
            IC2.achievements.issueAchievement((EntityPlayer)user, "teleportFarAway");
        }
    }

    public boolean isDimSwtich() {
        return this.field_145850_b.field_73011_w.field_76574_g != this.targetDimension;
    }

    public double getDistance() {
        return Math.sqrt((this.field_145851_c - this.targetX) * (this.field_145851_c - this.targetX) + (this.field_145848_d - this.targetY) * (this.field_145848_d - this.targetY) + (this.field_145849_e - this.targetZ) * (this.field_145849_e - this.targetZ));
    }

    public void spawnBlueParticles(int n, World dim, int x, int y, int z) {
        for (int i = 0; i < n; ++i) {
            dim.func_72869_a("reddust", (double)((float)x + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)(y + 1) + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)z + this.field_145850_b.field_73012_v.nextFloat()), -1.0, 0.0, 1.0);
            dim.func_72869_a("reddust", (double)((float)x + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)(y + 2) + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)z + this.field_145850_b.field_73012_v.nextFloat()), -1.0, 0.0, 1.0);
        }
    }

    public void switchDimension(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            TileEntityTeleporter.transferPlayerToDimension((EntityPlayerMP)entity, this.targetDimension);
        } else {
            TileEntityTeleporter.transferEntityToWorld(entity, (WorldServer)this.field_145850_b, (WorldServer)this.getWorld());
        }
    }

    public static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        oldWorld.func_72973_f(entity);
        entity.field_70128_L = false;
        entity.field_71093_bK = newWorld.field_73011_w.field_76574_g;
        if (entity.func_70089_S()) {
            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        entity.func_70029_a((World)newWorld);
    }

    public static void transferPlayerToDimension(EntityPlayerMP player, int dimension) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ServerConfigurationManager manager = server.func_71203_ab();
        int oldDim = player.field_71093_bK;
        WorldServer worldserver = server.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimension;
        WorldServer worldserver1 = server.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldserver.func_72973_f((Entity)player);
        player.field_70128_L = false;
        if (player.func_70089_S()) {
            player.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            worldserver1.func_72838_d((Entity)player);
            worldserver1.func_72866_a((Entity)player, false);
        }
        player.func_70029_a((World)worldserver1);
        manager.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        manager.func_72354_b(player, worldserver1);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }

    public void consumeEnergy(int energy) {
        LinkedList<IEnergyStorage> energySources = new LinkedList<IEnergyStorage>();
        for (Direction direction : directions) {
            IEnergyStorage energySource;
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IEnergyStorage) || !(energySource = (IEnergyStorage)target).isTeleporterCompatible(direction.getInverse().toForgeDirection()) || energySource.getStored() <= 0) continue;
            energySources.add(energySource);
        }
        while (energy > 0) {
            int drain = (energy + energySources.size() - 1) / energySources.size();
            Iterator it = energySources.iterator();
            while (it.hasNext()) {
                IEnergyStorage energySource2 = (IEnergyStorage)it.next();
                if (drain > energy) {
                    drain = energy;
                }
                if (energySource2.getStored() <= drain) {
                    energy -= energySource2.getStored();
                    energySource2.setStored(0);
                    it.remove();
                    continue;
                }
                energy -= drain;
                energySource2.addEnergy(-drain);
            }
        }
    }

    public int getAvailableEnergy() {
        int energy = 0;
        for (Direction direction : directions) {
            IEnergyStorage storage;
            TileEntity target = direction.applyToTileEntity(this);
            if (!(target instanceof IEnergyStorage) || !(storage = (IEnergyStorage)target).isTeleporterCompatible(direction.getInverse().toForgeDirection())) continue;
            energy += storage.getStored();
        }
        return energy;
    }

    public int getWeightOf(Entity user) {
        int weight = 0;
        Entity ce = user;
        while (ce != null) {
            int i;
            if (ce instanceof EntityItem) {
                ItemStack is = ((EntityItem)ce).func_92059_d();
                weight += 100 * is.field_77994_a / is.func_77976_d();
            } else if (ce instanceof EntityAnimal || ce instanceof EntityMinecart || ce instanceof EntityBoat || ce instanceof EntityClassicBoat) {
                weight += 100;
            } else if (ce instanceof EntityPlayer) {
                weight += 1000;
                if (IC2.enableTeleporterInventory) {
                    InventoryPlayer inv = ((EntityPlayer)ce).field_71071_by;
                    for (i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack stack = inv.func_70301_a(i);
                        if (stack == null) continue;
                        weight += 100 * stack.field_77994_a / stack.func_77976_d();
                    }
                }
            } else if (ce instanceof EntityGhast) {
                weight += 2500;
            } else if (ce instanceof EntityDragon || ce instanceof EntityWither) {
                weight += 10000;
            } else if (ce instanceof EntityCreature) {
                weight += 500;
            }
            if (IC2.enableTeleporterInventory && ce instanceof EntityLivingBase && !(ce instanceof EntityPlayer)) {
                EntityLivingBase living = (EntityLivingBase)ce;
                for (i = 0; i <= 4; ++i) {
                    ItemStack item = living.func_71124_b(i);
                    if (item == null) continue;
                    weight += 100 * item.field_77994_a / item.func_77976_d();
                }
            }
            ce = ce.field_70153_n;
        }
        return weight;
    }

    public void setTarget(int dim, int x, int y, int z) {
        this.targetSet = true;
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.targetDimension = dim;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/Teleporter/TeleChargedLoop.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, IC2.audioManager.defaultVolume);
                IC2.audioManager.playOnce(new AudioPosition(this.field_145850_b, (float)this.targetX + 0.5f, (float)this.targetY + 0.5f, (float)this.targetZ + 0.5f), PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, IC2.audioManager.defaultVolume);
                this.spawnBlueParticles(20, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.spawnBlueParticles(20, this.getWorld(), this.targetX, this.targetY, this.targetZ);
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\nT: " + this + " (" + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e + ")");
            }
        }
    }

    static {
        EventTeleport = 0;
        directions = Direction.values();
    }
}

