/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.machine.container.ContainerUraniumEnricher;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.item.reactor.ItemReactorEnrichUranium;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class TileEntityUraniumEnricher
extends TileEntityElecMachine
implements IHasGui {
    public byte type = (byte)-1;
    public int amount = 0;
    public int uranProgress = 0;
    public int itemProgress = 0;
    public static final int maxUranProgress = 1000;
    public static final int maxItemProgress = 100;

    public TileEntityUraniumEnricher() {
        super(3, -1, 50000, 128, 2);
    }

    @Override
    public int getEnergyUsage() {
        return (this.inventory[0] != null ? this.getEnergyUseFromUranType() : 0) + (this.inventory[1] != null ? 20 : 0);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1, 2};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 2;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (i == 0) {
            return Ic2Items.uraniumIngot.func_77969_a(itemstack);
        }
        if (i == 1) {
            return this.isMatchingUraniumType(itemstack);
        }
        return false;
    }

    @Override
    public String func_145825_b() {
        return "Uranium Enricher";
    }

    @Override
    public void func_145845_h() {
        ItemStack item = this.inventory[0];
        if (item != null && item.func_77969_a(Ic2Items.uraniumIngot) && item.field_77994_a > 0 && this.type != -1 && this.amount >= 100) {
            ItemStack result = ItemReactorEnrichUranium.UraniumType.values()[this.type].getIngot();
            int use = this.getEnergyUseFromUranType();
            if (this.hasEnergy(use) && (this.inventory[2] == null || this.inventory[2].func_77969_a(result) && this.inventory[2].field_77994_a < this.inventory[2].func_77976_d())) {
                this.useEnergy(use);
                ++this.uranProgress;
                if (this.uranProgress >= 1000) {
                    this.uranProgress = 0;
                    this.amount -= 100;
                    if (this.amount <= 0) {
                        this.amount = 0;
                        this.type = (byte)-1;
                        this.getNetwork().updateTileGuiField(this, "type");
                    }
                    if (this.inventory[2] == null) {
                        this.inventory[2] = result.func_77946_l();
                    } else if (this.inventory[2].func_77969_a(result)) {
                        ++this.inventory[2].field_77994_a;
                    }
                    --item.field_77994_a;
                    if (item.field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                    this.getNetwork().updateTileGuiField(this, "amount");
                }
                this.getNetwork().updateTileGuiField(this, "uranProgress");
            }
        } else if (this.uranProgress != 0) {
            this.uranProgress = 0;
            this.getNetwork().updateTileGuiField(this, "uranProgress");
        }
        if (this.inventory[1] != null && this.inventory[1].field_77994_a > 0 && this.isMatchingUraniumType(this.inventory[1])) {
            ItemStack fuel = this.inventory[1];
            byte itemType = this.getTypeFromItem(fuel);
            int extra = this.getAmountFromType(itemType);
            if ((this.type == -1 || this.type == itemType && this.amount + extra <= 1000) && this.hasEnergy(20)) {
                ++this.itemProgress;
                this.useEnergy(20);
                if (this.itemProgress >= 100) {
                    this.itemProgress = 0;
                    --fuel.field_77994_a;
                    if (fuel.field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                    if (this.type == -1) {
                        this.type = itemType;
                        this.getNetwork().updateTileGuiField(this, "type");
                    }
                    this.amount += extra;
                    if (this.amount > 1000) {
                        this.amount = 1000;
                    }
                    this.getNetwork().updateTileGuiField(this, "amount");
                }
                this.getNetwork().updateTileGuiField(this, "itemProgress");
            }
        } else if (this.itemProgress != 0) {
            this.itemProgress = 0;
            this.getNetwork().updateTileGuiField(this, "itemProgress");
        }
    }

    private byte getTypeFromItem(ItemStack fuel) {
        if (this.type != -1) {
            return this.type;
        }
        for (ItemReactorEnrichUranium.UraniumType uran : ItemReactorEnrichUranium.UraniumType.values()) {
            if (!fuel.func_77969_a(uran.getItem())) continue;
            return (byte)uran.ordinal();
        }
        return 0;
    }

    private int getAmountFromType(byte par1) {
        switch (par1) {
            case 0: {
                return 25;
            }
            case 1: {
                return 200;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 200;
            }
            case 4: {
                return 25;
            }
        }
        return 0;
    }

    private boolean isMatchingUraniumType(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        if (this.type == -1) {
            for (ItemReactorEnrichUranium.UraniumType type : ItemReactorEnrichUranium.UraniumType.values()) {
                if (!par1.func_77969_a(type.getItem())) continue;
                return true;
            }
            return false;
        }
        return par1.func_77969_a(ItemReactorEnrichUranium.UraniumType.values()[this.type].getItem());
    }

    private int getEnergyUseFromUranType() {
        switch (this.type) {
            case 0: {
                return 25;
            }
            case 1: {
                return 20;
            }
            case 2: {
                return 75;
            }
            case 3: {
                return 150;
            }
            case 4: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer p0) {
        return new ContainerUraniumEnricher(this, p0.field_71071_by);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiUraniumEnricher";
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
    }
}

