/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.item.IMachineUpgradeItem;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.RecipeOutput;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityAdvancedMachine;
import ic2.core.block.machine.tileentity.TileEntityCanner;
import ic2.core.block.machine.tileentity.TileEntityElectrolyzer;
import ic2.core.item.ItemFuelCanEmpty;
import ic2.core.slot.SlotDischarge;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityVacuumCanner
extends TileEntityAdvancedMachine {
    public int fuelQuality = 0;
    public int step = 0;
    public int mode = 0;

    public TileEntityVacuumCanner() {
        super(6, 15, 3000);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuelQuality = nbt.func_74762_e("Fuel");
        this.step = nbt.func_74762_e("Step");
        this.mode = nbt.func_74762_e("Mode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Fuel", this.fuelQuality);
        nbt.func_74768_a("Step", this.step);
        nbt.func_74768_a("Mode", this.mode);
    }

    @Override
    public String getGuiClassName(EntityPlayer p0) {
        return "block.machine.gui.GuiVacuum";
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{1, 2, 3, 4, 5};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (itemstack == null) {
            return false;
        }
        if (i == 1) {
            if (itemstack.func_77973_b() == Ic2Items.fuelCan.func_77973_b() || itemstack.func_77973_b() == Ic2Items.jetpack.func_77973_b()) {
                return true;
            }
            if (itemstack.func_77973_b() == Ic2Items.constructionFoamSprayer.func_77973_b() || itemstack.func_77973_b() == Ic2Items.cfPack.func_77973_b()) {
                return true;
            }
            return itemstack.func_77973_b() == Ic2Items.tinCan.func_77973_b();
        }
        if (i == 2 || i == 3 || i == 4) {
            if (this.mode == 1) {
                return this.getFoodValue(itemstack) > 0;
            }
            if (this.mode == 2) {
                return this.validFuel(itemstack);
            }
            if (this.mode == 3) {
                return this.getPelletValue(itemstack) > 0;
            }
            return false;
        }
        if (i == 5) {
            return false;
        }
        return super.func_102007_a(i, itemstack, j);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        if (i == 5) {
            return super.func_102008_b(i, itemstack, j);
        }
        return false;
    }

    @Override
    public boolean isInputSlot(int slotID) {
        return slotID >= 1 && slotID < 5;
    }

    @Override
    public boolean isOutputSlot(int slotID) {
        return slotID == 5;
    }

    @Override
    public RecipeOutput getResultFor(ItemStack input, boolean adjusted) {
        return null;
    }

    @Override
    public Slot[] getInvSlots(InventoryPlayer par2) {
        Slot[] slot = new Slot[]{new SlotDischarge(this, 0, 30, 45), new Slot((IInventory)this, 1, 69, 53), new Slot((IInventory)this, 2, 51, 17), new Slot((IInventory)this, 3, 69, 17), new Slot((IInventory)this, 4, 87, 17), new SlotFurnace(par2.field_70458_d, (IInventory)this, 5, 119, 35)};
        return slot;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{5};
    }

    @Override
    public String func_145825_b() {
        return "Vacuum Canner";
    }

    @Override
    public int getClientOperationLenght() {
        switch (this.mode) {
            case 1: {
                return 800 * this.getFoodValue(this.inventory[2]);
            }
            case 2: {
                return 12000;
            }
            case 3: {
                return 1200;
            }
        }
        return 1500;
    }

    @Override
    public int getClientProgress() {
        return this.step * 800 + super.getClientProgress();
    }

    @Override
    public int getOperationLenght() {
        switch (this.mode) {
            case 1: {
                return 800 * this.getFoodValue(this.inventory[2]);
            }
            case 2: {
                return 800;
            }
            case 3: {
                return 1200;
            }
        }
        return 3000;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.sortInventory();
        }
        int oldMode = this.mode;
        this.mode = this.getMode();
        this.getNetwork().updateTileGuiField(this, "mode");
        if (oldMode == 2 && this.mode != 2) {
            this.fuelQuality = 0;
            this.step = 0;
            this.getNetwork().updateTileGuiField(this, "step");
        }
        super.func_145845_h();
    }

    private void sortInventory() {
        for (int i = 2; i < 4; ++i) {
            int left;
            if (this.inventory[i] == null && this.inventory[i + 1] != null) {
                this.inventory[i] = this.inventory[i + 1].func_77946_l();
                this.inventory[i + 1] = null;
                continue;
            }
            if (this.inventory[i] == null || this.inventory[i + 1] == null || !this.inventory[i].func_77969_a(this.inventory[i + 1]) || !ItemStack.func_77970_a((ItemStack)this.inventory[i], (ItemStack)this.inventory[i + 1]) || (left = this.inventory[i].func_77976_d() - this.inventory[i].field_77994_a) <= 0) continue;
            if (left >= this.inventory[i + 1].field_77994_a) {
                this.inventory[i].field_77994_a += this.inventory[i + 1].func_77946_l().field_77994_a;
                this.inventory[i + 1] = null;
                continue;
            }
            this.inventory[i].field_77994_a = this.inventory[i].func_77976_d();
            this.inventory[i + 1].field_77994_a -= left;
        }
    }

    @Override
    public void operate() {
        int food;
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        if (this.mode == 1 && (food = this.getFoodValue(this.inventory[2])) > 0) {
            results.add(new ItemStack(Ic2Items.filledTinCan.func_77973_b(), food, this.getFoodMeta(this.inventory[2])));
            this.inventory[1].field_77994_a -= food;
            --this.inventory[2].field_77994_a;
            if (this.inventory[1].field_77994_a <= 0) {
                this.inventory[1] = null;
            }
            if (this.inventory[2].field_77994_a <= 0) {
                this.inventory[2] = null;
            }
        }
        if (this.mode == 2) {
            if (this.step < 14) {
                ++this.step;
                this.getNetwork().updateTileGuiField(this, "step");
                this.handleStep();
                return;
            }
            this.handleStep();
            this.step = 0;
            this.getNetwork().updateTileGuiField(this, "step");
            --this.inventory[1].field_77994_a;
            if (this.inventory[1].func_77973_b() instanceof ItemFuelCanEmpty) {
                ItemStack result = new ItemStack(Ic2Items.filledFuelCan.func_77973_b());
                NBTTagCompound data = StackUtil.getOrCreateNbtData(result);
                data.func_74768_a("value", this.fuelQuality);
                data.func_74768_a("maxValue", this.fuelQuality);
                results.add(result);
                if (this.inventory[1].field_77994_a <= 0) {
                    this.inventory[1] = null;
                }
            } else if (this.inventory[1].func_77973_b() == Ic2Items.jetpack.func_77973_b()) {
                int damage = this.inventory[1].func_77960_j();
                if ((damage -= this.fuelQuality) < 1) {
                    damage = 1;
                }
                this.inventory[1] = null;
                results.add(new ItemStack(Ic2Items.jetpack.func_77973_b(), 1, damage));
            }
        }
        if (this.mode == 3) {
            ItemStack itemStack6 = this.inventory[2];
            --itemStack6.field_77994_a;
            this.inventory[1].func_77964_b(this.inventory[1].func_77960_j() - 2);
            if (this.inventory[1].func_77960_j() > 0) {
                return;
            }
            results.add(this.inventory[1].func_77946_l());
            this.inventory[1] = null;
        }
        if (results.size() > 0) {
            for (int i = 0; i < 2; ++i) {
                ItemStack itemStack = this.inventory[i + this.inventory.length - 2];
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IMachineUpgradeItem)) continue;
                IMachineUpgradeItem item = (IMachineUpgradeItem)itemStack.func_77973_b();
                item.onProcessEnd(itemStack, this, results);
            }
            if (results.size() > 0) {
                this.results.addAll(results);
                this.addToInventory();
            }
        }
    }

    @Override
    public RecipeOutput getOutput() {
        if (!this.results.isEmpty()) {
            return null;
        }
        switch (this.mode) {
            case 1: {
                int food = this.getFoodValue(this.inventory[2]);
                if (food > 0 && food <= this.inventory[1].field_77994_a) {
                    return new RecipeOutput(null, this.inventory[2].func_77946_l());
                }
            }
            case 2: {
                if (this.getFuelValue(this.inventory[2]) > 0) {
                    return new RecipeOutput(null, this.inventory[2].func_77946_l());
                }
            }
            case 3: {
                if (this.inventory[1].func_77960_j() < 2 || this.getPelletValue(this.inventory[2]) <= 0) break;
                return new RecipeOutput(null, this.inventory[2].func_77946_l());
            }
        }
        return null;
    }

    public int getMode() {
        if (this.inventory[1] == null) {
            return 0;
        }
        if (this.inventory[1].func_77973_b() == Ic2Items.tinCan.func_77973_b()) {
            return 1;
        }
        if (this.inventory[1].func_77973_b() instanceof ItemFuelCanEmpty || this.inventory[1].func_77973_b() == Ic2Items.jetpack.func_77973_b()) {
            return 2;
        }
        if (this.inventory[1].func_77973_b() == Ic2Items.cfPack.func_77973_b()) {
            return 3;
        }
        return 0;
    }

    private void handleStep() {
        this.fuelQuality += this.getFuelValue(this.inventory[2]);
        --this.inventory[2].field_77994_a;
        if (this.inventory[2].field_77994_a <= 0) {
            this.inventory[2] = null;
        }
    }

    private int getFoodValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (item.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)item.func_77973_b();
            return (int)Math.ceil((double)food.func_150905_g(item) / 2.0);
        }
        if (item.func_77973_b() == Items.field_151105_aU || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150414_aQ)) {
            return 6;
        }
        return 0;
    }

    public int getFuelValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        TileEntityElectrolyzer.ItemRecipe recipe = new TileEntityElectrolyzer.ItemRecipe(item);
        if (TileEntityCanner.fuelValues.containsKey(recipe) && TileEntityCanner.fuelMultiplyers.containsKey(recipe)) {
            throw new RuntimeException("Invalid case. This Item: " + item.func_82833_r() + " has a Mutiplyer and Fuel value. Which is not allowed. Crash!");
        }
        if (TileEntityCanner.fuelValues.containsKey(recipe)) {
            return TileEntityCanner.fuelValues.get(recipe);
        }
        if (TileEntityCanner.fuelMultiplyers.containsKey(recipe)) {
            return (int)((float)this.fuelQuality * TileEntityCanner.fuelMultiplyers.get(recipe).floatValue());
        }
        return 0;
    }

    public boolean validFuel(ItemStack item) {
        TileEntityElectrolyzer.ItemRecipe recipe = new TileEntityElectrolyzer.ItemRecipe(item);
        if (TileEntityCanner.fuelValues.containsKey(recipe) && TileEntityCanner.fuelMultiplyers.containsKey(recipe)) {
            throw new RuntimeException("Invalid case. This Item: " + item.func_82833_r() + " has a Mutiplyer and Fuel value. Which is not allowed. Crash!");
        }
        if (TileEntityCanner.fuelValues.containsKey(recipe)) {
            return true;
        }
        return TileEntityCanner.fuelMultiplyers.containsKey(recipe);
    }

    public int getPelletValue(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (item.func_77973_b() != Ic2Items.constructionFoamPellet.func_77973_b()) {
            return 0;
        }
        return item.field_77994_a;
    }

    private int getFoodMeta(ItemStack item) {
        if (item == null) {
            return 0;
        }
        TileEntityElectrolyzer.ItemRecipe ccip = new TileEntityElectrolyzer.ItemRecipe(item.func_77973_b(), item.func_77960_j());
        return TileEntityCanner.specialFood.containsKey(ccip) ? TileEntityCanner.specialFood.get(ccip) : 0;
    }

    @Override
    public boolean isValidInput(ItemStack itemstack) {
        if (itemstack.func_77973_b() == Ic2Items.fuelCan.func_77973_b() || itemstack.func_77973_b() == Ic2Items.jetpack.func_77973_b()) {
            return true;
        }
        if (itemstack.func_77973_b() == Ic2Items.constructionFoamSprayer.func_77973_b() || itemstack.func_77973_b() == Ic2Items.cfPack.func_77973_b()) {
            return true;
        }
        if (this.mode == 1) {
            return this.getFoodValue(itemstack) > 0;
        }
        if (this.mode == 2) {
            return this.validFuel(itemstack);
        }
        if (this.mode == 3) {
            return this.getPelletValue(itemstack) > 0;
        }
        return false;
    }

    @Override
    public IMachineRecipeManager getRecipeList() {
        return null;
    }
}

