/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergyConductorColored;
import ic2.api.event.PaintEvent;
import ic2.api.event.RetextureEvent;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.block.wiring.TileEntityCableDetector;
import ic2.core.block.wiring.TileEntityCableSplitter;
import ic2.core.item.tool.ItemToolCutter;
import ic2.core.util.AabbUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCable
extends BlockMultiID {
    private static Direction[] directions = Direction.values();

    public BlockCable() {
        super(Material.field_151573_f);
        this.func_149711_c(0.2f);
        this.func_149672_a(field_149775_l);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getTextureFile() {
        return "/ic2/sprites/block_cable.png";
    }

    @Override
    protected IIcon[] getIconSheet(int meta) {
        return Ic2Icons.getTexture("bcable");
    }

    @Override
    protected int getMaxSheetSize(int meta) {
        return 17;
    }

    @Override
    protected int getIconMeta(int meta) {
        return meta;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IIcon func_149673_e(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        int cableType;
        int baseTexture;
        int color;
        block7: {
            block8: {
                color = 0;
                TileEntity te = iblockaccess.func_147438_o(x, y, z);
                baseTexture = -1;
                if (!(te instanceof TileEntityCable)) break block8;
                TileEntityCable cable = (TileEntityCable)te;
                if (cable.foamed == 0) {
                    cableType = cable.cableType;
                    if (te instanceof TileEntityCableDetector || te instanceof TileEntityCableSplitter) {
                        baseTexture = te instanceof TileEntityCableDetector ? 272 : 274;
                        color = cable.getActive() ? 1 : 0;
                        break block7;
                    } else {
                        color = cable.color.ordinal();
                    }
                    break block7;
                } else {
                    Block block;
                    if (cable.foamed == 1) {
                        return Ic2Icons.getTexture("bcable")[276];
                    }
                    if (cable.foamed == 2 && cable.textureMimic && (block = cable.textureBlock[side]) != null && block != Blocks.field_150350_a) {
                        return block.func_149691_a(cable.textureSide[side], cable.textureMeta[side]);
                    }
                    return Ic2Icons.getTexture("bcable")[176 + cable.foamColor.ordinal()];
                }
            }
            cableType = iblockaccess.func_72805_g(x, y, z);
        }
        if (baseTexture != -1) {
            return Ic2Icons.getTexture("bcable")[baseTexture + color];
        }
        return Ic2Icons.getTexture("bcable")[cableType * 17 + color];
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return null;
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed > 0) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return super.func_149731_a(world, x, y, z, origin, absDirection);
        }
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        double halfThickness = (double)cable.getCableThickness() / 2.0;
        boolean hit = false;
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness)), intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            hit = true;
        }
        for (Direction dir : directions) {
            if (hit) break;
            if (!cable.canConnect(dir.toSideValue())) continue;
            AxisAlignedBB bbox = null;
            switch (dir) {
                case XN: {
                    bbox = AxisAlignedBB.func_72330_a((double)x, (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case XP: {
                    bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 1.0), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YN: {
                    bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)y, (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YP: {
                    bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 1.0), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case ZN: {
                    bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)z, (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5));
                    break;
                }
                case ZP: {
                    bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 1.0));
                }
            }
            intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
            if (intersectingDirection == null || !(intersection.func_72438_d(origin) <= maxLength)) continue;
            hit = true;
        }
        if (hit) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        double halfThickness = TileEntityCable.getCableThickness(meta);
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public AxisAlignedBB getCommonBoundingBoxFromPool(World world, int x, int y, int z, boolean selectionBoundingBox) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return this.getCollisionBoundingBoxFromPool(world, x, y, z, 3);
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed > 0) {
            return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        double halfThickness = (double)cable.getCableThickness() / 2.0;
        double minX = (double)x + 0.5 - halfThickness;
        double minY = (double)y + 0.5 - halfThickness;
        double minZ = (double)z + 0.5 - halfThickness;
        double maxX = (double)x + 0.5 + halfThickness;
        double maxY = (double)y + 0.5 + halfThickness;
        double maxZ = (double)z + 0.5 + halfThickness;
        if (cable.canConnect(ForgeDirection.WEST.ordinal())) {
            minX = x;
        }
        if (cable.canConnect(ForgeDirection.DOWN.ordinal())) {
            minY = y;
        }
        if (cable.canConnect(ForgeDirection.NORTH.ordinal())) {
            minZ = z;
        }
        if (cable.canConnect(ForgeDirection.EAST.ordinal())) {
            maxX = x + 1;
        }
        if (cable.canConnect(ForgeDirection.UP.ordinal())) {
            maxY = y + 1;
        }
        if (cable.canConnect(ForgeDirection.SOUTH.ordinal())) {
            maxZ = z + 1;
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        ItemStack cur = entityPlayer.func_71045_bC();
        if (cur != null) {
            if (!IC2.platform.isSimulating()) {
                return true;
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)te;
                if (cur.func_77969_a(new ItemStack((Block)Blocks.field_150354_m))) {
                    if (cable.foamed == 1 && cable.changeFoam((byte)2)) {
                        ItemStack itemStack = cur;
                        --itemStack.field_77994_a;
                        if (cur.field_77994_a <= 0) {
                            entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] = null;
                        }
                        return true;
                    }
                } else if (cur.func_77969_a(Ic2Items.constructionFoam) && cable.foamed == 0 && cable.changeFoam((byte)1)) {
                    ItemStack itemStack = cur;
                    --itemStack.field_77994_a;
                    if (cur.field_77994_a <= 0) {
                        entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static int getCableColor(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.func_147438_o(i, j, k);
        return te instanceof TileEntityCable ? ((TileEntityCable)te).color.ordinal() : 0;
    }

    @SubscribeEvent
    public void onPainted(PaintEvent event) {
        if (event.world.func_147439_a(event.x, event.y, event.z) != this) {
            return;
        }
        event.painted = ((TileEntityCable)event.world.func_147438_o(event.x, event.y, event.z)).changeColor(IEnergyConductorColored.WireColor.values()[event.color + 1]);
    }

    @SubscribeEvent
    public void onRetextured(RetextureEvent event) {
        if (event.world.func_147439_a(event.x, event.y, event.z) != this) {
            return;
        }
        event.applied = ((TileEntityCable)event.world.func_147438_o(event.x, event.y, event.z)).applyTexture(event.side, event.referencedBlock, event.referencedMeta, event.referencedSide);
    }

    public boolean canHarvestBlock(EntityPlayer player, int md) {
        return true;
    }

    public ArrayList getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, (int)cable.cableType));
        } else {
            ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, metadata));
        }
        return ret;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World world, int meta) {
        if (meta == 11) {
            return new TileEntityCableDetector((short)meta);
        }
        if (meta == 12) {
            return new TileEntityCableSplitter((short)meta);
        }
        return new TileEntityCable((short)meta);
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return IC2.platform.getRenderId("cable");
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149699_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.func_71045_bC(), world, i, j, k, (EntityLivingBase)entityplayer);
        }
    }

    public int func_149709_b(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        TileEntity te = iblockaccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityCableDetector) {
            return ((TileEntityCableDetector)te).getActive() ? 15 : 0;
        }
        return 0;
    }

    @Override
    public void func_149666_a(Item i, CreativeTabs tabs, List itemList) {
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return 0.2f;
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double src_x, double src_y, double src_z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed >= 2) {
                return 90.0f;
            }
        }
        return 6.0f;
    }

    public boolean canConnectRedstone(IBlockAccess world, int X, int Y, int Z, int direction) {
        int meta = world.func_72805_g(X, Y, Z);
        return meta == 11 || meta == 12;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)tile;
            return new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, (int)cable.cableType);
        }
        return new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, world.func_72805_g(x, y, z));
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        super.func_149726_b(par1World, par2, par3, par4);
        for (ForgeDirection dir : ForgeDirection.values()) {
            par1World.func_147460_e(par2, par3, par4, (Block)this);
        }
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        super.func_149695_a(par1World, par2, par3, par4, par5);
        TileEntity tile = par1World.func_147438_o(par2, par3, par4);
        if (tile != null && tile instanceof TileEntityCable) {
            ((TileEntityCable)tile).onBlockChange();
        }
    }

    @Override
    public void init() {
        Ic2Items.copperCableBlock = new ItemStack((Block)this, 1, 1);
        Ic2Items.insulatedCopperCableBlock = new ItemStack((Block)this, 1, 0);
        Ic2Items.goldCableBlock = new ItemStack((Block)this, 1, 2);
        Ic2Items.insulatedGoldCableBlock = new ItemStack((Block)this, 1, 3);
        Ic2Items.doubleInsulatedGoldCableBlock = new ItemStack((Block)this, 1, 4);
        Ic2Items.ironCableBlock = new ItemStack((Block)this, 1, 5);
        Ic2Items.insulatedIronCableBlock = new ItemStack((Block)this, 1, 6);
        Ic2Items.doubleInsulatedIronCableBlock = new ItemStack((Block)this, 1, 7);
        Ic2Items.trippleInsulatedIronCableBlock = new ItemStack((Block)this, 1, 8);
        Ic2Items.glassFiberCableBlock = new ItemStack((Block)this, 1, 9);
        Ic2Items.tinCableBlock = new ItemStack((Block)this, 1, 10);
        Ic2Items.detectorCableBlock = new ItemStack((Block)this, 1, 11);
        Ic2Items.splitterCableBlock = new ItemStack((Block)this, 1, 12);
        Ic2Items.bronzeCableBlock = new ItemStack((Block)this, 1, 13);
        Ic2Items.insulatedBronzeCableBlock = new ItemStack((Block)this, 1, 14);
        Ic2Items.doubleInsulatedBronzeCableBlock = new ItemStack((Block)this, 1, 15);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        int b0 = 4;
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < b0; ++k1) {
                    double d0 = (double)x + ((double)i1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)j1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)k1 + 0.5) / (double)b0;
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, meta).func_70596_a(x, y, z);
                    fx.func_110125_a(this.func_149673_e((IBlockAccess)world, x, y, z, 0));
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        Block block = worldObj.func_147439_a(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (block.func_149688_o() != Material.field_151579_a) {
            float f = 0.1f;
            double d0 = (double)target.field_72311_b + worldObj.field_73012_v.nextDouble() * (this.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
            double d1 = (double)target.field_72312_c + worldObj.field_73012_v.nextDouble() * (this.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
            double d2 = (double)target.field_72309_d + worldObj.field_73012_v.nextDouble() * (this.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
            if (target.field_72310_e == 0) {
                d1 = (double)target.field_72312_c + block.func_149665_z() - (double)f;
            }
            if (target.field_72310_e == 1) {
                d1 = (double)target.field_72312_c + block.func_149669_A() + (double)f;
            }
            if (target.field_72310_e == 2) {
                d2 = (double)target.field_72309_d + block.func_149706_B() - (double)f;
            }
            if (target.field_72310_e == 3) {
                d2 = (double)target.field_72309_d + block.func_149693_C() + (double)f;
            }
            if (target.field_72310_e == 4) {
                d0 = (double)target.field_72311_b + block.func_149704_x() - (double)f;
            }
            if (target.field_72310_e == 5) {
                d0 = (double)target.field_72311_b + block.func_149753_y() + (double)f;
            }
            EntityFX effect = new EntityDiggingFX(worldObj, d0, d1, d2, 0.0, 0.0, 0.0, block, worldObj.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d)).func_70596_a(target.field_72311_b, target.field_72312_c, target.field_72309_d).func_70543_e(0.2f).func_70541_f(0.6f);
            effect.func_110125_a(this.func_149673_e((IBlockAccess)worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d, target.field_72310_e));
            effectRenderer.func_78873_a(effect);
        }
        return true;
    }
}

