/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityChargePad;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockChargePads
extends BlockMultiID {
    public BlockChargePads() {
        super(Material.field_151573_f);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
        this.func_149711_c(1.5f);
        this.func_149663_c("chargePad");
        this.func_149672_a(field_149777_j);
        this.func_149647_a(IC2.tabIC2);
    }

    @Override
    public void init() {
        Ic2Items.lvChargePad = new ItemStack((Block)this, 1, TileEntityChargePad.ChargePadType.LV.ordinal());
        Ic2Items.mvChargePad = new ItemStack((Block)this, 1, TileEntityChargePad.ChargePadType.MV.ordinal());
        Ic2Items.hvChargePad = new ItemStack((Block)this, 1, TileEntityChargePad.ChargePadType.HV.ordinal());
        Ic2Items.nuclearChargePad = new ItemStack((Block)this, 1, TileEntityChargePad.ChargePadType.Nuclear.ordinal());
    }

    public int func_149692_a(int p_149692_1_) {
        return p_149692_1_;
    }

    @Override
    protected int getIconMeta(int meta) {
        return meta;
    }

    @Override
    protected int getMaxSheetSize(int meta) {
        return 4;
    }

    @Override
    protected IIcon[] getIconSheet(int meta) {
        return Ic2Icons.getTexture("CPad");
    }

    @Override
    public TileEntityBlock createNewTileEntity(World world, int meta) {
        TileEntityChargePad.ChargePadType[] types = TileEntityChargePad.ChargePadType.values();
        if (meta >= 0 && meta < types.length) {
            return types[meta].createPad();
        }
        return null;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.DOWN;
    }

    public int getRedstoneStrengh(IBlockAccess world, int x, int y, int z, int side) {
        if (side == ForgeDirection.DOWN.ordinal()) {
            return 0;
        }
        return this.isPadActive(world, x, y, z) ? 15 : 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.getRedstoneStrengh(world, x, y, z, side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.getRedstoneStrengh(world, x, y, z, side);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    private boolean isPadActive(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityChargePad) {
            TileEntityChargePad pad = (TileEntityChargePad)tile;
            if (pad.isForcedOff) {
                return false;
            }
            return pad.getActive();
        }
        return false;
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float maxImpact) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityChargePad.ChargePadType type = TileEntityChargePad.ChargePadType.getType(world.func_72805_g(x, y, z));
        if (type == null) {
            return;
        }
        if (type.maxImpact >= maxImpact) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70097_a((DamageSource)IC2DamageSource.electricity, (float)(3 + 3 * type.ordinal()));
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (world.field_72995_K || !(entity instanceof EntityLivingBase)) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityChargePad)) {
            return;
        }
        TileEntityChargePad pad = (TileEntityChargePad)tile;
        if (pad.isForcedOff) {
            return;
        }
        if (pad.getActive()) {
            pad.activeTime = 20;
            return;
        }
        pad.setActive(true);
        pad.activeTime = 20;
        IC2.network.get().initiateTileEntityEvent(pad, 1, true);
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (!world.func_72899_e(x + dir.offsetZ, y + dir.offsetY, z + dir.offsetZ)) continue;
            world.func_147460_e(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, (Block)this);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (!this.isPadActive((IBlockAccess)world, x, y, z)) {
            return;
        }
        ((TileEntityChargePad)world.func_147438_o(x, y, z)).spawnParticals(rand);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityChargePad) {
            TileEntityChargePad pad = (TileEntityChargePad)tile;
            if ((pad.installedUpgrades[TileEntityChargePad.PadUpgrade.Drain.ordinal()] || pad.installedUpgrades[TileEntityChargePad.PadUpgrade.Damage.ordinal()]) && side != ForgeDirection.DOWN.ordinal()) {
                return true;
            }
            return super.func_149727_a(world, x, y, z, entityPlayer, side, a, b, c);
        }
        return true;
    }
}

