/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergyConductorColored;
import ic2.api.event.PaintEvent;
import ic2.core.IC2;
import ic2.core.Ic2Icons;
import ic2.core.Ic2Items;
import ic2.core.block.BlockContainerCommon;
import ic2.core.block.wiring.TileEntityLuminatorMultipart;
import ic2.core.item.tool.ItemToolCutter;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockLuminatorMultipart
extends BlockContainerCommon {
    public static int renderPass = 0;
    public static int side = -1;
    ItemStack drop = null;

    public BlockLuminatorMultipart() {
        super(Material.field_151592_s);
        this.func_149672_a(field_149778_k);
        this.func_149711_c(0.3f);
        this.func_149752_b(0.5f);
        this.func_149647_a(IC2.tabIC2);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onColoring(PaintEvent event) {
        TileEntity tile = event.world.func_147438_o(event.x, event.y, event.z);
        if (!(tile instanceof TileEntityLuminatorMultipart)) {
            return;
        }
        TileEntityLuminatorMultipart lumi = (TileEntityLuminatorMultipart)tile;
        if (lumi.hasSide(event.side) && lumi.colors[event.side] == event.color || !lumi.hasSide(event.side) && lumi.cableColor == IEnergyConductorColored.WireColor.values()[event.color + 1]) {
            return;
        }
        event.painted = lumi.addColor(event.side, event.color);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return Ic2Icons.getTexture("b0")[31];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (renderPass == 0) {
            return super.func_149673_e(world, x, y, z, side);
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityLuminatorMultipart)) {
            return super.func_149673_e(world, x, y, z, side);
        }
        TileEntityLuminatorMultipart multiPart = (TileEntityLuminatorMultipart)tile;
        if (multiPart.cable == null) {
            return super.func_149673_e(world, x, y, z, side);
        }
        return Ic2Icons.getTexture("bcable")[multiPart.cable.func_77960_j() * 17 + multiPart.cableColor.ordinal()];
    }

    @Override
    public void init() {
        Ic2Items.luminatorMultipart = new ItemStack((Block)this);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityLuminatorMultipart();
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("luminatorMulti");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public void func_149699_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.func_71045_bC(), world, i, j, k, (EntityLivingBase)entityplayer);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block p_149695_5_) {
        super.func_149695_a(world, x, y, z, p_149695_5_);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminatorMultipart) {
            ((TileEntityLuminatorMultipart)tile).onBlockChange();
        }
    }

    public static float[] getBoundingBoxForSide(int side) {
        float px = 0.0625f;
        switch (side) {
            case 0: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f * px, 1.0f};
            }
            case 1: {
                return new float[]{0.0f, 15.0f * px, 0.0f, 1.0f, 1.0f, 1.0f};
            }
            case 2: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f * px};
            }
            case 3: {
                return new float[]{0.0f, 0.0f, 15.0f * px, 1.0f, 1.0f, 1.0f};
            }
            case 4: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f * px, 1.0f, 1.0f};
            }
            case 5: {
                return new float[]{15.0f * px, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminatorMultipart) {
            return ((TileEntityLuminatorMultipart)tile).getActive() ? 15 : 0;
        }
        return super.getLightValue(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        int color;
        TileEntity tile;
        if (side != -1 && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityLuminatorMultipart && (color = ((TileEntityLuminatorMultipart)tile).colors[side]) != -1) {
            return ItemDye.field_150922_c[color];
        }
        return super.func_149720_d(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block p_149749_5_, int p_149749_6_) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminatorMultipart) {
            this.drop = ((TileEntityLuminatorMultipart)tile).getDrop();
        }
        super.func_149749_a(world, x, y, z, p_149749_5_, p_149749_6_);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLuminatorMultipart) {
            items.add(((TileEntityLuminatorMultipart)tile).getDrop());
        } else if (this.drop != null) {
            items.add(this.drop);
        }
        return items;
    }

    public int func_149745_a(Random p_149745_1_) {
        return 0;
    }
}

